/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import org.jruby.nb.common.IRubyWarnings;
import org.jruby.nb.lexer.yacc.SyntaxException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.EditList;
import org.netbeans.modules.gsf.api.Hint;
import org.netbeans.modules.gsf.api.HintSeverity;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.PreviewableFix;
import org.netbeans.modules.gsf.api.Rule;
import org.netbeans.modules.gsf.api.RuleContext;
import org.netbeans.modules.ruby.RubyParser;
import org.netbeans.modules.ruby.hints.infrastructure.RubyErrorRule;
import org.netbeans.modules.ruby.hints.infrastructure.RubyRuleContext;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonSyntaxErrors
extends RubyErrorRule {
    @Override
    public Set<IRubyWarnings.ID> getCodes() {
        return Collections.singleton(IRubyWarnings.ID.SYNTAX_ERROR);
    }

    @Override
    public void run(RubyRuleContext rubyRuleContext, RubyParser.RubyError rubyError, List<Hint> list) {
        CompilationInfo compilationInfo = rubyRuleContext.compilationInfo;
        SyntaxException.PID pID = (SyntaxException.PID)rubyError.getParameters()[0];
        if (pID != SyntaxException.PID.GRAMMAR_ERROR) {
            return;
        }
        String string = rubyError.getDisplayName();
        if (string.indexOf("'='") == -1) {
            return;
        }
        try {
            BaseDocument baseDocument = rubyRuleContext.doc;
            int n = rubyError.getStartPosition();
            int n2 = LexUtilities.getLexerOffset((CompilationInfo)compilationInfo, (int)n);
            if (n2 == -1) {
                return;
            }
            if (n2 < baseDocument.getLength() - "begin".length() && "begin".equals(baseDocument.getText(n2, "begin".length()))) {
                OffsetRange offsetRange = new OffsetRange(n2 - 1, n2 + "=begin".length());
                FixDocIndent fixDocIndent = new FixDocIndent(rubyRuleContext, n2 - 1);
                List<FixDocIndent> list2 = Collections.singletonList(fixDocIndent);
                String string2 = NbBundle.getMessage(CommonSyntaxErrors.class, (String)"DontIndentDocs");
                Hint hint = new Hint((Rule)this, string2, compilationInfo.getFileObject(), offsetRange, list2, 500);
                list.add(hint);
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
    }

    public boolean appliesTo(RuleContext ruleContext) {
        return true;
    }

    public String getDisplayName() {
        return "X";
    }

    public boolean showInTasklist() {
        return true;
    }

    public HintSeverity getDefaultSeverity() {
        return HintSeverity.ERROR;
    }

    private class FixDocIndent
    implements PreviewableFix {
        private final RubyRuleContext context;
        private final int equalOffset;

        private FixDocIndent(RubyRuleContext rubyRuleContext, int n) {
            this.context = rubyRuleContext;
            this.equalOffset = n;
        }

        public String getDescription() {
            return NbBundle.getMessage(CommonSyntaxErrors.class, (String)"ReindentBegin");
        }

        public void implement() throws Exception {
            this.getEditList().apply();
        }

        public EditList getEditList() throws Exception {
            int n;
            String string;
            int n2;
            BaseDocument baseDocument = this.context.doc;
            if (this.equalOffset > baseDocument.getLength()) {
                return null;
            }
            EditList editList = new EditList(baseDocument);
            int n3 = Utilities.getRowStart((BaseDocument)baseDocument, (int)this.equalOffset);
            if (Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)this.equalOffset) < this.equalOffset) {
                editList.replace(this.equalOffset, 0, "\n", false, 0);
            } else {
                editList.replace(n3, this.equalOffset - n3, null, false, 0);
            }
            int n4 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n3) + 1;
            if (n4 < baseDocument.getLength() && (n2 = (string = baseDocument.getText(n4, baseDocument.getLength() - n4)).indexOf("=end")) != -1 && (n2 < (n = string.indexOf("=begin")) || n == -1)) {
                int n5 = n4 + n2;
                n3 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n5);
                if (Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n5) < n5) {
                    editList.replace(n5, 0, "\n", false, 1);
                } else {
                    editList.replace(n3, n5 - n3, null, false, 1);
                }
            }
            return editList;
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }

        public boolean canPreview() {
            return true;
        }
    }
}

