/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.mapper.model;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import org.netbeans.modules.bpel.mapper.model.BpelMapperUtils;
import org.netbeans.modules.bpel.mapper.model.ConnectionConstraint;
import org.netbeans.modules.bpel.mapper.model.GraphChangeProcessor;
import org.netbeans.modules.bpel.mapper.model.ItemHandler;
import org.netbeans.modules.bpel.mapper.model.MapperTcContext;
import org.netbeans.modules.bpel.mapper.model.VertexFactory;
import org.netbeans.modules.bpel.mapper.palette.Palette;
import org.netbeans.modules.bpel.mapper.tree.MapperSwingTreeModel;
import org.netbeans.modules.soa.mappercore.model.Graph;
import org.netbeans.modules.soa.mappercore.model.GraphSubset;
import org.netbeans.modules.soa.mappercore.model.Link;
import org.netbeans.modules.soa.mappercore.model.MapperModel;
import org.netbeans.modules.soa.mappercore.model.SourcePin;
import org.netbeans.modules.soa.mappercore.model.TargetPin;
import org.netbeans.modules.soa.mappercore.model.TreeSourcePin;
import org.netbeans.modules.soa.mappercore.model.Vertex;
import org.netbeans.modules.soa.mappercore.model.VertexItem;
import org.netbeans.modules.soa.mappercore.utils.Utils;
import org.netbeans.modules.soa.ui.tree.SoaTreeModel;
import org.netbeans.modules.xml.xpath.ext.metadata.ArgumentDescriptor;
import org.netbeans.modules.xml.xpath.ext.metadata.ArgumentGroup;
import org.netbeans.modules.xml.xpath.ext.metadata.XPathType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BpelMapperModel
implements MapperModel,
MapperTcContext.Provider {
    public final Graph STUB_GRAPH;
    private MapperTcContext mMapperTcContext;
    private GraphChangeProcessor mChangeProcessor;
    private MapperSwingTreeModel mLeftTreeModel;
    private MapperSwingTreeModel mRightTreeModel;
    private ConnectionConstraint[] mConnectionConstraints;
    private Map<TreePath, Graph> mPathGraphMap = new HashMap<TreePath, Graph>();
    private ItemHandler myHandler;

    public BpelMapperModel(MapperTcContext mapperTcContext, GraphChangeProcessor graphChangeProcessor, SoaTreeModel soaTreeModel, SoaTreeModel soaTreeModel2) {
        this.mMapperTcContext = mapperTcContext;
        this.mChangeProcessor = graphChangeProcessor;
        this.mLeftTreeModel = new MapperSwingTreeModel(this.mMapperTcContext, soaTreeModel);
        this.mRightTreeModel = new MapperSwingTreeModel(this.mMapperTcContext, soaTreeModel2);
        this.STUB_GRAPH = new Graph((MapperModel)this);
        this.mConnectionConstraints = new ConnectionConstraint[]{ConnectionConstraint.Access.getGeneralConstraint(this), ConnectionConstraint.Access.getPlConstraint(), ConnectionConstraint.Access.getMVarConstraint()};
    }

    @Override
    public MapperTcContext getMapperTcContext() {
        return this.mMapperTcContext;
    }

    public MapperSwingTreeModel getRightTreeModel() {
        return this.mRightTreeModel;
    }

    public MapperSwingTreeModel getLeftTreeModel() {
        return this.mLeftTreeModel;
    }

    public TreeSourcePin getTreeSourcePin(TreePath treePath) {
        return new TreeSourcePin(treePath);
    }

    public Graph getGraph(TreePath treePath) {
        Graph graph = this.mPathGraphMap.get(treePath);
        return graph == null ? this.STUB_GRAPH : graph;
    }

    public boolean searchGraphsInside(TreePath treePath) {
        Object object = treePath.getLastPathComponent();
        for (TreePath treePath2 : this.mPathGraphMap.keySet()) {
            while ((treePath2 = treePath2.getParentPath()) != null) {
                Object object2 = treePath2.getLastPathComponent();
                if (object2 != object) continue;
                return true;
            }
        }
        return false;
    }

    public void addGraph(Graph graph, TreePath treePath) {
        this.mPathGraphMap.put(treePath, graph);
        this.mRightTreeModel.fireTreeChanged(this, treePath);
    }

    public void deleteGraph(TreePath treePath) {
        Graph graph = this.mPathGraphMap.get(treePath);
        if (graph != null) {
            this.mPathGraphMap.remove(treePath);
        }
    }

    public void removeNestedGraphs(TreePath treePath) {
        Map<TreePath, Graph> map = this.getGraphsInside(treePath);
        Set<TreePath> set = map.keySet();
        boolean bl = false;
        for (TreePath treePath2 : set) {
            Graph graph = this.mPathGraphMap.get(treePath2);
            if (graph == null) continue;
            bl = this.emptyGraph(graph);
        }
        if (bl) {
            this.fireGraphsChanged(set);
        }
    }

    private boolean emptyGraph(Graph graph) {
        Object object2;
        boolean bl = false;
        List list = graph.getVerteces();
        for (Object object2 : list) {
            graph.removeVertex((Vertex)object2);
            bl = true;
        }
        List list2 = graph.getLinks();
        object2 = list2.iterator();
        while (object2.hasNext()) {
            Link link = (Link)object2.next();
            graph.removeLink(link);
            bl = true;
        }
        return bl;
    }

    public Graph graphRequired(TreePath treePath) {
        Graph graph = this.getGraph(treePath);
        if (graph == null || graph == this.STUB_GRAPH) {
            graph = new Graph((MapperModel)this);
            this.mPathGraphMap.put(treePath, graph);
        }
        return graph;
    }

    public Map<TreePath, Graph> getGraphsInside(TreePath treePath) {
        if (treePath == null || treePath.getLastPathComponent() == this.getRightTreeModel().getRoot()) {
            return this.mPathGraphMap;
        }
        HashMap<TreePath, Graph> hashMap = new HashMap<TreePath, Graph>();
        for (TreePath treePath2 : this.mPathGraphMap.keySet()) {
            if (!treePath.isDescendant(treePath2)) continue;
            Graph graph = this.mPathGraphMap.get(treePath2);
            assert (graph != null);
            hashMap.put(treePath2, graph);
        }
        Graph graph = this.mPathGraphMap.get(treePath);
        if (graph != null) {
            hashMap.put(treePath, graph);
        }
        return hashMap;
    }

    protected ConnectionConstraint[] getConstraints() {
        return this.mConnectionConstraints;
    }

    public boolean canConnect(TreePath treePath, SourcePin sourcePin, TargetPin targetPin, TreePath treePath2, Link link) {
        ConnectionConstraint[] connectionConstraintArray;
        for (ConnectionConstraint connectionConstraint : connectionConstraintArray = this.getConstraints()) {
            if (connectionConstraint.canConnect(treePath, sourcePin, targetPin, treePath2, link)) continue;
            return false;
        }
        return true;
    }

    public boolean canCopy(TreePath treePath, GraphSubset graphSubset) {
        return true;
    }

    public boolean canMove(TreePath treePath, GraphSubset graphSubset) {
        return true;
    }

    public void connect(TreePath treePath, SourcePin sourcePin, TargetPin targetPin, TreePath treePath2, Link link) {
        VertexItem vertexItem;
        Graph graph;
        Graph graph2 = this.getGraph(treePath);
        if (graph2 == this.STUB_GRAPH) {
            graph = new Graph((MapperModel)this);
            this.mPathGraphMap.put(treePath, graph);
            targetPin = graph;
        } else {
            graph = graph2;
        }
        if (targetPin instanceof VertexItem) {
            vertexItem = (VertexItem)targetPin;
            if (vertexItem.isHairline()) {
                Vertex vertex = vertexItem.getVertex();
                Object object = vertexItem.getDataObject();
                int n = vertex.getItemIndex(vertexItem);
                if (object instanceof ArgumentDescriptor) {
                    VertexItem vertexItem2 = VertexFactory.constructVItem(vertex, (ArgumentDescriptor)object);
                    vertex.addItem(vertexItem2, n + 1);
                    VertexItem vertexItem3 = VertexFactory.constructHairline(vertex, object);
                    vertex.addItem(vertexItem3, n + 2);
                    targetPin = vertexItem2;
                } else if (object instanceof ArgumentGroup) {
                    VertexItem vertexItem4;
                    List<VertexItem> list = VertexFactory.getInstance().createGroupItems(vertex, (ArgumentGroup)object);
                    VertexItem vertexItem5 = VertexFactory.constructHairline(vertex, object);
                    vertex.addItem(vertexItem5, n + 1);
                    ListIterator<VertexItem> listIterator = list.listIterator(list.size());
                    while (listIterator.hasPrevious()) {
                        vertexItem4 = listIterator.previous();
                        vertex.addItem(vertexItem4, n + 1);
                    }
                    vertexItem4 = null;
                    XPathType xPathType = BpelMapperUtils.calculateXPathSourcePinType(sourcePin);
                    if (xPathType != null) {
                        vertexItem4 = BpelMapperUtils.findBestFittedItem(list, xPathType);
                    }
                    if (vertexItem4 != null) {
                        targetPin = vertexItem4;
                    }
                }
            }
            vertexItem.setValue(null);
        }
        if (link == null) {
            vertexItem = new Link(sourcePin, targetPin);
            graph.addLink((Link)vertexItem);
        } else {
            link.setSource(sourcePin);
            link.setTarget(targetPin);
            graph.addLink(link);
            if (!Utils.equal((Object)treePath2, (Object)treePath)) {
                this.fireGraphChanged(treePath2);
                this.mRightTreeModel.fireTreeChanged(this, treePath2);
            }
        }
        this.fireGraphChanged(treePath);
        this.mRightTreeModel.fireTreeChanged(this, treePath);
    }

    public GraphSubset getGraphSubset(Transferable transferable) {
        for (DataFlavor dataFlavor : transferable.getTransferDataFlavors()) {
            try {
                Object[] objectArray = (Object[])transferable.getTransferData(dataFlavor);
                this.myHandler = (ItemHandler)objectArray[0];
                GraphSubset graphSubset = this.myHandler.createGraphSubset();
                Palette palette = (Palette)objectArray[1];
                if (graphSubset == null) continue;
                palette.hideMenu();
                return graphSubset;
            }
            catch (IOException iOException) {
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                // empty catch block
            }
        }
        return null;
    }

    private boolean isConnectable(TreePath treePath) {
        if (treePath == null) {
            return false;
        }
        return this.mRightTreeModel.isConnectable(treePath);
    }

    public GraphSubset add(TreePath treePath, ItemHandler itemHandler, int n, int n2) {
        this.myHandler = itemHandler;
        return this.doCopy(treePath, null, n, n2);
    }

    public GraphSubset copy(TreePath treePath, GraphSubset graphSubset, int n, int n2) {
        return this.doCopy(treePath, graphSubset, n, n2);
    }

    private GraphSubset doCopy(TreePath treePath, GraphSubset graphSubset, int n, int n2) {
        Vertex vertex;
        int n3;
        if (!this.isConnectable(treePath)) {
            return null;
        }
        if (this.myHandler != null) {
            if (this.myHandler.canAddGraphSubset()) {
                graphSubset = this.myHandler.createGraphSubset();
                this.myHandler = null;
            } else {
                graphSubset = null;
            }
        } else {
            graphSubset = new GraphSubset(graphSubset, treePath);
        }
        if (graphSubset == null) {
            return null;
        }
        Graph graph = this.graphRequired(treePath);
        int n4 = 0;
        int n5 = 0;
        if (graphSubset.getVertexCount() > 0) {
            n4 = graphSubset.getMinYVertex().getX();
            n5 = graphSubset.getMinYVertex().getY();
        }
        if (n2 < 0) {
            n2 = 0;
        }
        for (n3 = 0; n3 < graphSubset.getVertexCount(); ++n3) {
            vertex = graphSubset.getVertex(n3);
            int n6 = graphSubset.getVertex(n3).getX();
            int n7 = graphSubset.getVertex(n3).getY();
            vertex.setLocation(n6 - n4 + n, n7 - n5 + n2);
        }
        for (n3 = 0; n3 < graphSubset.getVertexCount(); ++n3) {
            vertex = graphSubset.getVertex(n3);
            graph.addVertex(vertex);
        }
        for (n3 = 0; n3 < graphSubset.getLinkCount(); ++n3) {
            vertex = graphSubset.getLink(n3);
            graph.addLink((Link)vertex);
        }
        this.fireGraphChanged(treePath);
        this.mRightTreeModel.fireTreeChanged(this, treePath);
        return graphSubset;
    }

    public void move(TreePath treePath, GraphSubset graphSubset, int n, int n2) {
        TreePath treePath2;
        int n3;
        if (!this.isConnectable(treePath)) {
            return;
        }
        if (graphSubset == null) {
            return;
        }
        Graph graph = this.graphRequired(treePath);
        Graph graph2 = null;
        ArrayList<Link> arrayList = new ArrayList<Link>();
        int n4 = 0;
        int n5 = 0;
        if (graphSubset.getVertexCount() > 0) {
            n4 = graphSubset.getMinYVertex().getX();
            n5 = graphSubset.getMinYVertex().getY();
        }
        if (n2 < 0) {
            n2 = 0;
        }
        for (n3 = graphSubset.getVertexCount() - 1; n3 >= 0; --n3) {
            int n6;
            Vertex vertex2 = graphSubset.getVertex(n3);
            if (vertex2.getGraph() == null) continue;
            graph2 = vertex2.getGraph();
            if (graph2 != graph) {
                graph.addVertex(vertex2);
                Link link = vertex2.getOutgoingLink();
                if (link != null && graph2 == link.getGraph()) {
                    graph2.removeLink(link);
                    arrayList.add(link);
                }
                for (n6 = vertex2.getItemCount() - 1; n6 >= 0; --n6) {
                    link = vertex2.getItem(n6).getIngoingLink();
                    if (link == null || graph2 != link.getGraph()) continue;
                    graph2.removeLink(link);
                    arrayList.add(link);
                }
            }
            int n7 = graphSubset.getVertex(n3).getX();
            n6 = graphSubset.getVertex(n3).getY();
            vertex2.setLocation(n7 - n4 + n, n6 - n5 + n2);
        }
        if (graph2 != graph) {
            for (n3 = graphSubset.getLinkCount() - 1; n3 >= 0; --n3) {
                Link link = graphSubset.getLink(n3);
                TargetPin targetPin = link.getTarget();
                SourcePin sourcePin = link.getSource();
                if (!(targetPin instanceof Graph) && graphSubset.containVertex(((VertexItem)targetPin).getVertex()) && (sourcePin instanceof TreeSourcePin || graphSubset.containVertex((Vertex)sourcePin))) {
                    graph.addLink(link);
                } else {
                    link.setSource(null);
                    link.setTarget(null);
                }
                arrayList.remove(link);
            }
            for (Link link : arrayList) {
                link.setSource(null);
                link.setTarget(null);
            }
        }
        if (!Utils.equal((Object)(treePath2 = graphSubset.getTreePath()), (Object)treePath)) {
            this.fireGraphChanged(treePath2);
            this.mRightTreeModel.fireTreeChanged(this, treePath2);
        }
        this.fireGraphChanged(treePath);
        this.mRightTreeModel.fireTreeChanged(this, treePath);
    }

    public void delete(TreePath treePath, GraphSubset graphSubset) {
        int n;
        HashSet<Link> hashSet = new HashSet<Link>();
        for (n = graphSubset.getVertexCount() - 1; n >= 0; --n) {
            List<Link> list = BpelMapperUtils.getConnectedLinkList(graphSubset.getVertex(n));
            hashSet.addAll(list);
        }
        for (n = graphSubset.getLinkCount() - 1; n >= 0; --n) {
            hashSet.add(graphSubset.getLink(n));
        }
        Graph graph = graphSubset.getGraph();
        for (Link link : hashSet) {
            link.disconnect();
        }
        for (int i = graphSubset.getVertexCount() - 1; i >= 0; --i) {
            graph.removeVertex(graphSubset.getVertex(i));
        }
        this.fireGraphChanged(treePath);
    }

    public boolean canEditInplace(VertexItem vertexItem) {
        return true;
    }

    public void fireGraphChanged(TreePath treePath) {
        if (this.mChangeProcessor != null) {
            this.mChangeProcessor.processChanges(treePath);
        }
    }

    public void fireGraphsChanged(Collection<TreePath> collection) {
        if (this.mChangeProcessor != null) {
            this.mChangeProcessor.processChanges(collection);
        }
    }

    public Object getRoot() {
        return this.mRightTreeModel.getRoot();
    }

    public Object getChild(Object object, int n) {
        return this.mRightTreeModel.getChild(object, n);
    }

    public int getChildCount(Object object) {
        return this.mRightTreeModel.getChildCount(object);
    }

    public boolean isLeaf(Object object) {
        return this.mRightTreeModel.isLeaf(object);
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
        this.mRightTreeModel.valueForPathChanged(treePath, object);
    }

    public int getIndexOfChild(Object object, Object object2) {
        return this.mRightTreeModel.getIndexOfChild(object, object2);
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.mRightTreeModel.addTreeModelListener(treeModelListener);
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.mRightTreeModel.removeTreeModelListener(treeModelListener);
    }

    public void valueChanged(TreePath treePath, VertexItem vertexItem, Object object) {
        if (object != null) {
            vertexItem.setValue(object);
            Link link = vertexItem.getIngoingLink();
            if (link != null) {
                link.disconnect();
            }
            this.fireGraphChanged(treePath);
            this.mRightTreeModel.fireTreeChanged(this, treePath);
        }
    }

    public List<TreePath> getDependentGraphs(Object object) {
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
        Map<TreePath, Graph> map = this.getGraphsInside(null);
        block0: for (TreePath treePath : map.keySet()) {
            Graph graph = map.get(treePath);
            List list = graph.getConnectedIngoingLinks(new ArrayList());
            for (Link link : list) {
                SourcePin sourcePin = link.getSource();
                assert (sourcePin instanceof TreeSourcePin);
                TreePath treePath2 = ((TreeSourcePin)sourcePin).getTreePath();
                if (!MapperSwingTreeModel.containsDataObject(treePath2, object)) continue;
                arrayList.add(treePath);
                continue block0;
            }
        }
        return arrayList;
    }

    public void removeIngoingLinks(TreePath treePath, TreePath treePath2) {
        Graph graph = this.getGraph(treePath);
        List list = graph.getIngoingLinks();
        for (Link link : list) {
            SourcePin sourcePin = link.getSource();
            assert (sourcePin instanceof TreeSourcePin);
            TreePath treePath3 = ((TreeSourcePin)sourcePin).getTreePath();
            if (treePath3 == null || !treePath2.isDescendant(treePath3)) continue;
            link.disconnect();
        }
    }
}

