/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.mapper.cast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.Callable;
import org.netbeans.modules.bpel.mapper.cast.AbstractTypeCast;
import org.netbeans.modules.bpel.mapper.cast.SyntheticTypeCast;
import org.netbeans.modules.bpel.mapper.cast.TypeCast;
import org.netbeans.modules.bpel.mapper.model.BpelMapperModel;
import org.netbeans.modules.bpel.mapper.model.PathConverter;
import org.netbeans.modules.bpel.mapper.tree.MapperSwingTreeModel;
import org.netbeans.modules.bpel.mapper.tree.models.VariableTreeModel;
import org.netbeans.modules.bpel.model.api.AbstractVariableDeclaration;
import org.netbeans.modules.bpel.model.api.BPELElementsBuilder;
import org.netbeans.modules.bpel.model.api.BpelContainer;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.ExtensibleElements;
import org.netbeans.modules.bpel.model.api.ExtensionEntity;
import org.netbeans.modules.bpel.model.api.Variable;
import org.netbeans.modules.bpel.model.api.support.XPathBpelVariable;
import org.netbeans.modules.bpel.model.ext.editor.api.Cast;
import org.netbeans.modules.bpel.model.ext.editor.api.Casts;
import org.netbeans.modules.bpel.model.ext.editor.api.Editor;
import org.netbeans.modules.bpel.model.ext.editor.api.PseudoComp;
import org.netbeans.modules.bpel.model.ext.editor.api.Source;
import org.netbeans.modules.soa.ui.tree.SoaTreeModel;
import org.netbeans.modules.soa.ui.tree.TreeItem;
import org.netbeans.modules.soa.ui.tree.impl.IterableExpander;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.openide.ErrorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CastManager {
    private LinkedList<CachedCast> mCachedCastList;
    private LinkedList<CachedVariableCast> mCachedCastedVarList;
    private boolean mInLeftMapperTree;
    private Object mSynchSource;

    public static CastManager getCastManager(BpelMapperModel bpelMapperModel, boolean bl) {
        BpelMapperModel bpelMapperModel2 = bpelMapperModel;
        MapperSwingTreeModel mapperSwingTreeModel = null;
        mapperSwingTreeModel = bl ? bpelMapperModel2.getLeftTreeModel() : bpelMapperModel2.getRightTreeModel();
        SoaTreeModel soaTreeModel = mapperSwingTreeModel.getSourceModel();
        CastManager castManager = CastManager.getCastManager(soaTreeModel);
        return castManager;
    }

    public static CastManager getCastManager(SoaTreeModel soaTreeModel) {
        VariableTreeModel variableTreeModel = (VariableTreeModel)SoaTreeModel.MyUtils.findExtensionModel((SoaTreeModel)soaTreeModel, VariableTreeModel.class);
        if (variableTreeModel != null) {
            CastManager castManager = variableTreeModel.getCastManager();
            return castManager;
        }
        return null;
    }

    public CastManager(Object object) {
        this(true, object);
    }

    public CastManager(boolean bl, Object object) {
        this.mInLeftMapperTree = bl;
        this.mSynchSource = object;
        this.mCachedCastList = new LinkedList();
        this.mCachedCastedVarList = new LinkedList();
    }

    public List<AbstractTypeCast> getTypeCast(TreeItem treeItem, SchemaComponent schemaComponent) {
        IterableExpander iterableExpander = new IterableExpander((Iterable)treeItem, (Object)schemaComponent);
        ArrayList<AbstractTypeCast> arrayList = new ArrayList<AbstractTypeCast>();
        for (CachedCast cachedCast : this.mCachedCastList) {
            if (!cachedCast.hasSameCastedCompLocation((Iterable)iterableExpander)) continue;
            arrayList.add(cachedCast.getTypeCast());
        }
        return arrayList;
    }

    public boolean addTypeCast(Cast cast) {
        List<Object> list;
        TypeCast typeCast = TypeCast.convert(cast);
        if (typeCast != null && (list = PathConverter.constructObjectLocationtList(typeCast.getPathExpression())) != null) {
            return this.addTypeCastImpl(list, typeCast);
        }
        return false;
    }

    private boolean addTypeCastImpl(List<Object> list, AbstractTypeCast abstractTypeCast) {
        XPathBpelVariable xPathBpelVariable = PathConverter.constructXPathBpelVariable(list);
        if (xPathBpelVariable != null) {
            return this.addCastedVariableImpl(xPathBpelVariable, abstractTypeCast);
        }
        for (CachedCast cachedCast : this.mCachedCastList) {
            if (!cachedCast.hasSameCastedCompPath(list) || !cachedCast.hasSameCastTo(abstractTypeCast)) continue;
            return false;
        }
        CachedCast cachedCast = new CachedCast(list, abstractTypeCast);
        this.mCachedCastList.add(cachedCast);
        return true;
    }

    public boolean addTypeCast(TreeItem treeItem, SyntheticTypeCast syntheticTypeCast) {
        List<Object> list = PathConverter.constructObjectLocationtList(treeItem, true, false);
        if (list != null && this.addTypeCastImpl(list, syntheticTypeCast)) {
            this.registerVariableTypeCast(syntheticTypeCast);
            return true;
        }
        return false;
    }

    public List<AbstractTypeCast> getCastedVariables(AbstractVariableDeclaration abstractVariableDeclaration, Part part) {
        ArrayList<AbstractTypeCast> arrayList = new ArrayList<AbstractTypeCast>();
        if (this.mCachedCastedVarList != null && !this.mCachedCastedVarList.isEmpty()) {
            XPathBpelVariable xPathBpelVariable = new XPathBpelVariable(abstractVariableDeclaration, part);
            for (CachedVariableCast cachedVariableCast : this.mCachedCastedVarList) {
                if (!cachedVariableCast.getCastedVariableDecl().equals((Object)xPathBpelVariable)) continue;
                arrayList.add(cachedVariableCast.getTypeCast());
            }
        }
        return arrayList;
    }

    public boolean addCastedVariable(AbstractVariableDeclaration abstractVariableDeclaration, Part part, AbstractTypeCast abstractTypeCast) {
        XPathBpelVariable xPathBpelVariable = new XPathBpelVariable(abstractVariableDeclaration, part);
        return this.addCastedVariableImpl(xPathBpelVariable, abstractTypeCast);
    }

    private boolean addCastedVariableImpl(XPathBpelVariable xPathBpelVariable, AbstractTypeCast abstractTypeCast) {
        for (CachedVariableCast cachedVariableCast : this.mCachedCastedVarList) {
            if (!cachedVariableCast.hasSameValues(xPathBpelVariable, abstractTypeCast)) continue;
            return false;
        }
        CachedVariableCast cachedVariableCast = new CachedVariableCast(xPathBpelVariable, abstractTypeCast);
        this.mCachedCastedVarList.add(cachedVariableCast);
        return true;
    }

    public void registerVariableTypeCast(final SyntheticTypeCast syntheticTypeCast) {
        final Variable variable = syntheticTypeCast.getBaseVariable();
        if (variable != null) {
            try {
                BpelModel bpelModel = variable.getBpelModel();
                bpelModel.invoke((Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        CastManager.this.registerTypeCast((ExtensibleElements)variable, syntheticTypeCast);
                        return null;
                    }
                }, this.mSynchSource);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify((Throwable)exception);
            }
        }
    }

    private Casts getCastsEntity(BPELElementsBuilder bPELElementsBuilder, ExtensibleElements extensibleElements, boolean bl) {
        Casts casts;
        Editor editor = null;
        List list = extensibleElements.getChildren(Editor.class);
        if (list != null && !list.isEmpty()) {
            editor = (Editor)list.get(0);
        }
        if (editor == null) {
            if (!bl) {
                return null;
            }
            casts = (Editor)bPELElementsBuilder.createExtensionEntity(Editor.class);
            editor = casts;
            extensibleElements.addExtensionEntity(Editor.class, (ExtensionEntity)editor);
        }
        if ((casts = editor.getCasts()) == null) {
            Casts casts2;
            if (!bl) {
                return null;
            }
            casts = casts2 = (Casts)bPELElementsBuilder.createExtensionEntity(Casts.class);
            editor.setCasts(casts);
        }
        return casts;
    }

    public void registerTypeCast(ExtensibleElements extensibleElements, AbstractTypeCast abstractTypeCast) {
        BpelModel bpelModel = extensibleElements.getBpelModel();
        BPELElementsBuilder bPELElementsBuilder = bpelModel.getBuilder();
        Casts casts = this.getCastsEntity(bPELElementsBuilder, extensibleElements, true);
        Cast cast = casts.getCasts();
        boolean bl = false;
        for (Cast cast2 : cast) {
            TypeCast typeCast;
            if (cast2.getSource() == Source.TO && this.mInLeftMapperTree || cast2.getSource() != Source.TO && !this.mInLeftMapperTree || (typeCast = TypeCast.convert(cast2)) == null || !typeCast.equals(abstractTypeCast)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            Cast cast3 = (Cast)bPELElementsBuilder.createExtensionEntity(Cast.class);
            casts.addCast(cast3);
            abstractTypeCast.populateCast(cast3, (BpelEntity)casts, this.mInLeftMapperTree);
        }
    }

    public void registerTypeCasts(ExtensibleElements extensibleElements, Collection<AbstractTypeCast> collection) {
        BpelModel bpelModel = extensibleElements.getBpelModel();
        BPELElementsBuilder bPELElementsBuilder = bpelModel.getBuilder();
        Casts casts = this.getCastsEntity(bPELElementsBuilder, extensibleElements, true);
        Cast cast = casts.getCasts();
        for (AbstractTypeCast abstractTypeCast : collection) {
            boolean bl = false;
            for (Cast cast2 : cast) {
                TypeCast typeCast;
                if (cast2.getSource() == Source.TO && this.mInLeftMapperTree || cast2.getSource() != Source.TO && !this.mInLeftMapperTree || (typeCast = TypeCast.convert(cast2)) == null || !typeCast.equals(abstractTypeCast)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            Cast cast3 = (Cast)bPELElementsBuilder.createExtensionEntity(Cast.class);
            casts.addCast(cast3);
            abstractTypeCast.populateCast(cast3, (BpelEntity)casts, this.mInLeftMapperTree);
        }
    }

    public void deleteTypeCast(final AbstractTypeCast abstractTypeCast) {
        final AbstractVariableDeclaration abstractVariableDeclaration = abstractTypeCast.getBaseVariable();
        if (abstractVariableDeclaration != null) {
            try {
                BpelModel bpelModel = ((BpelEntity)abstractVariableDeclaration).getBpelModel();
                bpelModel.invoke((Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        CastManager.this.unregisterTypeCast((ExtensibleElements)abstractVariableDeclaration, abstractTypeCast);
                        CastManager.this.clearEmptyEditorEntity((ExtensibleElements)abstractVariableDeclaration);
                        CastManager.this.removeTypeCast(abstractTypeCast);
                        return null;
                    }
                }, this.mSynchSource);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify((Throwable)exception);
            }
        }
    }

    public void unregisterTypeCast(ExtensibleElements extensibleElements, AbstractTypeCast abstractTypeCast) {
        BpelModel bpelModel = extensibleElements.getBpelModel();
        BPELElementsBuilder bPELElementsBuilder = bpelModel.getBuilder();
        Casts casts = this.getCastsEntity(bPELElementsBuilder, extensibleElements, false);
        if (casts == null) {
            return;
        }
        Cast[] castArray = casts.getCasts();
        for (int i = 0; i < castArray.length; ++i) {
            TypeCast typeCast;
            Cast cast = castArray[i];
            if (this.mInLeftMapperTree && cast.getSource() == Source.TO || !this.mInLeftMapperTree && cast.getSource() != Source.TO || (typeCast = TypeCast.convert(cast)) == null || !abstractTypeCast.equals(typeCast)) continue;
            casts.removeCast(i);
        }
    }

    public void clearEmptyEditorEntity(ExtensibleElements extensibleElements) {
        List list = extensibleElements.getChildren(Editor.class);
        for (Editor editor : list) {
            if (!this.clearEmptyContainer((BpelContainer)editor)) continue;
            extensibleElements.remove((BpelEntity)editor);
        }
    }

    private boolean clearEmptyContainer(BpelContainer bpelContainer) {
        List list = bpelContainer.getChildren();
        int n = list.size();
        int n2 = 0;
        for (BpelEntity bpelEntity : list) {
            if (bpelEntity instanceof Cast || bpelEntity instanceof PseudoComp || !(bpelEntity instanceof BpelContainer) || !this.clearEmptyContainer((BpelContainer)bpelEntity)) continue;
            bpelContainer.remove(bpelEntity);
            ++n2;
        }
        return n2 == n;
    }

    public void removeTypeCast(AbstractTypeCast abstractTypeCast) {
        Object object;
        Object object2;
        ListIterator listIterator = this.mCachedCastedVarList.listIterator();
        while (listIterator.hasNext()) {
            object2 = (CachedVariableCast)listIterator.next();
            object = ((CachedVariableCast)object2).getTypeCast();
            if (!((AbstractTypeCast)object).equals(abstractTypeCast)) continue;
            listIterator.remove();
            return;
        }
        object2 = this.mCachedCastList.listIterator();
        while (object2.hasNext()) {
            object = (CachedCast)object2.next();
            AbstractTypeCast abstractTypeCast2 = ((CachedCast)object).getTypeCast();
            if (!abstractTypeCast2.equals(abstractTypeCast)) continue;
            object2.remove();
            return;
        }
    }

    public String toString() {
        return " inLeftTree:" + this.mInLeftMapperTree + "  TypeCastCount: " + this.mCachedCastList.size() + "  ||  " + super.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CachedCast {
        private List<Object> mCastedCompPath;
        private AbstractTypeCast mTypeCast;

        public CachedCast(List<Object> list, AbstractTypeCast abstractTypeCast) {
            this.mCastedCompPath = list;
            this.mTypeCast = abstractTypeCast;
        }

        public SchemaComponent getBaseType() {
            return this.mTypeCast.getSComponent();
        }

        public AbstractTypeCast getTypeCast() {
            return this.mTypeCast;
        }

        public List<Object> getCastedCompPath() {
            return this.mCastedCompPath;
        }

        public boolean hasSameBase(SchemaComponent schemaComponent) {
            return this.getTypeCast().getSComponent().equals(schemaComponent);
        }

        public boolean hasSameCastTo(AbstractTypeCast abstractTypeCast) {
            GlobalType globalType = this.getTypeCast().getType();
            return globalType.equals(abstractTypeCast.getType());
        }

        public boolean hasSameCastedCompLocation(Iterable iterable) {
            return this.hasSameCastedCompPathImpl(iterable.iterator());
        }

        public boolean hasSameCastedCompPath(List<Object> list) {
            Iterator<Object> iterator = list.iterator();
            return this.hasSameCastedCompPathImpl(iterator);
        }

        private boolean hasSameCastedCompPathImpl(Iterator iterator) {
            Iterator<Object> iterator2 = this.mCastedCompPath.iterator();
            boolean bl = true;
            while (iterator.hasNext() && iterator2.hasNext()) {
                Object object;
                Object e = iterator.next();
                if (e.equals(object = iterator2.next())) continue;
                bl = false;
                break;
            }
            if (bl && iterator2.hasNext()) {
                return false;
            }
            return bl;
        }

        public String toString() {
            String string = this.mTypeCast.toString();
            String string2 = this.locationToString();
            if (string2 == null || string2.length() == 0) {
                return string;
            }
            return string2 + " " + string;
        }

        private String locationToString() {
            StringBuilder stringBuilder = new StringBuilder();
            ListIterator<Object> listIterator = this.mCastedCompPath.listIterator(this.mCastedCompPath.size());
            boolean bl = true;
            while (listIterator.hasPrevious()) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append("/");
                }
                Object object = listIterator.previous();
                stringBuilder.append(object.toString());
            }
            return stringBuilder.toString();
        }

        public boolean equals(Object object) {
            if (!(object instanceof CachedCast)) {
                return false;
            }
            CachedCast cachedCast = (CachedCast)object;
            if (!cachedCast.getTypeCast().equals(this.mTypeCast)) {
                return false;
            }
            List<Object> list = cachedCast.getCastedCompPath();
            if (list.size() != this.mCastedCompPath.size()) {
                return false;
            }
            ListIterator<Object> listIterator = this.mCastedCompPath.listIterator();
            ListIterator<Object> listIterator2 = list.listIterator();
            while (listIterator.hasNext()) {
                Object e;
                Object e2 = listIterator.next();
                if (e2.equals(e = listIterator2.next())) continue;
                return false;
            }
            return true;
        }
    }

    public static class CachedVariableCast {
        private XPathBpelVariable mVariable;
        private AbstractTypeCast mTypeCast;

        public CachedVariableCast(XPathBpelVariable xPathBpelVariable, AbstractTypeCast abstractTypeCast) {
            assert (xPathBpelVariable != null && abstractTypeCast != null);
            this.mVariable = xPathBpelVariable;
            this.mTypeCast = abstractTypeCast;
        }

        public XPathBpelVariable getCastedVariableDecl() {
            return this.mVariable;
        }

        public AbstractTypeCast getTypeCast() {
            return this.mTypeCast;
        }

        public boolean hasSameValues(XPathBpelVariable xPathBpelVariable, AbstractTypeCast abstractTypeCast) {
            return this.mVariable.equals((Object)xPathBpelVariable) && this.mTypeCast.equals(abstractTypeCast);
        }

        public boolean equals(Object object) {
            if (object instanceof CachedVariableCast) {
                CachedVariableCast cachedVariableCast = (CachedVariableCast)object;
                return this.mVariable.equals((Object)cachedVariableCast.getCastedVariableDecl()) && this.mTypeCast.equals(cachedVariableCast.getTypeCast());
            }
            return false;
        }

        public String toString() {
            return "Var: " + this.mVariable.toString() + " Cast: " + this.mTypeCast.toString();
        }
    }
}

