/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.libraries;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.project.libraries.LibraryDeclarationConvertorImpl;
import org.netbeans.modules.project.libraries.LibraryDeclarationHandlerImpl;
import org.netbeans.modules.project.libraries.LibraryDeclarationParser;
import org.netbeans.modules.project.libraries.LibraryTypeRegistry;
import org.netbeans.modules.project.libraries.WritableLibraryProvider;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryTypeProvider;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibrariesStorage
extends FileChangeAdapter
implements WritableLibraryProvider<LibraryImplementation> {
    private static final String NB_HOME_PROPERTY = "netbeans.home";
    private static final String LIBRARIES_REPOSITORY = "org-netbeans-api-project-libraries/Libraries";
    private static final String TIME_STAMPS_FILE = "libraries-timestamps.properties";
    private static final String XML_EXT = "xml";
    private static final Object TIMESTAMPS_LOCK = new Object();
    private FileObject storage = null;
    private Map<String, LibraryImplementation> libraries;
    private Map<String, LibraryImplementation> librariesByFileNames;
    private ResourceBundle bundle;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private boolean initialized;
    private Properties timeStamps;

    public LibrariesStorage() {
    }

    LibrariesStorage(FileObject fileObject) {
        this();
        this.storage = fileObject;
    }

    private static final FileObject createStorage() {
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        try {
            return FileUtil.createFolder((FileObject)fileSystem.getRoot(), (String)LIBRARIES_REPOSITORY);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void loadFromStorage() {
        this.libraries = new HashMap<String, LibraryImplementation>();
        this.librariesByFileNames = new HashMap<String, LibraryImplementation>();
        LibraryDeclarationHandlerImpl libraryDeclarationHandlerImpl = new LibraryDeclarationHandlerImpl();
        LibraryDeclarationConvertorImpl libraryDeclarationConvertorImpl = new LibraryDeclarationConvertorImpl();
        LibraryDeclarationParser libraryDeclarationParser = new LibraryDeclarationParser(libraryDeclarationHandlerImpl, libraryDeclarationConvertorImpl);
        for (FileObject fileObject : this.storage.getChildren()) {
            if (!XML_EXT.equalsIgnoreCase(fileObject.getExt())) continue;
            try {
                libraryDeclarationHandlerImpl.setLibrary(null);
                LibrariesStorage.readLibrary(fileObject, libraryDeclarationParser);
                LibraryImplementation libraryImplementation = libraryDeclarationHandlerImpl.getLibrary();
                if (libraryImplementation == null) continue;
                LibraryTypeProvider libraryTypeProvider = LibraryTypeRegistry.getDefault().getLibraryTypeProvider(libraryImplementation.getType());
                if (libraryTypeProvider == null) {
                    ErrorManager.getDefault().log(16, "LibrariesStorage: Can not invoke LibraryTypeProvider.libraryCreated(), the library type provider is unknown.");
                    continue;
                }
                if (this.libraries.keySet().contains(libraryImplementation.getName())) {
                    ErrorManager.getDefault().log(16, "LibrariesStorage: Library \"" + libraryImplementation.getName() + "\" is already defined, skeeping the definition from: " + FileUtil.getFileDisplayName((FileObject)fileObject));
                    continue;
                }
                if (!this.isUpToDate(fileObject)) {
                    libraryTypeProvider.libraryCreated(libraryImplementation);
                    this.updateTimeStamp(fileObject);
                }
                this.librariesByFileNames.put(fileObject.getPath(), libraryImplementation);
                this.libraries.put(libraryImplementation.getName(), libraryImplementation);
            }
            catch (SAXException sAXException) {
                ErrorManager.getDefault().notify((Throwable)sAXException);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                ErrorManager.getDefault().notify((Throwable)parserConfigurationException);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
            catch (RuntimeException runtimeException) {
                ErrorManager.getDefault().notify((Throwable)runtimeException);
            }
        }
        try {
            this.saveTimeStamps();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    private synchronized void initStorage() {
        if (!this.initialized) {
            if (this.storage == null) {
                this.storage = LibrariesStorage.createStorage();
                if (this.storage == null) {
                    this.libraries = Collections.emptyMap();
                    this.librariesByFileNames = Collections.emptyMap();
                    this.initialized = true;
                    return;
                }
            }
            this.loadFromStorage();
            this.storage.addFileChangeListener((FileChangeListener)this);
            this.initialized = true;
        }
    }

    private static LibraryImplementation readLibrary(FileObject fileObject) throws SAXException, ParserConfigurationException, IOException {
        return LibrariesStorage.readLibrary(fileObject, (LibraryImplementation)null);
    }

    private static LibraryImplementation readLibrary(FileObject fileObject, LibraryImplementation libraryImplementation) throws SAXException, ParserConfigurationException, IOException {
        LibraryDeclarationHandlerImpl libraryDeclarationHandlerImpl = new LibraryDeclarationHandlerImpl();
        LibraryDeclarationConvertorImpl libraryDeclarationConvertorImpl = new LibraryDeclarationConvertorImpl();
        LibraryDeclarationParser libraryDeclarationParser = new LibraryDeclarationParser(libraryDeclarationHandlerImpl, libraryDeclarationConvertorImpl);
        libraryDeclarationHandlerImpl.setLibrary(libraryImplementation);
        LibrariesStorage.readLibrary(fileObject, libraryDeclarationParser);
        return libraryDeclarationHandlerImpl.getLibrary();
    }

    private static void readLibrary(FileObject fileObject, LibraryDeclarationParser libraryDeclarationParser) throws SAXException, ParserConfigurationException, IOException {
        URL uRL = fileObject.getURL();
        InputSource inputSource = new InputSource(uRL.toExternalForm());
        inputSource.setByteStream(fileObject.getInputStream());
        try {
            libraryDeclarationParser.parse(inputSource);
        }
        catch (SAXException sAXException) {
            ErrorManager.getDefault().annotate((Throwable)sAXException, 0, "From " + uRL, null, null, null);
            throw sAXException;
        }
    }

    private void writeLibrary(final FileObject fileObject, final LibraryImplementation libraryImplementation) throws IOException {
        fileObject.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                String string = libraryImplementation.getType();
                LibraryTypeProvider libraryTypeProvider = LibraryTypeRegistry.getDefault().getLibraryTypeProvider(string);
                if (libraryTypeProvider == null) {
                    ErrorManager.getDefault().log(16, "LibrariesStorage: Cannot store library, the library type is not recognized by any of installed LibraryTypeProviders.");
                    return;
                }
                FileObject fileObject2 = fileObject.createData(libraryImplementation.getName(), LibrariesStorage.XML_EXT);
                LibrariesStorage.writeLibraryDefinition(fileObject2, libraryImplementation, libraryTypeProvider);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeLibraryDefinition(FileObject fileObject, LibraryImplementation libraryImplementation, LibraryTypeProvider libraryTypeProvider) throws IOException {
        FileLock fileLock = null;
        PrintWriter printWriter = null;
        try {
            String[] stringArray;
            String string;
            fileLock = fileObject.lock();
            printWriter = new PrintWriter(new OutputStreamWriter(fileObject.getOutputStream(fileLock), "UTF-8"));
            printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            printWriter.println("<!DOCTYPE library PUBLIC \"-//NetBeans//DTD Library Declaration 1.0//EN\" \"http://www.netbeans.org/dtds/library-declaration-1_0.dtd\">");
            printWriter.println("<library version=\"1.0\">");
            printWriter.println("\t<name>" + libraryImplementation.getName() + "</name>");
            printWriter.println("\t<type>" + libraryImplementation.getType() + "</type>");
            String string2 = libraryImplementation.getDescription();
            if (string2 != null && string2.length() > 0) {
                printWriter.println("\t<description>" + string2 + "</description>");
            }
            if ((string = libraryImplementation.getLocalizingBundle()) != null && string.length() > 0) {
                printWriter.println("\t<localizing-bundle>" + XMLUtil.toElementContent((String)string) + "</localizing-bundle>");
            }
            for (String string3 : stringArray = libraryTypeProvider.getSupportedVolumeTypes()) {
                printWriter.println("\t<volume>");
                printWriter.println("\t\t<type>" + string3 + "</type>");
                List<URL> list = libraryImplementation.getContent(string3);
                if (list != null) {
                    for (URL uRL : list) {
                        printWriter.println("\t\t<resource>" + XMLUtil.toElementContent((String)uRL.toExternalForm()) + "</resource>");
                    }
                }
                printWriter.println("\t</volume>");
            }
            printWriter.println("</library>");
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
            if (fileLock != null) {
                fileLock.releaseLock();
            }
        }
    }

    private void fireLibrariesChanged() {
        this.support.firePropertyChange("libraries", null, null);
    }

    @Override
    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public final LibraryImplementation[] getLibraries() {
        this.initStorage();
        assert (this.storage != null) : "Storage is not initialized";
        return this.libraries.values().toArray(new LibraryImplementation[this.libraries.size()]);
    }

    @Override
    public void addLibrary(LibraryImplementation libraryImplementation) throws IOException {
        this.initStorage();
        assert (this.storage != null) : "Storage is not initialized";
        this.writeLibrary(this.storage, libraryImplementation);
    }

    @Override
    public void removeLibrary(LibraryImplementation libraryImplementation) throws IOException {
        this.initStorage();
        assert (this.storage != null) : "Storage is not initialized";
        for (String string : this.librariesByFileNames.keySet()) {
            FileObject fileObject;
            LibraryImplementation libraryImplementation2 = this.librariesByFileNames.get(string);
            if (!libraryImplementation.equals(libraryImplementation2) || (fileObject = this.storage.getFileSystem().findResource(string)) == null) continue;
            fileObject.delete();
            return;
        }
    }

    @Override
    public void updateLibrary(LibraryImplementation libraryImplementation, final LibraryImplementation libraryImplementation2) throws IOException {
        this.initStorage();
        assert (this.storage != null) : "Storage is not initialized";
        for (String string : this.librariesByFileNames.keySet()) {
            FileObject fileObject;
            LibraryImplementation libraryImplementation3 = this.librariesByFileNames.get(string);
            if (!libraryImplementation.equals(libraryImplementation3) || (fileObject = this.storage.getFileSystem().findResource(string)) == null) continue;
            String string2 = libraryImplementation2.getType();
            final LibraryTypeProvider libraryTypeProvider = LibraryTypeRegistry.getDefault().getLibraryTypeProvider(string2);
            if (libraryTypeProvider == null) {
                ErrorManager.getDefault().log(16, "LibrariesStorageL Cannot store library, the library type is not recognized by any of installed LibraryTypeProviders.");
                return;
            }
            this.storage.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    LibrariesStorage.writeLibraryDefinition(fileObject, libraryImplementation2, libraryTypeProvider);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileDataCreated(FileEvent fileEvent) {
        block10: {
            FileObject fileObject = fileEvent.getFile();
            try {
                LibraryImplementation libraryImplementation = LibrariesStorage.readLibrary(fileObject);
                if (libraryImplementation == null) break block10;
                LibraryTypeProvider libraryTypeProvider = LibraryTypeRegistry.getDefault().getLibraryTypeProvider(libraryImplementation.getType());
                if (libraryTypeProvider == null) {
                    ErrorManager.getDefault().log(16, "LibrariesStorage: Can not invoke LibraryTypeProvider.libraryCreated(), the library type provider is unknown.");
                    break block10;
                }
                LibrariesStorage librariesStorage = this;
                synchronized (librariesStorage) {
                    this.libraries.put(libraryImplementation.getName(), libraryImplementation);
                    this.librariesByFileNames.put(fileObject.getPath(), libraryImplementation);
                }
                try {
                    libraryTypeProvider.libraryCreated(libraryImplementation);
                    this.updateTimeStamp(fileObject);
                    this.saveTimeStamps();
                }
                catch (RuntimeException runtimeException) {
                    String string = NbBundle.getMessage(LibrariesStorage.class, (String)"MSG_libraryCreatedError");
                    ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)runtimeException, string));
                }
                this.fireLibrariesChanged();
            }
            catch (SAXException sAXException) {
                ErrorManager.getDefault().notify((Throwable)sAXException);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                ErrorManager.getDefault().notify((Throwable)parserConfigurationException);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileDeleted(FileEvent fileEvent) {
        LibraryImplementation libraryImplementation;
        String string = fileEvent.getFile().getPath();
        Object object = this;
        synchronized (object) {
            libraryImplementation = this.librariesByFileNames.remove(string);
            if (libraryImplementation != null) {
                this.libraries.remove(libraryImplementation.getName());
            }
        }
        if (libraryImplementation != null) {
            object = LibraryTypeRegistry.getDefault().getLibraryTypeProvider(libraryImplementation.getType());
            if (object == null) {
                ErrorManager.getDefault().log(16, "LibrariesStorage: Cannot invoke LibraryTypeProvider.libraryDeleted(), the library type provider is unknown.");
            } else {
                try {
                    object.libraryDeleted(libraryImplementation);
                }
                catch (RuntimeException runtimeException) {
                    String string2 = NbBundle.getMessage(LibrariesStorage.class, (String)"MSG_libraryDeletedError");
                    ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)runtimeException, string2));
                }
            }
            this.fireLibrariesChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileChanged(FileEvent fileEvent) {
        LibraryImplementation libraryImplementation;
        FileObject fileObject = fileEvent.getFile();
        String string = fileObject.getPath();
        Object object = this;
        synchronized (object) {
            libraryImplementation = this.librariesByFileNames.get(string);
        }
        if (libraryImplementation != null) {
            try {
                LibrariesStorage.readLibrary(fileObject, libraryImplementation);
                object = LibraryTypeRegistry.getDefault().getLibraryTypeProvider(libraryImplementation.getType());
                if (object == null) {
                    ErrorManager.getDefault().log(16, "LibrariesStorage: Can not invoke LibraryTypeProvider.libraryCreated(), the library type provider is unknown.");
                }
                try {
                    object.libraryCreated(libraryImplementation);
                    this.updateTimeStamp(fileObject);
                    this.saveTimeStamps();
                }
                catch (RuntimeException runtimeException) {
                    String string2 = NbBundle.getMessage(LibrariesStorage.class, (String)"MSG_libraryCreatedError");
                    ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)runtimeException, string2));
                }
            }
            catch (SAXException sAXException) {
                ErrorManager.getDefault().notify((Throwable)sAXException);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                ErrorManager.getDefault().notify((Throwable)parserConfigurationException);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
    }

    protected final ResourceBundle getBundle() {
        if (this.bundle == null) {
            this.bundle = NbBundle.getBundle(LibrariesStorage.class);
        }
        return this.bundle;
    }

    private boolean isUpToDate(FileObject fileObject) {
        Properties properties = this.getTimeStamps();
        String string = (String)properties.get(fileObject.getNameExt());
        return string == null ? false : Long.parseLong(string) >= fileObject.lastModified().getTime();
    }

    private void updateTimeStamp(FileObject fileObject) {
        Properties properties = this.getTimeStamps();
        properties.put(fileObject.getNameExt(), Long.toString(fileObject.lastModified().getTime()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveTimeStamps() throws IOException {
        if (this.storage != null) {
            Object object = TIMESTAMPS_LOCK;
            synchronized (object) {
                FileObject fileObject;
                String string;
                Properties properties = this.getTimeStamps();
                if (properties.get(NB_HOME_PROPERTY) == null) {
                    string = LibrariesStorage.getNBRoots();
                    properties.put(NB_HOME_PROPERTY, string);
                }
                if ((fileObject = (string = this.storage.getParent()).getFileObject(TIME_STAMPS_FILE)) == null) {
                    fileObject = string.createData(TIME_STAMPS_FILE);
                }
                FileLock fileLock = fileObject.lock();
                try {
                    OutputStream outputStream = fileObject.getOutputStream(fileLock);
                    try {
                        properties.store(outputStream, null);
                    }
                    finally {
                        outputStream.close();
                    }
                }
                finally {
                    fileLock.releaseLock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getTimeStamps() {
        if (this.timeStamps == null) {
            FileObject fileObject;
            this.timeStamps = new Properties();
            if (this.storage != null && (fileObject = this.storage.getParent().getFileObject(TIME_STAMPS_FILE)) != null) {
                try {
                    InputStream inputStream = fileObject.getInputStream();
                    try {
                        this.timeStamps.load(inputStream);
                    }
                    finally {
                        inputStream.close();
                    }
                    String string = (String)this.timeStamps.get(NB_HOME_PROPERTY);
                    String string2 = LibrariesStorage.getNBRoots();
                    if (string == null || !string.equals(string2)) {
                        this.timeStamps.clear();
                    }
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        }
        return this.timeStamps;
    }

    private static String getNBRoots() {
        Object object;
        Object object2;
        TreeSet<String> treeSet = new TreeSet<String>();
        String string = System.getProperty(NB_HOME_PROPERTY);
        if (string != null && ((File)(object2 = FileUtil.normalizeFile((File)new File(string)))).isDirectory()) {
            treeSet.add(((File)object2).getAbsolutePath());
        }
        if ((string = System.getProperty("netbeans.dirs")) != null) {
            object2 = new StringTokenizer(string, File.pathSeparator);
            while (((StringTokenizer)object2).hasMoreTokens()) {
                object = FileUtil.normalizeFile((File)new File(((StringTokenizer)object2).nextToken()));
                treeSet.add(((File)object).getAbsolutePath());
            }
        }
        object2 = new StringBuffer();
        object = treeSet.iterator();
        while (object.hasNext()) {
            ((StringBuffer)object2).append((String)object.next());
            if (!object.hasNext()) continue;
            ((StringBuffer)object2).append(":");
        }
        return ((StringBuffer)object2).toString();
    }
}

