/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.debugger;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.debugger.RubyDebugInstallPanel;
import org.netbeans.modules.ruby.debugger.RubySession;
import org.netbeans.modules.ruby.platform.DebuggerPreferences;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class Util {
    public static final Logger LOGGER = Logger.getLogger(Util.class.getName());
    public static final String RUBY_MIME_TYPE = "text/x-ruby";
    public static final String ERB_MIME_TYPE = "application/x-httpd-eruby";

    private Util() {
    }

    public static void finer(String string) {
        LOGGER.finer(string);
    }

    public static void info(String string) {
        LOGGER.info(string);
    }

    public static void warning(String string) {
        LOGGER.warning(string);
    }

    public static void severe(String string) {
        LOGGER.log(Level.SEVERE, string);
    }

    public static void severe(Throwable throwable) {
        LOGGER.log(Level.SEVERE, throwable.getMessage(), throwable);
    }

    public static void severe(String string, Throwable throwable) {
        LOGGER.log(Level.SEVERE, string, throwable);
    }

    public static String rdebugPattern() {
        return "rdebug-ide";
    }

    public static String findRDebugExecutable(RubyPlatform rubyPlatform) {
        return rubyPlatform.findExecutable(Util.rdebugPattern());
    }

    public static void showMessage(String string) {
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string));
    }

    public static void showWarning(String string) {
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 2));
    }

    public static boolean isRubySource(FileObject fileObject) {
        return RUBY_MIME_TYPE.equals(fileObject.getMIMEType()) || Util.isERBSource(fileObject);
    }

    public static boolean isERBSource(FileObject fileObject) {
        return ERB_MIME_TYPE.equals(fileObject.getMIMEType());
    }

    public static RubySession getCurrentSession() {
        DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        return debuggerEngine == null ? null : (RubySession)debuggerEngine.lookupFirst(null, RubySession.class);
    }

    static FastDebugInstallationResult offerToInstallFastDebugger(RubyPlatform rubyPlatform) {
        return Util.ensureRubyDebuggerIsPresent(rubyPlatform, false, "RubyDebugger.askMessage");
    }

    static FastDebugInstallationResult ensureRubyDebuggerIsPresent(RubyPlatform rubyPlatform, boolean bl, String string) {
        Object[] objectArray;
        if (!rubyPlatform.hasRubyGemsInstalled()) {
            return FastDebugInstallationResult.FAILED;
        }
        String string2 = rubyPlatform.getFastDebuggerProblemsInHTML();
        if (string2 == null) {
            return FastDebugInstallationResult.INSTALLED;
        }
        if (!bl && DebuggerPreferences.getInstance().isDoNotAskAgain()) {
            return FastDebugInstallationResult.USE_SLOW;
        }
        String string3 = NbBundle.getMessage(Util.class, (String)string, (Object)string2);
        RubyDebugInstallPanel rubyDebugInstallPanel = new RubyDebugInstallPanel(bl, string3);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)rubyDebugInstallPanel, NbBundle.getMessage(Util.class, (String)"Util.installation.panel.title"));
        JButton jButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton, (String)Util.getMessage("Util.installation.panel.installButton"));
        JButton jButton2 = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton2, (String)Util.getMessage("Util.installation.panel.useSlowButton"));
        JButton jButton3 = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton3, (String)Util.getMessage("Util.installation.panel.cancelButton"));
        if (bl) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = jButton;
            objectArray = objectArray2;
            objectArray2[1] = jButton3;
        } else {
            Object[] objectArray3 = new Object[3];
            objectArray3[0] = jButton;
            objectArray3[1] = jButton2;
            objectArray = objectArray3;
            objectArray3[2] = jButton3;
        }
        Object[] objectArray4 = objectArray;
        dialogDescriptor.setOptions(objectArray4);
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (object == jButton) {
            if (!rubyPlatform.installFastDebugger()) {
                Util.showWarning(Util.getMessage("Util.fast.debugger.install.failed"));
                return FastDebugInstallationResult.FAILED;
            }
            return FastDebugInstallationResult.INSTALLED;
        }
        if (!bl) {
            DebuggerPreferences.getInstance().setDoNotAskAgain(rubyDebugInstallPanel.isDoNotAskAgain());
        }
        if (object == jButton3 || object == NotifyDescriptor.CLOSED_OPTION) {
            return FastDebugInstallationResult.CANCELLED;
        }
        assert (object == jButton2) : "is slow button";
        return FastDebugInstallationResult.USE_SLOW;
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(Util.class, (String)string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum FastDebugInstallationResult {
        INSTALLED,
        CANCELLED,
        FAILED,
        USE_SLOW;

    }
}

