/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.nb.javascript.optimizer;

import java.util.Hashtable;
import org.mozilla.nb.javascript.Node;
import org.mozilla.nb.javascript.NodeTransformer;
import org.mozilla.nb.javascript.ObjArray;
import org.mozilla.nb.javascript.ScriptOrFnNode;
import org.mozilla.nb.javascript.optimizer.OptFunctionNode;

class OptTransformer
extends NodeTransformer {
    private Hashtable possibleDirectCalls;
    private ObjArray directCallTargets;

    OptTransformer(Hashtable hashtable, ObjArray objArray) {
        this.possibleDirectCalls = hashtable;
        this.directCallTargets = objArray;
    }

    protected void visitNew(Node node, ScriptOrFnNode scriptOrFnNode) {
        this.detectDirectCall(node, scriptOrFnNode);
        super.visitNew(node, scriptOrFnNode);
    }

    protected void visitCall(Node node, ScriptOrFnNode scriptOrFnNode) {
        this.detectDirectCall(node, scriptOrFnNode);
        super.visitCall(node, scriptOrFnNode);
    }

    private void detectDirectCall(Node node, ScriptOrFnNode scriptOrFnNode) {
        if (scriptOrFnNode.getType() == 105) {
            Node node2 = node.getFirstChild();
            int n = 0;
            Node node3 = node2.getNext();
            while (node3 != null) {
                node3 = node3.getNext();
                ++n;
            }
            if (n == 0) {
                OptFunctionNode.get((ScriptOrFnNode)scriptOrFnNode).itsContainsCalls0 = true;
            }
            if (this.possibleDirectCalls != null) {
                OptFunctionNode optFunctionNode;
                String string = null;
                if (node2.getType() == 38) {
                    string = node2.getString();
                } else if (node2.getType() == 33) {
                    string = node2.getFirstChild().getNext().getString();
                }
                if (string != null && (optFunctionNode = (OptFunctionNode)this.possibleDirectCalls.get(string)) != null && n == optFunctionNode.fnode.getParamCount() && !optFunctionNode.fnode.requiresActivation() && n <= 32) {
                    node.putProp(9, optFunctionNode);
                    if (!optFunctionNode.isTargetOfDirectCall()) {
                        int n2 = this.directCallTargets.size();
                        this.directCallTargets.add(optFunctionNode);
                        optFunctionNode.setDirectTargetIndex(n2);
                    }
                }
            }
        }
    }
}

