/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.testrunner.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.ruby.platform.execution.OutputRecognizer;
import org.netbeans.modules.ruby.testrunner.ui.Manager;
import org.netbeans.modules.ruby.testrunner.ui.TestRecognizerHandler;
import org.netbeans.modules.ruby.testrunner.ui.TestSession;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestRecognizer
extends OutputRecognizer {
    private static final Logger LOGGER = Logger.getLogger(TestRecognizer.class.getName());
    private final Manager manager;
    private TestSession session;
    private final List<TestRecognizerHandler> handlers;
    private final boolean printSummary;

    public TestRecognizer(Manager manager, List<TestRecognizerHandler> list, TestSession testSession, boolean bl) {
        this.manager = manager;
        this.handlers = list;
        this.session = testSession;
        this.printSummary = bl;
    }

    public synchronized void refreshSession() {
        this.session = new TestSession(this.session.getName(), this.session.getProject(), this.session.getSessionType());
    }

    public synchronized void start() {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Session starting: " + this.session);
        }
    }

    public synchronized OutputRecognizer.RecognizedOutput processLine(String string) {
        for (TestRecognizerHandler testRecognizerHandler : this.handlers) {
            if (!testRecognizerHandler.matches(string)) continue;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Handler [" + testRecognizerHandler + "] matched line: " + string);
            }
            try {
                testRecognizerHandler.updateUI(this.manager, this.session);
                return testRecognizerHandler.getRecognizedOutput();
            }
            catch (IllegalStateException illegalStateException) {
                LOGGER.log(Level.WARNING, "Failed to process line: " + string + " with handler: " + testRecognizerHandler, illegalStateException);
                return null;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                LOGGER.log(Level.WARNING, "Failed to process line: " + string + " with handler: " + testRecognizerHandler, indexOutOfBoundsException);
                return null;
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "No handler for line: " + string);
        }
        this.manager.displayOutput(this.session, string, false);
        return null;
    }

    public synchronized void finish() {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Session finished: " + this.session);
        }
        this.manager.sessionFinished(this.session);
    }

    public synchronized String[] beforeFinish() {
        if (!this.printSummary) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>(2);
        arrayList.add("");
        arrayList.add(NbBundle.getMessage(TestRecognizer.class, (String)"MSG_TestSessionFinished", (Object)new Double((double)this.session.getSessionResult().getElapsedTime() / 1000.0)));
        arrayList.add(NbBundle.getMessage(TestRecognizer.class, (String)"MSG_TestSessionFinishedSummary", (Object)this.session.getSessionResult().getTotal(), (Object)this.session.getSessionResult().getFailed(), (Object)this.session.getSessionResult().getErrors()));
        for (String string : arrayList) {
            this.manager.displayOutput(this.session, string, false);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

