/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.testrunner;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.ruby.platform.RubyExecution;
import org.netbeans.modules.ruby.platform.execution.ExecutionDescriptor;
import org.netbeans.modules.ruby.platform.execution.ExecutionService;
import org.netbeans.modules.ruby.platform.execution.OutputRecognizer;
import org.netbeans.modules.ruby.testrunner.ui.TestRecognizer;
import org.openide.LifecycleManager;
import org.openide.util.ChangeSupport;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public final class TestExecutionManager {
    private static final Logger LOGGER = Logger.getLogger(TestExecutionManager.class.getName());
    private ExecutionService execution;
    private boolean finished;
    private TestRecognizer recognizer;
    private ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private static final TestExecutionManager INSTANCE = new TestExecutionManager();

    private TestExecutionManager() {
    }

    public static TestExecutionManager getInstance() {
        return INSTANCE;
    }

    synchronized void reset() {
        this.finished = false;
    }

    synchronized void start(ExecutionDescriptor executionDescriptor, TestRecognizer testRecognizer) {
        assert (executionDescriptor != null);
        assert (testRecognizer != null);
        if (!this.isFinished() && this.execution != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Killing unfinished execution: " + this.execution);
            }
            this.execution.kill();
        }
        this.recognizer = testRecognizer;
        executionDescriptor.addOutputRecognizer((OutputRecognizer)this.recognizer);
        this.execution = new RubyExecution(executionDescriptor);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Starting: " + this.execution);
        }
        this.setFinished(false);
        LifecycleManager.getDefault().saveAll();
        this.handleTask(this.execution.run());
    }

    private void handleTask(Task task) {
        task.addTaskListener(new TaskListener(){

            public void taskFinished(Task task) {
                TestExecutionManager.this.setFinished(true);
            }
        });
        this.setFinished(task.isFinished());
    }

    public synchronized boolean isFinished() {
        return this.finished;
    }

    private void setFinished(boolean bl) {
        this.finished = bl;
        this.changeSupport.fireChange();
    }

    public synchronized void rerun() {
        assert (this.isFinished());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Re-running: " + this.execution);
        }
        this.recognizer.refreshSession();
        this.setFinished(false);
        LifecycleManager.getDefault().saveAll();
        this.handleTask(this.execution.rerun());
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public synchronized void refresh() {
        this.recognizer.refreshSession();
    }
}

