/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.testrunner;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.execution.ExecutionDescriptor;
import org.netbeans.modules.ruby.platform.execution.FileLocator;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.netbeans.modules.ruby.rubyproject.spi.TestRunner;
import org.netbeans.modules.ruby.testrunner.RspecRunner;
import org.netbeans.modules.ruby.testrunner.TestExecutionManager;
import org.netbeans.modules.ruby.testrunner.TestUnitRunner;
import org.netbeans.modules.ruby.testrunner.ui.AutotestHandlerFactory;
import org.netbeans.modules.ruby.testrunner.ui.Manager;
import org.netbeans.modules.ruby.testrunner.ui.TestRecognizer;
import org.netbeans.modules.ruby.testrunner.ui.TestSession;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutotestRunner
implements TestRunner {
    private static final Logger LOGGER = Logger.getLogger(AutotestRunner.class.getName());
    private static final TestRunner INSTANCE = new AutotestRunner();
    private static final String NB_RSPEC_MEDIATOR = "NB_RSPEC_MEDIATOR";
    private static final String RSPEC_AUTOTEST_LOADER = "nb_autotest_loader.rb";

    public TestRunner getInstance() {
        return INSTANCE;
    }

    public boolean supports(TestRunner.TestType testType) {
        return TestRunner.TestType.AUTOTEST == testType;
    }

    public void runTest(FileObject fileObject, boolean bl) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public void runSingleTest(FileObject fileObject, String string, boolean bl) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public void runAllTests(Project project, boolean bl) {
        RubyPlatform rubyPlatform = RubyPlatform.platformFor((Project)project);
        GemManager gemManager = rubyPlatform.getGemManager();
        if (!gemManager.isValidAutoTest(true)) {
            return;
        }
        String string = NbBundle.getMessage(AutotestRunner.class, (String)"AutoTest", (Object)ProjectUtils.getInformation((Project)project).getDisplayName());
        FileLocator fileLocator = (FileLocator)project.getLookup().lookup(FileLocator.class);
        ExecutionDescriptor executionDescriptor = new ExecutionDescriptor(rubyPlatform, string, FileUtil.toFile((FileObject)project.getProjectDirectory()), gemManager.getAutoTest());
        executionDescriptor.initialArgs("-r \"" + AutotestRunner.getLoaderScript().getAbsolutePath() + "\"");
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        AutotestRunner.addRspecMediatorOptionsToEnv(hashMap);
        TestUnitRunner.addTestUnitRunnerToEnv(hashMap);
        executionDescriptor.addAdditionalEnv(hashMap);
        executionDescriptor.debug(bl);
        executionDescriptor.allowInput();
        executionDescriptor.fileLocator(fileLocator);
        executionDescriptor.addStandardRecognizers();
        executionDescriptor.setReadMaxWaitTime(5000);
        TestSession testSession = new TestSession(string, project, bl ? TestSession.SessionType.DEBUG : TestSession.SessionType.TEST);
        TestRecognizer testRecognizer = new TestRecognizer(Manager.getInstance(), AutotestHandlerFactory.getHandlers(), testSession, true);
        TestExecutionManager.getInstance().start(executionDescriptor, testRecognizer);
    }

    private static void addRspecMediatorOptionsToEnv(Map<String, String> map) {
        String string = "--require '" + RspecRunner.getMediatorScript().getAbsolutePath() + "' --runner NbRspecMediator";
        map.put(NB_RSPEC_MEDIATOR, string);
    }

    private static File getLoaderScript() {
        File file = InstalledFileLocator.getDefault().locate(RSPEC_AUTOTEST_LOADER, "org.netbeans.modules.ruby.testrunner", false);
        if (file == null) {
            throw new IllegalStateException("Could not locate nb_autotest_loader.rb");
        }
        return file;
    }
}

