/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.meta;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.db.dataview.meta.DBColumn;
import org.netbeans.modules.db.dataview.meta.DBObject;
import org.netbeans.modules.db.dataview.meta.DBPrimaryKey;
import org.netbeans.modules.db.dataview.meta.DBTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DBForeignKey
extends DBObject<DBTable> {
    private static final String RS_PK_NAME = "PK_NAME";
    private static final String RS_PKCATALOG_NAME = "PKTABLE_CAT";
    private static final String RS_PKSCHEMA_NAME = "PKTABLE_SCHEM";
    private static final String RS_PKTABLE_NAME = "PKTABLE_NAME";
    private static final String RS_PKCOLUMN_NAME = "PKCOLUMN_NAME";
    private static final String RS_FK_NAME = "FK_NAME";
    private static final String RS_FKCOLUMN_NAME = "FKCOLUMN_NAME";
    private static final String RS_UPDATE_RULE = "UPDATE_RULE";
    private static final String RS_DELETE_RULE = "DELETE_RULE";
    private static final String RS_DEFERRABILITY = "DEFERRABILITY";
    private int deferrability;
    private int deleteRule;
    private String fkName;
    private String pkCatalog;
    private String pkName;
    private String pkSchema;
    private String pkTable;
    private int updateRule;
    private List<String> fkColumnNames = new ArrayList<String>();
    private List<String> pkColumnNames = new ArrayList<String>();

    public static Map<String, DBForeignKey> createForeignKeyColumnMap(DBTable dBTable, ResultSet resultSet) throws SQLException {
        assert (resultSet != null);
        HashMap<String, DBForeignKey> hashMap = new HashMap<String, DBForeignKey>();
        while (resultSet.next()) {
            DBForeignKey dBForeignKey = (DBForeignKey)hashMap.get(resultSet.getString(RS_FK_NAME));
            if (dBForeignKey != null) {
                dBForeignKey.addColumnNames(resultSet);
                continue;
            }
            dBForeignKey = new DBForeignKey(resultSet);
            dBForeignKey.setParentObject(dBTable);
            hashMap.put(dBForeignKey.getName(), dBForeignKey);
        }
        return hashMap;
    }

    private DBForeignKey(ResultSet resultSet) throws SQLException {
        assert (resultSet != null);
        this.fkName = resultSet.getString(RS_FK_NAME);
        this.pkName = resultSet.getString(RS_PK_NAME);
        this.pkTable = resultSet.getString(RS_PKTABLE_NAME);
        this.pkSchema = resultSet.getString(RS_PKSCHEMA_NAME);
        this.pkCatalog = resultSet.getString(RS_PKCATALOG_NAME);
        this.addColumnNames(resultSet);
        this.updateRule = resultSet.getShort(RS_UPDATE_RULE);
        this.deleteRule = resultSet.getShort(RS_DELETE_RULE);
        this.deferrability = resultSet.getShort(RS_DEFERRABILITY);
    }

    private void addColumnNames(ResultSet resultSet) throws SQLException {
        String string = resultSet.getString(RS_PKCOLUMN_NAME);
        if (!DBForeignKey.isNullString(string)) {
            this.pkColumnNames.add(string);
        }
        String string2 = resultSet.getString(RS_FKCOLUMN_NAME);
        if (!DBForeignKey.isNullString(string)) {
            this.fkColumnNames.add(string2);
        }
    }

    public boolean contains(DBColumn dBColumn) {
        return this.contains(dBColumn.getName());
    }

    public boolean contains(String string) {
        return this.fkColumnNames.contains(string);
    }

    public boolean equals(Object object) {
        boolean bl;
        if (this == object) {
            return true;
        }
        if (!(object instanceof DBForeignKey)) {
            return false;
        }
        DBForeignKey dBForeignKey = (DBForeignKey)object;
        boolean bl2 = this.fkName != null ? this.fkName.equals(dBForeignKey.fkName) : (bl = dBForeignKey.fkName == null);
        bl &= this.pkName != null ? this.pkName.equals(dBForeignKey.pkName) : dBForeignKey.pkName == null;
        bl &= this.pkTable != null ? this.pkTable.equals(dBForeignKey.pkTable) : dBForeignKey.pkTable == null;
        bl &= this.pkSchema != null ? this.pkSchema.equals(dBForeignKey.pkSchema) : dBForeignKey.pkSchema == null;
        bl &= this.pkCatalog != null ? this.pkCatalog.equals(dBForeignKey.pkCatalog) : dBForeignKey.pkCatalog == null;
        bl &= this.updateRule == dBForeignKey.updateRule && this.deleteRule == dBForeignKey.deleteRule && this.deferrability == dBForeignKey.deferrability;
        bl &= this.pkColumnNames != null ? ((Object)this.pkColumnNames).equals(dBForeignKey.pkColumnNames) : dBForeignKey.pkColumnNames != null;
        return bl &= this.fkColumnNames != null ? ((Object)this.fkColumnNames).equals(dBForeignKey.fkColumnNames) : dBForeignKey.fkColumnNames != null;
    }

    public List<String> getColumnNames() {
        return Collections.unmodifiableList(this.fkColumnNames);
    }

    public String getName() {
        return this.fkName;
    }

    public String getPKCatalog() {
        return this.pkCatalog;
    }

    public List<String> getPKColumnNames() {
        return Collections.unmodifiableList(this.pkColumnNames);
    }

    public String getPKName() {
        return this.pkName;
    }

    public String getPKSchema() {
        return this.pkSchema;
    }

    public String getPKTable() {
        return this.pkTable;
    }

    public int hashCode() {
        int n = this.fkName != null ? this.fkName.hashCode() : 0;
        n += this.pkName != null ? this.pkName.hashCode() : 0;
        n += this.pkTable != null ? this.pkTable.hashCode() : 0;
        n += this.pkSchema != null ? this.pkSchema.hashCode() : 0;
        n += this.pkCatalog != null ? this.pkCatalog.hashCode() : 0;
        n += this.updateRule + this.deleteRule + this.deferrability;
        n += this.fkColumnNames != null ? ((Object)this.fkColumnNames).hashCode() : 0;
        return n += this.pkColumnNames != null ? ((Object)this.pkColumnNames).hashCode() : 0;
    }

    public boolean references(DBPrimaryKey dBPrimaryKey) {
        if (dBPrimaryKey == null) {
            return false;
        }
        List<String> list = dBPrimaryKey.getColumnNames();
        DBTable dBTable = (DBTable)dBPrimaryKey.getParentObject();
        return this.references(dBTable) && list.containsAll(this.pkColumnNames) && this.pkColumnNames.containsAll(list);
    }

    private boolean references(DBTable dBTable) {
        return dBTable != null ? this.references(dBTable.getName(), dBTable.getSchema(), dBTable.getCatalog()) : false;
    }

    private boolean references(String string, String string2, String string3) {
        boolean bl;
        boolean bl2;
        if (string3.equals("")) {
            string3 = null;
        }
        if (string2.equals("")) {
            string2 = null;
        }
        if (string.equals("")) {
            string = null;
        }
        boolean bl3 = string != null ? string.equals(this.pkTable) : (bl2 = this.pkTable == null);
        boolean bl4 = string2 != null ? string2.equals(this.pkSchema) : (bl = this.pkSchema == null);
        boolean bl5 = string3 != null ? string3.equals(this.pkCatalog) : this.pkCatalog == null;
        return bl2 && bl && bl5;
    }
}

