/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.packets;

import java.util.Collection;
import java.util.LinkedList;
import org.netbeans.modules.php.dbgp.DebugSession;
import org.netbeans.modules.php.dbgp.packets.ContextGetCommand;
import org.netbeans.modules.php.dbgp.packets.ContextNamesCommand;
import org.netbeans.modules.php.dbgp.packets.DbgpCommand;
import org.netbeans.modules.php.dbgp.packets.DbgpResponse;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextNamesResponse
extends DbgpResponse {
    static final String CONTEXT = "context";
    private static final String NAME = "name";
    private static final String ID = "id";

    ContextNamesResponse(Node node) {
        super(node);
    }

    Collection<Context> getContexts() {
        LinkedList<Context> linkedList = new LinkedList<Context>();
        NodeList nodeList = this.getNode().getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!CONTEXT.equals(node.getNodeName())) continue;
            String string = ContextNamesResponse.getAttribute(node, NAME);
            String string2 = ContextNamesResponse.getAttribute(node, ID);
            try {
                int n = Integer.parseInt(string2);
                linkedList.add(new Context(string, n));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                assert (false);
                continue;
            }
        }
        return linkedList;
    }

    @Override
    public void process(DebugSession debugSession, DbgpCommand dbgpCommand) {
        if (!(dbgpCommand instanceof ContextNamesCommand)) {
            return;
        }
        ContextNamesCommand contextNamesCommand = (ContextNamesCommand)dbgpCommand;
        int n = contextNamesCommand.getDepth();
        for (Context context : this.getContexts()) {
            ContextGetCommand contextGetCommand = new ContextGetCommand(debugSession.getTransactionId());
            contextGetCommand.setContext(context);
            if (n != -1) {
                contextGetCommand.setDepth(n);
            }
            debugSession.sendCommandLater(contextGetCommand);
        }
    }

    public static class Context {
        private String myContext;
        private int myId;

        private Context(String string, int n) {
            this.myContext = string;
            this.myId = n;
        }

        public String getContext() {
            return this.myContext;
        }

        public int getId() {
            return this.myId;
        }
    }
}

