/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.breakpoints;

import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.php.dbgp.DebugSession;
import org.netbeans.modules.php.dbgp.SessionId;
import org.netbeans.modules.php.dbgp.breakpoints.AbstractBreakpoint;
import org.netbeans.modules.php.dbgp.breakpoints.FunctionBreakpoint;
import org.netbeans.modules.php.dbgp.breakpoints.LineBreakpoint;
import org.netbeans.modules.php.dbgp.packets.BrkpntCommandBuilder;
import org.netbeans.modules.php.dbgp.packets.BrkpntRemoveCommand;
import org.netbeans.modules.php.dbgp.packets.BrkpntSetCommand;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.Line;

public class Utils {
    static final String MIME_TYPE = "text/x-php5";
    public static LineFactory lineFactory = new LineFactory();

    private Utils() {
    }

    public static Line getCurrentLine() {
        FileObject fileObject = EditorContextDispatcher.getDefault().getCurrentFile();
        if (!Utils.isPhpFile(fileObject)) {
            return null;
        }
        return EditorContextDispatcher.getDefault().getCurrentLine();
    }

    public static BrkpntSetCommand getCommand(DebugSession debugSession, SessionId sessionId, AbstractBreakpoint abstractBreakpoint) {
        if (!abstractBreakpoint.isSessionRelated(debugSession)) {
            return null;
        }
        BrkpntSetCommand brkpntSetCommand = null;
        if (abstractBreakpoint instanceof LineBreakpoint) {
            LineBreakpoint lineBreakpoint = (LineBreakpoint)abstractBreakpoint;
            brkpntSetCommand = BrkpntCommandBuilder.buildLineBreakpoint(sessionId, debugSession.getTransactionId(), lineBreakpoint);
        } else if (abstractBreakpoint instanceof FunctionBreakpoint) {
            FunctionBreakpoint functionBreakpoint = (FunctionBreakpoint)abstractBreakpoint;
            FunctionBreakpoint.Type type = functionBreakpoint.getType();
            if (type == FunctionBreakpoint.Type.CALL) {
                brkpntSetCommand = BrkpntCommandBuilder.buildCallBreakpoint(debugSession.getTransactionId(), functionBreakpoint);
            } else if (type == FunctionBreakpoint.Type.RETURN) {
                brkpntSetCommand = BrkpntCommandBuilder.buildReturnBreakpoint(debugSession.getTransactionId(), functionBreakpoint);
            } else assert (false);
        }
        if (!abstractBreakpoint.isEnabled()) {
            brkpntSetCommand.setState(BrkpntSetCommand.State.DISABLED);
        }
        return brkpntSetCommand;
    }

    public static AbstractBreakpoint getBreakpoint(String string) {
        Breakpoint[] breakpointArray;
        for (Breakpoint breakpoint : breakpointArray = DebuggerManager.getDebuggerManager().getBreakpoints()) {
            AbstractBreakpoint abstractBreakpoint;
            String string2;
            if (!(breakpoint instanceof AbstractBreakpoint) || !string.equals(string2 = (abstractBreakpoint = (AbstractBreakpoint)breakpoint).getBreakpointId())) continue;
            return abstractBreakpoint;
        }
        return null;
    }

    public static void cleanBreakpoint(DebugSession debugSession, String string) {
        BrkpntRemoveCommand brkpntRemoveCommand = new BrkpntRemoveCommand(debugSession.getTransactionId(), string);
        debugSession.sendCommandLater(brkpntRemoveCommand);
    }

    public static void log(Throwable throwable) {
        throwable.printStackTrace();
    }

    public static void log(InvocationTargetException invocationTargetException) {
        Utils.log(invocationTargetException.getCause());
    }

    public static boolean isPhpFile(FileObject fileObject) {
        if (fileObject == null) {
            return false;
        }
        String string = fileObject.getMIMEType();
        return MIME_TYPE.equals(string);
    }

    public static Line getLine(int n, String string, SessionId sessionId) {
        return lineFactory.getLine(n, string, sessionId);
    }

    public static class LineFactory {
        public Line getLine(int n, String string, SessionId sessionId) {
            DataObject dataObject = sessionId.getDataObjectByRemote(string);
            if (dataObject == null) {
                return null;
            }
            LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
            if (lineCookie == null) {
                return null;
            }
            Line.Set set = lineCookie.getLineSet();
            if (set == null) {
                return null;
            }
            try {
                return set.getCurrent(n - 1);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                Logger.getLogger(Utils.class.getName()).log(Level.FINE, indexOutOfBoundsException.getMessage(), indexOutOfBoundsException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logger.getLogger(Utils.class.getName()).log(Level.FINE, illegalArgumentException.getMessage(), illegalArgumentException);
            }
            return null;
        }
    }
}

