/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.designer.jsf;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.EventListener;
import org.netbeans.modules.visualweb.spi.designer.Decoration;
import org.netbeans.modules.visualweb.spi.designer.DecorationProvider;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;
import org.w3c.dom.Element;

public class DecorationManager {
    public static final String PROP_DECORATION_PROVIDERS = "decorationProviders";
    private static final DecorationManager instance = new DecorationManager();
    private final Lookup.Result<DecorationProvider> lookupResult;
    private final LookupListener decorationProvidersListener = new DecorationProvidersListener(this);
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);

    private DecorationManager() {
        this.lookupResult = Lookup.getDefault().lookup(new Lookup.Template(DecorationProvider.class));
        this.lookupResult.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.decorationProvidersListener, this.lookupResult));
    }

    public static DecorationManager getDefault() {
        return instance;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public Decoration getDecoration(Element element) {
        DecorationProvider[] decorationProviderArray;
        for (DecorationProvider decorationProvider : decorationProviderArray = this.getDecorationProviders()) {
            Decoration decoration = decorationProvider.getDecoration(element);
            if (decoration == null) continue;
            return decoration;
        }
        return null;
    }

    private void fireDecorationProvidersPropertyChange() {
        this.support.firePropertyChange(PROP_DECORATION_PROVIDERS, null, this.getDecorationProviders());
    }

    public DecorationProvider[] getDecorationProviders() {
        Collection collection = this.lookupResult.allInstances();
        return collection.toArray(new DecorationProvider[collection.size()]);
    }

    private static class DecorationProvidersListener
    implements LookupListener {
        private final DecorationManager decorationManager;

        public DecorationProvidersListener(DecorationManager decorationManager) {
            this.decorationManager = decorationManager;
        }

        public void resultChanged(LookupEvent lookupEvent) {
            this.decorationManager.fireDecorationProvidersPropertyChange();
        }
    }
}

