/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.svnclientadapter;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.javahl.JhlClientAdapterFactory;
import org.tigris.subversion.svnclientadapter.svnkit.SvnKitClientAdapterFactory;

public class SvnClientAdapterFactory {
    private Logger LOG = Logger.getLogger("org.netbeans.libs.svnclientadapter");
    private static SvnClientAdapterFactory instance;
    private Client client;

    private SvnClientAdapterFactory() {
    }

    public static SvnClientAdapterFactory getInstance() {
        if (instance == null) {
            instance = new SvnClientAdapterFactory();
        }
        return instance;
    }

    public boolean setup(Client client) throws SVNClientException {
        this.client = client;
        switch (client) {
            case javahl: {
                try {
                    JhlClientAdapterFactory.setup();
                }
                catch (Throwable throwable) {
                    String string = JhlClientAdapterFactory.getLibraryLoadErrors();
                    this.LOG.log(Level.INFO, throwable.getMessage());
                    this.LOG.warning(string + "\n");
                    return false;
                }
                return JhlClientAdapterFactory.isAvailable();
            }
            case svnkit: {
                SvnKitClientAdapterFactory.setup();
                return SvnKitClientAdapterFactory.isAvailable();
            }
        }
        return false;
    }

    public ISVNClientAdapter createClient() {
        switch (this.client) {
            case javahl: {
                return JhlClientAdapterFactory.createSVNClient("javahl");
            }
            case svnkit: {
                return SvnKitClientAdapterFactory.createSVNClient("svnkit");
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Client {
        javahl,
        svnkit;

    }
}

