/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.rake;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.RubyExecution;
import org.netbeans.modules.ruby.platform.Util;
import org.netbeans.modules.ruby.platform.execution.ExecutionDescriptor;
import org.netbeans.modules.ruby.platform.execution.FileLocator;
import org.netbeans.modules.ruby.platform.execution.OutputRecognizer;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.netbeans.modules.ruby.rubyproject.RubyFileLocator;
import org.netbeans.modules.ruby.rubyproject.rake.RakeRunnerAction;
import org.netbeans.modules.ruby.rubyproject.rake.RakeSupport;
import org.netbeans.modules.ruby.rubyproject.rake.RakeTask;
import org.netbeans.modules.ruby.rubyproject.spi.RakeTaskCustomizer;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.openide.LifecycleManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RakeRunner {
    private final Project project;
    private boolean showWarnings;
    private boolean debug;
    private FileObject rakeFile;
    private RubyFileLocator fileLocator;
    private File pwd;
    private String displayName;
    private final List<String> parameters = new ArrayList<String>();
    private static final RequestProcessor RAKE_RUNNER_RP = new RequestProcessor("RakeRunner");

    public RakeRunner(Project project) {
        this.project = project;
    }

    static void runTask(Project project, RakeTask rakeTask, String string, boolean bl) {
        RakeRunner rakeRunner = new RakeRunner(project);
        rakeRunner.showWarnings(true);
        if (string != null) {
            rakeRunner.setParameters(string);
        }
        rakeRunner.setDebug(bl);
        rakeRunner.run(rakeTask);
    }

    public void setRakeFile(FileObject fileObject) {
        this.rakeFile = fileObject;
    }

    public void showWarnings(boolean bl) {
        this.showWarnings = bl;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public void setFileLocator(RubyFileLocator rubyFileLocator) {
        this.fileLocator = rubyFileLocator;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public void setPWD(File file) {
        this.pwd = file;
    }

    public void setParameters(String ... stringArray) {
        Parameters.notNull((CharSequence)"parameters", (Object)stringArray);
        for (String string : stringArray) {
            this.parameters.add(string);
        }
    }

    public void run(String ... stringArray) {
        if (stringArray.length == 0) {
            stringArray = new String[]{"default"};
        }
        if (!RubyPlatform.hasValidRake((Project)this.project, (boolean)this.showWarnings)) {
            return;
        }
        RakeTask[] rakeTaskArray = new RakeTask[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            RakeTask rakeTask = RakeSupport.getRakeTask(this.project, stringArray[i]);
            if (rakeTask == null) {
                if (this.showWarnings) {
                    Util.notifyLocalized(RakeRunner.class, (String)"RakeRunner.task.does.not.exist", (Object[])new Object[]{stringArray[i]});
                }
                return;
            }
            rakeTaskArray[i] = rakeTask;
        }
        this.run(rakeTaskArray);
    }

    private void run(RakeTask ... rakeTaskArray) {
        PropertyEvaluator propertyEvaluator;
        assert (rakeTaskArray.length > 0) : "must pass at least one task";
        if (!RubyPlatform.hasValidRake((Project)this.project, (boolean)this.showWarnings)) {
            return;
        }
        LifecycleManager.getDefault().saveAll();
        if (this.fileLocator == null) {
            this.fileLocator = new RubyFileLocator(Lookup.EMPTY, this.project);
        }
        if (this.rakeFile == null) {
            this.rakeFile = RakeSupport.findRakeFile(this.project);
        }
        if (this.rakeFile == null) {
            this.pwd = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
        }
        if (this.pwd == null) {
            this.pwd = FileUtil.toFile((FileObject)this.rakeFile.getParent());
        }
        List<RakeTask> list = Arrays.asList(rakeTaskArray);
        this.computeAndSetDisplayName(list);
        Object object = null;
        if (this.project != null && (propertyEvaluator = (PropertyEvaluator)this.project.getLookup().lookup(PropertyEvaluator.class)) != null) {
            object = propertyEvaluator.getProperty("source.encoding");
        }
        propertyEvaluator = object;
        final List<ExecutionDescriptor> list2 = this.getExecutionDescriptors(list);
        RAKE_RUNNER_RP.post(new Runnable((String)propertyEvaluator){
            final /* synthetic */ String val$finalCharSet;
            {
                this.val$finalCharSet = string;
            }

            public void run() {
                for (ExecutionDescriptor executionDescriptor : list2) {
                    Task task = new RubyExecution(executionDescriptor, this.val$finalCharSet).run();
                    try {
                        task.waitFinished(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        Exceptions.printStackTrace((Throwable)interruptedException);
                    }
                }
            }
        });
    }

    List<ExecutionDescriptor> getExecutionDescriptors(List<? extends RakeTask> list) {
        RubyPlatform rubyPlatform = RubyPlatform.platformFor((Project)this.project);
        GemManager gemManager = rubyPlatform.getGemManager();
        String string = gemManager.getRake();
        Collection collection = Lookup.getDefault().lookupAll(RakeTaskCustomizer.class);
        ArrayList<ExecutionDescriptor> arrayList = new ArrayList<ExecutionDescriptor>(5);
        for (RakeTask rakeTask : list) {
            ArrayList<String> arrayList222;
            ExecutionDescriptor executionDescriptor = new ExecutionDescriptor(rubyPlatform, this.displayName, this.pwd, string);
            this.doStandardConfiguration(executionDescriptor);
            String[] stringArray = executionDescriptor.getInitialArgs() != null ? executionDescriptor.getInitialArgs() : new String[]{};
            ArrayList<String> arrayList3 = new ArrayList<String>(Arrays.asList(stringArray));
            for (ArrayList<String> arrayList222 : collection) {
                arrayList222.customize(this.project, rakeTask, executionDescriptor, this.debug);
            }
            arrayList3.addAll(rakeTask.getRakeParameters());
            Object object = "";
            arrayList222 = arrayList3.iterator();
            while (arrayList222.hasNext()) {
                object = (String)object + (String)arrayList222.next();
                if (!arrayList222.hasNext()) continue;
                object = (String)object + " ";
            }
            executionDescriptor.initialArgs((String)object);
            arrayList222 = new ArrayList<String>();
            String[] stringArray2 = executionDescriptor.getAdditionalArgs();
            if (stringArray2 != null && stringArray2.length > 0) {
                arrayList222.addAll(Arrays.asList(stringArray2));
            }
            arrayList222.add(rakeTask.getTask());
            for (String string2 : this.parameters) {
                arrayList222.add(string2);
            }
            arrayList222.addAll(rakeTask.getTaskParameters());
            executionDescriptor.additionalArgs(arrayList222.toArray(new String[arrayList222.size()]));
            arrayList.add(executionDescriptor);
        }
        return arrayList;
    }

    private void doStandardConfiguration(ExecutionDescriptor executionDescriptor) {
        String[] stringArray;
        PropertyEvaluator propertyEvaluator;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        if (this.project != null && (propertyEvaluator = (PropertyEvaluator)this.project.getLookup().lookup(PropertyEvaluator.class)) != null) {
            string = propertyEvaluator.getProperty("source.encoding");
            string2 = propertyEvaluator.getProperty("javac.classpath");
            string3 = propertyEvaluator.getProperty("rake.args");
            string4 = propertyEvaluator.getProperty("jvm.args");
            string5 = propertyEvaluator.getProperty("ruby.options");
        }
        propertyEvaluator = new ArrayList();
        if (string3 != null && (stringArray = Utilities.parseParameters(string3)) != null) {
            for (String string6 : stringArray) {
                propertyEvaluator.add(string6);
            }
        }
        if (this.rakeFile != null) {
            propertyEvaluator.add("-f");
            propertyEvaluator.add(FileUtil.toFile((FileObject)this.rakeFile).getAbsolutePath());
        }
        if (!propertyEvaluator.isEmpty()) {
            executionDescriptor.additionalArgs(propertyEvaluator.toArray(new String[propertyEvaluator.size()]));
        }
        if (string5 != null) {
            executionDescriptor.initialArgs(string5);
        }
        executionDescriptor.allowInput();
        executionDescriptor.classPath(string2);
        executionDescriptor.jvmArguments(string4);
        executionDescriptor.fileLocator((FileLocator)this.fileLocator);
        executionDescriptor.addStandardRecognizers();
        if (RubyPlatform.platformFor((Project)this.project).isJRuby()) {
            executionDescriptor.appendJdkToPath(true);
        }
        executionDescriptor.addOutputRecognizer((OutputRecognizer)new RakeErrorRecognizer(executionDescriptor, string)).debug(this.debug);
    }

    private void computeAndSetDisplayName(List<? extends RakeTask> list) {
        ProjectInformation projectInformation = ProjectUtils.getInformation((Project)this.project);
        String string = projectInformation == null ? NbBundle.getMessage(RakeRunnerAction.class, (String)"RakeRunnerAction.Rake") : projectInformation.getDisplayName();
        StringBuilder stringBuilder = new StringBuilder(string).append(" (");
        for (int i = 0; i < list.size(); ++i) {
            stringBuilder.append(list.get(i).getTask());
            if (i == list.size() - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(')');
        this.setDisplayName(stringBuilder.toString());
    }

    private class RakeErrorRecognizer
    extends OutputRecognizer
    implements Runnable {
        private final ExecutionDescriptor desc;
        private final String charsetName;

        RakeErrorRecognizer(ExecutionDescriptor executionDescriptor, String string) {
            this.desc = executionDescriptor;
            this.charsetName = string;
        }

        public OutputRecognizer.RecognizedOutput processLine(String string) {
            if (string.indexOf("(See full trace by running task with --trace)") != -1) {
                return new OutputRecognizer.ActionText(new String[]{string}, new String[]{NbBundle.getMessage(RakeRunner.class, (String)"RakeSupport.RerunRakeWithTrace")}, new Runnable[]{this}, null);
            }
            return null;
        }

        public void run() {
            String[] stringArray = this.desc.getAdditionalArgs();
            if (stringArray != null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                boolean bl = false;
                for (String string : stringArray) {
                    arrayList.add(string);
                    if (!string.equals("--trace")) continue;
                    bl = true;
                }
                if (!bl) {
                    arrayList.add(0, "--trace");
                }
                this.desc.additionalArgs(arrayList.toArray(new String[arrayList.size()]));
            } else {
                this.desc.additionalArgs(new String[]{"--trace"});
            }
            new RubyExecution(this.desc, this.charsetName).run();
        }
    }
}

