/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.editor.fold;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldType;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.DataLoadersBridge;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.StructureScanner;
import org.netbeans.modules.gsfret.editor.semantic.ScanningCancellableTask;
import org.netbeans.spi.editor.fold.FoldHierarchyTransaction;
import org.netbeans.spi.editor.fold.FoldManager;
import org.netbeans.spi.editor.fold.FoldOperation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;

public class GsfFoldManager
implements FoldManager {
    public static final FoldType CODE_BLOCK_FOLD_TYPE = new FoldType("code-block");
    public static final FoldType INITIAL_COMMENT_FOLD_TYPE = new FoldType("initial-comment");
    public static final FoldType IMPORTS_FOLD_TYPE = new FoldType("imports");
    public static final FoldType JAVADOC_FOLD_TYPE = new FoldType("javadoc");
    private static final String IMPORTS_FOLD_DESCRIPTION = "...";
    private static final String COMMENT_FOLD_DESCRIPTION = "...";
    private static final String JAVADOC_FOLD_DESCRIPTION = "...";
    private static final String CODE_BLOCK_FOLD_DESCRIPTION = "{...}";
    public static final FoldTemplate CODE_BLOCK_FOLD_TEMPLATE = new FoldTemplate(CODE_BLOCK_FOLD_TYPE, "{...}", 1, 1);
    public static final FoldTemplate INITIAL_COMMENT_FOLD_TEMPLATE = new FoldTemplate(INITIAL_COMMENT_FOLD_TYPE, "...", 2, 2);
    public static final FoldTemplate IMPORTS_FOLD_TEMPLATE = new FoldTemplate(IMPORTS_FOLD_TYPE, "...", 0, 0);
    public static final FoldTemplate JAVADOC_FOLD_TEMPLATE = new FoldTemplate(JAVADOC_FOLD_TYPE, "...", 3, 2);
    public static final String CODE_FOLDING_COLLAPSE_METHOD = "code-folding-collapse-method";
    public static final String CODE_FOLDING_COLLAPSE_INNERCLASS = "code-folding-collapse-innerclass";
    public static final String CODE_FOLDING_COLLAPSE_IMPORT = "code-folding-collapse-import";
    public static final String CODE_FOLDING_COLLAPSE_JAVADOC = "code-folding-collapse-javadoc";
    public static final String CODE_FOLDING_COLLAPSE_INITIAL_COMMENT = "code-folding-collapse-initial-comment";
    private FoldOperation operation;
    private FileObject file;
    private JavaElementFoldTask task;
    private Preferences prefs;
    private Map<FoldInfo, Fold> currentFolds;
    private Fold initialCommentFold;
    private Fold importsFold;

    public void init(FoldOperation foldOperation) {
        this.operation = foldOperation;
        String string = DocumentUtilities.getMimeType((JTextComponent)foldOperation.getHierarchy().getComponent());
        this.prefs = (Preferences)MimeLookup.getLookup((String)string).lookup(Preferences.class);
    }

    public synchronized void initFolds(FoldHierarchyTransaction foldHierarchyTransaction) {
        Document document = this.operation.getHierarchy().getComponent().getDocument();
        this.file = DataLoadersBridge.getDefault().getFileObject(document);
        if (this.file != null) {
            this.currentFolds = new HashMap<FoldInfo, Fold>();
            this.task = JavaElementFoldTask.getTask(this.file);
            this.task.setGsfFoldManager(this);
        }
    }

    public void insertUpdate(DocumentEvent documentEvent, FoldHierarchyTransaction foldHierarchyTransaction) {
    }

    public void removeUpdate(DocumentEvent documentEvent, FoldHierarchyTransaction foldHierarchyTransaction) {
    }

    public void changedUpdate(DocumentEvent documentEvent, FoldHierarchyTransaction foldHierarchyTransaction) {
    }

    public void removeEmptyNotify(Fold fold) {
        this.removeDamagedNotify(fold);
    }

    public void removeDamagedNotify(Fold fold) {
        this.currentFolds.remove(this.operation.getExtraInfo(fold));
        if (this.importsFold == fold) {
            this.importsFold = null;
        }
        if (this.initialCommentFold == fold) {
            this.initialCommentFold = null;
        }
    }

    public void expandNotify(Fold fold) {
    }

    public synchronized void release() {
        if (this.task != null) {
            this.task.setGsfFoldManager(null);
        }
        this.task = null;
        this.file = null;
        this.currentFolds = null;
        this.importsFold = null;
        this.initialCommentFold = null;
    }

    private boolean getSetting(String string) {
        return this.prefs.getBoolean(string, false);
    }

    protected static final class FoldInfo
    implements Comparable {
        private Position start;
        private Position end;
        private FoldTemplate template;
        private boolean collapseByDefault;

        public FoldInfo(Document document, int n, int n2, FoldTemplate foldTemplate, boolean bl) throws BadLocationException {
            this.start = document.createPosition(n);
            this.end = document.createPosition(n2);
            this.template = foldTemplate;
            this.collapseByDefault = bl;
        }

        public int hashCode() {
            return 1;
        }

        public boolean equals(Object object) {
            if (!(object instanceof FoldInfo)) {
                return false;
            }
            return this.compareTo(object) == 0;
        }

        public int compareTo(Object object) {
            FoldInfo foldInfo = (FoldInfo)object;
            if (this.start.getOffset() < foldInfo.start.getOffset()) {
                return -1;
            }
            if (this.start.getOffset() > foldInfo.start.getOffset()) {
                return 1;
            }
            if (this.end.getOffset() < foldInfo.end.getOffset()) {
                return -1;
            }
            if (this.end.getOffset() > foldInfo.end.getOffset()) {
                return 1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CommitFolds
    implements Runnable {
        private boolean insideRender;
        private TreeSet<FoldInfo> infos;
        private long startTime;

        public CommitFolds(TreeSet<FoldInfo> treeSet) {
            this.infos = treeSet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Document document = GsfFoldManager.this.operation.getHierarchy().getComponent().getDocument();
            if (!this.insideRender) {
                this.startTime = System.currentTimeMillis();
                this.insideRender = true;
                document.render(this);
                return;
            }
            GsfFoldManager.this.operation.getHierarchy().lock();
            try {
                FoldHierarchyTransaction foldHierarchyTransaction = GsfFoldManager.this.operation.openTransaction();
                try {
                    if (GsfFoldManager.this.currentFolds == null) {
                        return;
                    }
                    TreeMap<FoldInfo, Fold> treeMap = new TreeMap<FoldInfo, Fold>();
                    TreeSet treeSet = new TreeSet(GsfFoldManager.this.currentFolds.keySet());
                    int n = document.getLength();
                    for (FoldInfo foldInfo : this.infos) {
                        if (treeSet.remove(foldInfo)) continue;
                        int n2 = foldInfo.start.getOffset();
                        int n3 = foldInfo.end.getOffset();
                        if (n3 > n || n3 <= n2 || n3 - n2 <= foldInfo.template.getStartGuardedLength() + foldInfo.template.getEndGuardedLength()) continue;
                        Fold fold = GsfFoldManager.this.operation.addToHierarchy(foldInfo.template.getType(), foldInfo.template.getDescription(), foldInfo.collapseByDefault, n2, n3, foldInfo.template.getStartGuardedLength(), foldInfo.template.getEndGuardedLength(), (Object)foldInfo, foldHierarchyTransaction);
                        treeMap.put(foldInfo, fold);
                        if (foldInfo.template == IMPORTS_FOLD_TEMPLATE) {
                            GsfFoldManager.this.importsFold = fold;
                        }
                        if (foldInfo.template != INITIAL_COMMENT_FOLD_TEMPLATE) continue;
                        GsfFoldManager.this.initialCommentFold = fold;
                    }
                    for (FoldInfo foldInfo : treeSet) {
                        Fold fold = (Fold)GsfFoldManager.this.currentFolds.remove(foldInfo);
                        GsfFoldManager.this.operation.removeFromHierarchy(fold, foldHierarchyTransaction);
                        if (GsfFoldManager.this.importsFold == fold) {
                            GsfFoldManager.this.importsFold = null;
                        }
                        if (GsfFoldManager.this.initialCommentFold != fold) continue;
                        GsfFoldManager.this.initialCommentFold = fold;
                    }
                    GsfFoldManager.this.currentFolds.putAll(treeMap);
                }
                catch (BadLocationException badLocationException) {
                    ErrorManager.getDefault().notify((Throwable)badLocationException);
                }
                finally {
                    foldHierarchyTransaction.commit();
                }
            }
            finally {
                GsfFoldManager.this.operation.getHierarchy().unlock();
            }
            long l = System.currentTimeMillis();
            Logger.getLogger("TIMER").log(Level.FINE, "Folds - 2", new Object[]{GsfFoldManager.this.file, l - this.startTime});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class JavaElementFoldTask
    extends ScanningCancellableTask<org.netbeans.napi.gsfret.source.CompilationInfo> {
        private static Map<FileObject, JavaElementFoldTask> file2Task = new WeakHashMap<FileObject, JavaElementFoldTask>();
        private Reference<GsfFoldManager> manager;

        JavaElementFoldTask() {
        }

        static JavaElementFoldTask getTask(FileObject fileObject) {
            JavaElementFoldTask javaElementFoldTask = file2Task.get(fileObject);
            if (javaElementFoldTask == null) {
                javaElementFoldTask = new JavaElementFoldTask();
                file2Task.put(fileObject, javaElementFoldTask);
            }
            return javaElementFoldTask;
        }

        synchronized void setGsfFoldManager(GsfFoldManager gsfFoldManager) {
            this.manager = new WeakReference<GsfFoldManager>(gsfFoldManager);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run(org.netbeans.napi.gsfret.source.CompilationInfo compilationInfo) {
            GsfFoldManager gsfFoldManager;
            this.resume();
            JavaElementFoldTask javaElementFoldTask = this;
            synchronized (javaElementFoldTask) {
                gsfFoldManager = this.manager != null ? this.manager.get() : null;
            }
            if (gsfFoldManager == null) {
                return;
            }
            long l = System.currentTimeMillis();
            if (compilationInfo.hasInvalidResults()) {
                return;
            }
            TreeSet<FoldInfo> treeSet = new TreeSet<FoldInfo>();
            boolean bl = this.gsfFoldScan(gsfFoldManager, compilationInfo, treeSet);
            if (!bl || this.isCancelled()) {
                return;
            }
            GsfFoldManager gsfFoldManager2 = gsfFoldManager;
            gsfFoldManager2.getClass();
            SwingUtilities.invokeLater(gsfFoldManager2.new CommitFolds(treeSet));
            long l2 = System.currentTimeMillis();
            Logger.getLogger("TIMER").log(Level.FINE, "Folds - 1", new Object[]{compilationInfo.getFileObject(), l2 - l});
        }

        private boolean gsfFoldScan(GsfFoldManager gsfFoldManager, org.netbeans.napi.gsfret.source.CompilationInfo compilationInfo, TreeSet<FoldInfo> treeSet) {
            BaseDocument baseDocument = (BaseDocument)compilationInfo.getDocument();
            if (baseDocument == null) {
                return false;
            }
            Set<String> set = compilationInfo.getEmbeddedMimeTypes();
            for (String string : set) {
                Language language = LanguageRegistry.getInstance().getLanguageByMimeType(string);
                if (language == null) continue;
                this.scan(gsfFoldManager, compilationInfo, treeSet, baseDocument, language);
            }
            if (this.isCancelled()) {
                return false;
            }
            boolean bl = this.checkInitialFold(gsfFoldManager, compilationInfo, treeSet);
            return bl;
        }

        private boolean checkInitialFold(GsfFoldManager gsfFoldManager, org.netbeans.napi.gsfret.source.CompilationInfo compilationInfo, TreeSet<FoldInfo> treeSet) {
            try {
                TokenHierarchy<?> tokenHierarchy = compilationInfo.getTokenHierarchy();
                if (tokenHierarchy == null) {
                    return false;
                }
                TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
                while (tokenSequence.moveNext()) {
                    Token token = tokenSequence.token();
                    String string = token.id().primaryCategory();
                    if ("comment".equals(string)) {
                        Document document = gsfFoldManager.operation.getHierarchy().getComponent().getDocument();
                        int n = tokenSequence.offset();
                        int n2 = n + token.length();
                        boolean bl = gsfFoldManager.getSetting(GsfFoldManager.CODE_FOLDING_COLLAPSE_INITIAL_COMMENT);
                        if (gsfFoldManager.initialCommentFold != null) {
                            bl = gsfFoldManager.initialCommentFold.isCollapsed();
                        }
                        while (tokenSequence.moveNext()) {
                            token = tokenSequence.token();
                            string = token.id().primaryCategory();
                            if ("comment".equals(string)) {
                                n2 = tokenSequence.offset() + token.length();
                                continue;
                            }
                            if ("whitespace".equals(string)) continue;
                        }
                        try {
                            n = Utilities.getRowEnd((BaseDocument)((BaseDocument)document), (int)n);
                            if (n >= n2) {
                                return true;
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            ErrorManager.getDefault().notify((Throwable)badLocationException);
                        }
                        treeSet.add(new FoldInfo(document, n, n2, INITIAL_COMMENT_FOLD_TEMPLATE, bl));
                        return true;
                    }
                    if ("whitespace".equals(string)) continue;
                    break;
                }
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                return false;
            }
            return true;
        }

        private void scan(GsfFoldManager gsfFoldManager, org.netbeans.napi.gsfret.source.CompilationInfo compilationInfo, TreeSet<FoldInfo> treeSet, BaseDocument baseDocument, Language language) {
            this.addTree(gsfFoldManager, treeSet, compilationInfo, baseDocument, language);
        }

        private void addTree(GsfFoldManager gsfFoldManager, TreeSet<FoldInfo> treeSet, org.netbeans.napi.gsfret.source.CompilationInfo compilationInfo, BaseDocument baseDocument, Language language) {
            StructureScanner structureScanner = language.getStructure();
            if (structureScanner != null) {
                boolean bl;
                Map map = structureScanner.folds((CompilationInfo)compilationInfo);
                if (this.isCancelled()) {
                    return;
                }
                List list = (List)map.get("codeblocks");
                if (list != null) {
                    bl = gsfFoldManager.getSetting(GsfFoldManager.CODE_FOLDING_COLLAPSE_METHOD);
                    for (OffsetRange offsetRange : list) {
                        this.addFold(offsetRange, treeSet, baseDocument, bl, CODE_BLOCK_FOLD_TEMPLATE);
                    }
                }
                if ((list = (List)map.get("comments")) != null) {
                    bl = gsfFoldManager.getSetting(GsfFoldManager.CODE_FOLDING_COLLAPSE_JAVADOC);
                    for (OffsetRange offsetRange : list) {
                        this.addFold(offsetRange, treeSet, baseDocument, bl, JAVADOC_FOLD_TEMPLATE);
                    }
                }
                if ((list = (List)map.get("initial-comment")) != null) {
                    for (OffsetRange offsetRange : list) {
                        boolean bl2 = gsfFoldManager.getSetting(GsfFoldManager.CODE_FOLDING_COLLAPSE_INITIAL_COMMENT);
                        this.addFold(offsetRange, treeSet, baseDocument, bl2, INITIAL_COMMENT_FOLD_TEMPLATE);
                    }
                }
                if ((list = (List)map.get("imports")) != null) {
                    for (OffsetRange offsetRange : list) {
                        boolean bl3 = gsfFoldManager.getSetting(GsfFoldManager.CODE_FOLDING_COLLAPSE_IMPORT);
                        this.addFold(offsetRange, treeSet, baseDocument, bl3, IMPORTS_FOLD_TEMPLATE);
                    }
                }
            }
        }

        private void addFold(OffsetRange offsetRange, TreeSet<FoldInfo> treeSet, BaseDocument baseDocument, boolean bl, FoldTemplate foldTemplate) {
            if (offsetRange != OffsetRange.NONE) {
                int n = offsetRange.getStart();
                int n2 = offsetRange.getEnd();
                if (n != -1 && n2 != -1 && n2 <= baseDocument.getLength()) {
                    try {
                        treeSet.add(new FoldInfo((Document)baseDocument, n, n2, foldTemplate, bl));
                    }
                    catch (BadLocationException badLocationException) {
                        ErrorManager.getDefault().notify((Throwable)badLocationException);
                    }
                }
            }
        }
    }

    protected static final class FoldTemplate {
        private FoldType type;
        private String description;
        private int startGuardedLength;
        private int endGuardedLength;

        protected FoldTemplate(FoldType foldType, String string, int n, int n2) {
            this.type = foldType;
            this.description = string;
            this.startGuardedLength = n;
            this.endGuardedLength = n2;
        }

        public FoldType getType() {
            return this.type;
        }

        public String getDescription() {
            return this.description;
        }

        public int getStartGuardedLength() {
            return this.startGuardedLength;
        }

        public int getEndGuardedLength() {
            return this.endGuardedLength;
        }
    }
}

