/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.gsfret;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.gsfret.InstantRenamePerformer;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.DataLoadersBridge;
import org.netbeans.modules.gsf.api.InstantRenamer;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.refactoring.api.ui.RefactoringActionsFactory;
import org.netbeans.napi.gsfret.source.CompilationController;
import org.netbeans.napi.gsfret.source.Phase;
import org.netbeans.napi.gsfret.source.Source;
import org.netbeans.napi.gsfret.source.SourceUtils;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstantRenameAction
extends BaseAction {
    public InstantRenameAction() {
        super("in-place-refactoring", 10);
    }

    public void actionPerformed(ActionEvent actionEvent, final JTextComponent jTextComponent) {
        try {
            final int n = jTextComponent.getCaretPosition();
            String string = Utilities.getIdentifier((BaseDocument)Utilities.getDocument((JTextComponent)jTextComponent), (int)n);
            if (string == null) {
                Utilities.setStatusBoldText((JTextComponent)jTextComponent, (String)"Cannot perform rename here.");
                return;
            }
            if (SourceUtils.isScanInProgress()) {
                Utilities.setStatusBoldText((JTextComponent)jTextComponent, (String)"Scanning In Progress");
                return;
            }
            Source source = Source.forFileObject(DataLoadersBridge.getDefault().getFileObject(jTextComponent));
            if (source == null) {
                return;
            }
            final boolean[] blArray = new boolean[1];
            final String[] stringArray = new String[1];
            final Set[] setArray = new Set[1];
            source.runUserActionTask(new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController compilationController) throws Exception {
                    if (compilationController.toPhase(Phase.RESOLVED).compareTo(Phase.RESOLVED) < 0) {
                        return;
                    }
                    Document document = jTextComponent.getDocument();
                    BaseDocument baseDocument = (BaseDocument)document;
                    List<Language> list = LanguageRegistry.getInstance().getEmbeddedLanguages(baseDocument, n);
                    Language language = null;
                    for (Language stringArray2 : list) {
                        if (stringArray2.getInstantRenamer() == null) continue;
                        language = stringArray2;
                        break;
                    }
                    if (language != null) {
                        InstantRenamer instantRenamer = language.getInstantRenamer();
                        assert (instantRenamer != null);
                        String[] stringArray3 = new String[1];
                        if (instantRenamer == null || !instantRenamer.isRenameAllowed((CompilationInfo)compilationController, n, stringArray3)) {
                            blArray[0] = false;
                            stringArray[0] = stringArray3[0];
                            return;
                        }
                        blArray[0] = true;
                        Set set = instantRenamer.getRenameRegions((CompilationInfo)compilationController, n);
                        if (set != null && set.size() > 0) {
                            setArray[0] = set;
                        }
                    }
                }
            }, true);
            if (blArray[0]) {
                if (setArray[0] != null) {
                    this.doInstantRename(setArray[0], jTextComponent, n, string);
                } else {
                    this.doFullRename((EditorCookie)DataLoadersBridge.getDefault().getCookie(jTextComponent, EditorCookie.class), DataLoadersBridge.getDefault().getNodeDelegate(jTextComponent));
                }
            } else {
                if (stringArray[0] == null) {
                    stringArray[0] = NbBundle.getMessage(InstantRenameAction.class, (String)"InstantRenameDenied");
                }
                Utilities.setStatusBoldText((JTextComponent)jTextComponent, (String)stringArray[0]);
            }
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify((Throwable)badLocationException);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    protected Class getShortDescriptionBundleClass() {
        return InstantRenameAction.class;
    }

    private void doInstantRename(Set<OffsetRange> set, JTextComponent jTextComponent, int n, String string) throws BadLocationException {
        InstantRenamePerformer.performInstantRename(jTextComponent, set, n);
    }

    private void doFullRename(EditorCookie editorCookie, Node node) {
        InstanceContent instanceContent = new InstanceContent();
        instanceContent.add((Object)editorCookie);
        instanceContent.add((Object)node);
        AbstractLookup abstractLookup = new AbstractLookup((AbstractLookup.Content)instanceContent);
        Action action = RefactoringActionsFactory.renameAction().createContextAwareInstance((Lookup)abstractLookup);
        action.actionPerformed(RefactoringActionsFactory.DEFAULT_EVENT);
    }
}

