/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.model.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.events.ChangeEvent;
import org.netbeans.modules.bpel.model.api.events.PropertyUpdateEvent;
import org.netbeans.modules.bpel.model.api.references.BpelReference;
import org.netbeans.modules.bpel.model.api.references.BpelReferenceable;
import org.netbeans.modules.bpel.model.api.references.ReferenceCollection;
import org.netbeans.modules.bpel.model.api.support.Utils;
import org.netbeans.modules.bpel.model.impl.BpelEntityImpl;
import org.netbeans.modules.bpel.model.impl.services.InnerEventDispatcherAdapter;
import org.netbeans.modules.xml.xam.Reference;
import org.netbeans.modules.xml.xam.Referenceable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceIntegrityService
extends InnerEventDispatcherAdapter {
    private ThreadLocal<Map<ChangeEvent, Map<BpelEntity, Collection<Reference>>>> myMap = new ThreadLocal();

    @Override
    public boolean isApplicable(ChangeEvent changeEvent) {
        BpelEntity bpelEntity = changeEvent.getParent();
        if (bpelEntity instanceof BpelEntityImpl && changeEvent instanceof PropertyUpdateEvent) {
            if (!((BpelEntityImpl)bpelEntity).isInTree()) {
                return false;
            }
            return !bpelEntity.getBpelModel().inSync() && bpelEntity instanceof BpelReferenceable;
        }
        return false;
    }

    @Override
    public void preDispatch(ChangeEvent changeEvent) {
        if (changeEvent instanceof PropertyUpdateEvent) {
            BpelEntity bpelEntity = changeEvent.getParent();
            BpelEntity bpelEntity2 = ((BpelEntityImpl)bpelEntity).isInTree() ? bpelEntity.getBpelModel().getProcess() : Utils.getUnattachedRoot(bpelEntity);
            this.collectReferenced(bpelEntity2, bpelEntity, changeEvent);
        }
    }

    @Override
    public void postDispatch(ChangeEvent changeEvent) {
        if (changeEvent instanceof PropertyUpdateEvent) {
            BpelEntity bpelEntity = changeEvent.getParent();
            Map<BpelEntity, Collection<Reference>> map = this.getMap(changeEvent);
            for (Map.Entry<BpelEntity, Collection<Reference>> entry : map.entrySet()) {
                BpelEntity bpelEntity2 = entry.getKey();
                Collection<Reference> collection = entry.getValue();
                for (Reference reference : collection) {
                    ((BpelEntityImpl)bpelEntity2).updateReference(reference, (BpelReferenceable)bpelEntity);
                }
            }
            this.reset(changeEvent);
        }
    }

    @Override
    public void reset(ChangeEvent changeEvent) {
        Map<ChangeEvent, Map<BpelEntity, Collection<Reference>>> map = this.myMap.get();
        if (map == null) {
            return;
        }
        Map<BpelEntity, Collection<Reference>> map2 = map.remove(changeEvent);
        if (map2 != null) {
            map2.clear();
        }
    }

    private void collectReferenced(BpelEntity bpelEntity, BpelEntity bpelEntity2, ChangeEvent changeEvent) {
        Object object;
        assert (bpelEntity2 != null);
        if (bpelEntity instanceof ReferenceCollection) {
            object = ((ReferenceCollection)((Object)bpelEntity)).getReferences();
            assert (object != null);
            for (Object object2 : object) {
                if (!(object2 instanceof BpelReference) || !object2.references((Referenceable)((BpelReferenceable)bpelEntity2))) continue;
                this.addReference(bpelEntity, (Reference)object2, changeEvent);
            }
        }
        object = bpelEntity.getChildren(BpelEntityImpl.class);
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            BpelEntityImpl bpelEntityImpl = (BpelEntityImpl)iterator.next();
            if (!bpelEntityImpl.getParent().isRegular(bpelEntityImpl)) continue;
            this.collectReferenced(bpelEntityImpl, bpelEntity2, changeEvent);
        }
    }

    private void addReference(BpelEntity bpelEntity, Reference reference, ChangeEvent changeEvent) {
        Map<BpelEntity, Collection<Reference>> map = this.getMap(changeEvent);
        Collection<Reference> collection = map.get(bpelEntity);
        if (collection == null) {
            collection = new LinkedList<Reference>();
            map.put(bpelEntity, collection);
        }
        collection.add(reference);
    }

    private Map<BpelEntity, Collection<Reference>> getMap(ChangeEvent changeEvent) {
        Map<BpelEntity, Collection<Reference>> map;
        Map<ChangeEvent, Map<BpelEntity, Collection<Reference>>> map2 = this.myMap.get();
        if (map2 == null) {
            map2 = new WeakHashMap<ChangeEvent, Map<BpelEntity, Collection<Reference>>>();
            this.myMap.set(map2);
        }
        if ((map = map2.get(changeEvent)) == null) {
            map = new HashMap<BpelEntity, Collection<Reference>>();
            map2.put(changeEvent, map);
        }
        return map;
    }
}

