/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.model.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEditSupport;
import javax.xml.namespace.QName;
import org.netbeans.modules.bpel.model.api.AnotherVersionBpelProcess;
import org.netbeans.modules.bpel.model.api.BpelContainer;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.ContentElement;
import org.netbeans.modules.bpel.model.api.ExtensibleElements;
import org.netbeans.modules.bpel.model.api.ExtensionEntity;
import org.netbeans.modules.bpel.model.api.Process;
import org.netbeans.modules.bpel.model.api.events.ChangeEvent;
import org.netbeans.modules.bpel.model.api.events.ChangeEventListener;
import org.netbeans.modules.bpel.model.api.events.ChangeEventSupport;
import org.netbeans.modules.bpel.model.api.events.PropertyUpdateEvent;
import org.netbeans.modules.bpel.model.api.events.VetoException;
import org.netbeans.modules.bpel.model.api.support.UniqueId;
import org.netbeans.modules.bpel.model.impl.AnotherVersionBpelProcessImpl;
import org.netbeans.modules.bpel.model.impl.BpelBuilderImpl;
import org.netbeans.modules.bpel.model.impl.BpelChildEntitiesBuilder;
import org.netbeans.modules.bpel.model.impl.BpelEntityImpl;
import org.netbeans.modules.bpel.model.impl.EntityFactoryRegistry;
import org.netbeans.modules.bpel.model.impl.ProcessImpl;
import org.netbeans.modules.bpel.model.impl.SyncUpdateVisitor;
import org.netbeans.modules.bpel.model.impl.UniqueIdImpl;
import org.netbeans.modules.bpel.model.impl.events.TreeCreatedEvent;
import org.netbeans.modules.bpel.model.spi.EntityFactory;
import org.netbeans.modules.bpel.model.xam.BpelElements;
import org.netbeans.modules.bpel.model.xam.spi.InnerEventDispatcher;
import org.netbeans.modules.xml.xam.AbstractModel;
import org.netbeans.modules.xml.xam.ComponentEvent;
import org.netbeans.modules.xml.xam.ComponentListener;
import org.netbeans.modules.xml.xam.ComponentUpdater;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentModel;
import org.netbeans.modules.xml.xam.dom.DocumentComponent;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BpelModelImpl
extends AbstractDocumentModel<BpelEntity>
implements BpelModel {
    private ChangeEventSupport mySupport;
    private Lookup.Result innerDispatcherResult;
    private InnerEventDispatcher[] myDispatchers;
    private final BpelBuilderImpl myBuilder = new BpelBuilderImpl(this);
    private ProcessImpl myProcess;
    private AtomicLong myNextID = new AtomicLong();
    private final ReentrantReadWriteLock myLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.myLock.readLock();
    private final Lock writeLock = this.myLock.writeLock();
    private BpelModelUndoableEditSupport myUndoSupport;
    private SyncUpdateVisitor mySyncUpdateVisitor;
    private XDMListener myXDMListener;
    private Transaction myTransaction;
    private PropertyChangeSupport myPropertyChangeSupport;
    private EventListenerList myComponentListeners;
    private boolean isXamTransaction;
    private UndoableEditListener[] mySavedUndoableEditListeners;
    private ThreadLocal<Boolean> myReadLockObtained = new ThreadLocal();
    private BpelChildEntitiesBuilder myChildBuilder;
    private Element myAnotherRoot;

    public BpelModelImpl(Document document, Lookup lookup) {
        this(BpelModelImpl.getOrCreateModelSource(document, lookup));
    }

    public BpelModelImpl(ModelSource modelSource) {
        super(modelSource);
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcessImpl getProcess() {
        this.readLock();
        try {
            ProcessImpl processImpl = (ProcessImpl)this.getRootComponent();
            return processImpl;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public BpelBuilderImpl getBuilder() {
        return this.myBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BpelEntity getEntity(UniqueId uniqueId) {
        this.readLock();
        try {
            BpelEntityImpl bpelEntityImpl = ((UniqueIdImpl)uniqueId).getEntity();
            if (bpelEntityImpl.isDeleted()) {
                BpelEntity bpelEntity = null;
                return bpelEntity;
            }
            BpelEntityImpl bpelEntityImpl2 = bpelEntityImpl;
            return bpelEntityImpl2;
        }
        finally {
            this.readUnlock();
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.myPropertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.myPropertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removeComponentListener(ComponentListener componentListener) {
        this.myComponentListeners.remove(ComponentListener.class, componentListener);
    }

    public void addComponentListener(ComponentListener componentListener) {
        this.myComponentListeners.add(ComponentListener.class, componentListener);
    }

    @Override
    public void addEntityChangeListener(ChangeEventListener changeEventListener) {
        this.mySupport.addChangeEventListener(changeEventListener);
    }

    @Override
    public void removeEntityChangeListener(ChangeEventListener changeEventListener) {
        this.mySupport.removeChangeEventListener(changeEventListener);
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.myUndoSupport.addUndoableEditListener(undoableEditListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.myUndoSupport.removeUndoableEditListener(undoableEditListener);
    }

    public synchronized void addUndoableRefactorListener(UndoableEditListener undoableEditListener) {
        this.mySavedUndoableEditListeners = this.myUndoSupport.getUndoableEditListeners();
        if (this.mySavedUndoableEditListeners != null) {
            for (UndoableEditListener undoableEditListener2 : this.mySavedUndoableEditListeners) {
                if (!(undoableEditListener2 instanceof UndoManager)) continue;
                ((UndoManager)undoableEditListener2).discardAllEdits();
            }
        }
        this.myUndoSupport = new BpelModelUndoableEditSupport();
        this.myUndoSupport.addUndoableEditListener(undoableEditListener);
    }

    public synchronized void removeUndoableRefactorListener(UndoableEditListener undoableEditListener) {
        this.myUndoSupport.removeUndoableEditListener(undoableEditListener);
        this.myUndoSupport = new BpelModelUndoableEditSupport();
        if (this.mySavedUndoableEditListeners != null) {
            for (UndoableEditListener undoableEditListener2 : this.mySavedUndoableEditListeners) {
                this.myUndoSupport.addUndoableEditListener(undoableEditListener2);
            }
            this.mySavedUndoableEditListeners = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> V invoke(Callable<V> callable, Object object) throws Exception {
        this.writeLock(true, false);
        try {
            V v;
            assert (this.myTransaction != null);
            this.myTransaction.setSource(object);
            V v2 = v = callable.call();
            return v2;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(Runnable runnable) {
        this.readLock();
        try {
            this.myReadLockObtained.set(true);
            runnable.run();
        }
        finally {
            this.myReadLockObtained.set(false);
            this.readUnlock();
        }
    }

    public BpelEntity createRootComponent(Element element) {
        String string = element.getNamespaceURI();
        if ("http://docs.oasis-open.org/wsbpel/2.0/process/executable".equals(string) && BpelElements.PROCESS.getName().equals(element.getLocalName())) {
            this.myProcess = new ProcessImpl(this, element);
            this.myAnotherRoot = null;
            return this.myProcess;
        }
        this.myAnotherRoot = element;
        return null;
    }

    public BpelEntity getRootComponent() {
        return this.myProcess;
    }

    public void validateWrite() {
    }

    public void firePropertyChangeEvent(PropertyChangeEvent propertyChangeEvent) {
        this.myPropertyChangeSupport.firePropertyChange(propertyChangeEvent);
    }

    public void fireComponentChangedEvent(ComponentEvent componentEvent) {
        ComponentListener[] componentListenerArray;
        for (ComponentListener n : componentListenerArray = (ComponentListener[])this.myComponentListeners.getListeners(ComponentListener.class)) {
            componentEvent.getEventType().fireEvent(componentEvent, n);
        }
        if (this.inSync() && componentEvent.getEventType().equals((Object)ComponentEvent.EventType.VALUE_CHANGED)) {
            int n;
            Object object = componentEvent.getSource();
            if (!(object instanceof AbstractDocumentComponent)) {
                return;
            }
            AbstractDocumentComponent abstractDocumentComponent = (AbstractDocumentComponent)object;
            Element element = abstractDocumentComponent.getPeer();
            assert (this.myTransaction != null);
            while ((n = this.myTransaction.remove(element)) >= 0) {
                Node node = this.myTransaction.removeOldAttribute(n);
                Node node2 = this.myTransaction.removeNewAttribute(n);
                if (!(abstractDocumentComponent instanceof BpelEntityImpl)) continue;
                ((BpelEntityImpl)abstractDocumentComponent).handleAttributeChange(node, node2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() throws IOException {
        this.writeLock(true, true);
        ProcessImpl processImpl = null;
        Model.State state = null;
        try {
            if (this.myLock.getWriteHoldCount() > 1) {
                return;
            }
            state = this.getState();
            processImpl = this.getProcess();
            this.preTreeCreated(processImpl);
            super.sync();
            this.postTreeCreated(processImpl, this.getProcess());
        }
        finally {
            try {
                if (state != this.getState()) {
                    PropertyUpdateEvent propertyUpdateEvent = new PropertyUpdateEvent(this.getSource(), processImpl, "<state>", state, this.getState());
                    this.fireChangeEvent(propertyUpdateEvent);
                }
            }
            finally {
                this.writeUnlock(true);
            }
        }
    }

    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        if (!this.inUndoRedo()) {
            assert (this.myLock.getWriteHoldCount() > 0);
            if (!this.myUndoSupport.editInProgress()) {
                this.myUndoSupport.beginUpdate();
            }
        }
        this.myUndoSupport.postEdit(undoableEditEvent.getEdit());
    }

    public Set<QName> getQNames() {
        return this.getEntityRegistry().getAllQNames();
    }

    public BpelEntity createComponent(BpelEntity bpelEntity, Element element) {
        if (!(bpelEntity instanceof BpelContainer)) {
            return null;
        }
        return this.getChildBuilder().create(element, (BpelContainer)bpelEntity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BpelEntity findElement(int n) {
        this.readLock();
        try {
            DocumentComponent documentComponent = this.findComponent(n);
            assert (documentComponent == null || documentComponent instanceof BpelEntity);
            BpelEntity bpelEntity = (BpelEntity)documentComponent;
            return bpelEntity;
        }
        finally {
            this.readUnlock();
        }
    }

    public boolean isIntransaction() {
        return this.myLock.getWriteHoldCount() > 0;
    }

    public boolean startTransaction() {
        this.writeLock(true, false);
        this.isXamTransaction = true;
        return super.startTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endTransaction() {
        try {
            super.endTransaction();
        }
        finally {
            if (this.isXamTransaction) {
                this.isXamTransaction = false;
                this.writeUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollbackTransaction() {
        try {
            this.myUndoSupport.abortUpdate();
            this.finishTransaction();
        }
        finally {
            if (this.isXamTransaction) {
                this.isXamTransaction = false;
                this.writeUnlock();
            }
        }
    }

    @Override
    public boolean isSupportedExpension(String string) {
        Collection<EntityFactory> collection = this.getEntityRegistry().getFactories();
        for (EntityFactory entityFactory : collection) {
            if (!entityFactory.isApplicable(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public AnotherVersionBpelProcess getAnotherVersionProcess() {
        if (this.getState() == Model.State.VALID) {
            return null;
        }
        Element element = null;
        if (this.getProcess() == null) {
            org.w3c.dom.Document document = this.getDocument();
            if (document == null) {
                return null;
            }
            element = document.getDocumentElement();
            if (element == null) {
                return null;
            }
        } else {
            if (this.myAnotherRoot == null) {
                return null;
            }
            element = this.myAnotherRoot;
        }
        return new AnotherVersionBpelProcessImpl(this, element);
    }

    @Override
    public boolean canExtend(ExtensibleElements extensibleElements, Class<? extends ExtensionEntity> clazz) {
        Collection<EntityFactory> collection = this.getEntityRegistry().getFactories();
        for (EntityFactory entityFactory : collection) {
            if (!entityFactory.canExtend(extensibleElements, clazz)) continue;
            return true;
        }
        return false;
    }

    protected ComponentUpdater<BpelEntity> getComponentUpdater() {
        if (this.mySyncUpdateVisitor == null) {
            this.mySyncUpdateVisitor = new SyncUpdateVisitor();
        }
        return this.mySyncUpdateVisitor;
    }

    protected void readLock() {
        this.readLock.lock();
    }

    protected void readUnlock() {
        this.readLock.unlock();
    }

    protected void writeLock() {
        this.writeLock(false, false);
    }

    protected void writeUnlock() {
        this.writeUnlock(false);
    }

    protected Object getSource() {
        assert (this.myTransaction != null);
        return this.myTransaction.getSource();
    }

    EntityFactoryRegistry getEntityRegistry() {
        return EntityFactoryRegistry.getInstance();
    }

    long getNextID() {
        return this.myNextID.incrementAndGet();
    }

    final boolean isInEventsFiring() {
        if (this.myTransaction == null) {
            return false;
        }
        return this.myTransaction.isCommit;
    }

    final void preInnerEventNotify(ChangeEvent changeEvent) throws VetoException {
        InnerEventDispatcher[] innerEventDispatcherArray = this.getInnerDispatchers();
        int n = 0;
        try {
            for (InnerEventDispatcher innerEventDispatcher : innerEventDispatcherArray) {
                if (!innerEventDispatcher.isApplicable(changeEvent)) continue;
                innerEventDispatcher.preDispatch(changeEvent);
                ++n;
            }
        }
        catch (VetoException vetoException) {
            int n2 = 0;
            for (InnerEventDispatcher innerEventDispatcher : innerEventDispatcherArray) {
                if (n2 > n) break;
                if (!innerEventDispatcher.isApplicable(changeEvent)) continue;
                innerEventDispatcher.reset(changeEvent);
                ++n2;
            }
            throw vetoException;
        }
    }

    final void postInnerEventNotify(ChangeEvent changeEvent) {
        InnerEventDispatcher[] innerEventDispatcherArray;
        for (InnerEventDispatcher innerEventDispatcher : innerEventDispatcherArray = this.getInnerDispatchers()) {
            if (!innerEventDispatcher.isApplicable(changeEvent)) continue;
            innerEventDispatcher.postDispatch(changeEvent);
        }
    }

    final void fireChangeEvent(ChangeEvent changeEvent) {
        this.myTransaction.add(changeEvent);
    }

    BpelChildEntitiesBuilder getChildBuilder() {
        return this.myChildBuilder;
    }

    private void writeLock(boolean bl, boolean bl2) {
        this.writeLock.lock();
        if (this.myReadLockObtained.get() != null && this.myReadLockObtained.get().booleanValue()) {
            throw new IllegalStateException("You are trying to mutate OM while read lock is obtianed.");
        }
        if (!this.inSync() && !bl && this.getState().equals((Object)Model.State.NOT_WELL_FORMED)) {
            throw new IllegalStateException("Xml file is broken. One cannot mutate model in broken state.");
        }
        if (bl2 && this.myLock.getWriteHoldCount() == 1) {
            this.getAccess().addMergeEventHandler((PropertyChangeListener)this.myXDMListener);
        }
        if (this.myTransaction == null) {
            this.myTransaction = new Transaction();
        }
        this.myTransaction.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeUnlock(boolean bl) {
        try {
            assert (this.myTransaction != null);
            if (bl && this.myLock.getWriteHoldCount() == 1) {
                this.getAccess().removeMergeEventHandler((PropertyChangeListener)this.myXDMListener);
                this.setInSync(true);
            }
            this.myTransaction.end();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private static ModelSource getOrCreateModelSource(Document document, Lookup lookup) {
        Lookup lookup2 = Lookups.fixed((Object[])new Object[]{document});
        return new ModelSource(lookup2, true);
    }

    private void init() {
        this.mySupport = new ChangeEventSupport();
        this.myUndoSupport = new BpelModelUndoableEditSupport();
        this.myPropertyChangeSupport = new PropertyChangeSupport(this);
        this.myComponentListeners = new EventListenerList();
        this.myXDMListener = new XDMListener();
        this.myChildBuilder = new BpelChildEntitiesBuilder(this);
        this.getAccess().setAutoSync(true);
    }

    private void postTreeCreated(Process process, Process process2) {
        TreeCreatedEvent<Process> treeCreatedEvent = new TreeCreatedEvent<Process>(process2);
        if (process != process2) {
            this.postInnerEventNotify(treeCreatedEvent);
        }
    }

    private void preTreeCreated(Process process) {
        block3: {
            TreeCreatedEvent<Process> treeCreatedEvent = new TreeCreatedEvent<Process>(process);
            try {
                if (process == null) {
                    this.preInnerEventNotify(treeCreatedEvent);
                }
            }
            catch (VetoException vetoException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    private InnerEventDispatcher[] getInnerDispatchers() {
        if (this.myDispatchers == null) {
            if (null == this.innerDispatcherResult) {
                this.innerDispatcherResult = Lookup.getDefault().lookup(new Lookup.Template(InnerEventDispatcher.class));
            }
            this.myDispatchers = this.innerDispatcherResult.allInstances().toArray(new InnerEventDispatcher[this.innerDispatcherResult.allInstances().size()]);
        }
        return this.myDispatchers;
    }

    private class XDMListener
    implements PropertyChangeListener {
        private XDMListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Node node;
            Node node2;
            Node node3 = BpelModelImpl.this.getAccess().getOldEventNode(propertyChangeEvent);
            Node node4 = BpelModelImpl.this.getAccess().getNewEventNode(propertyChangeEvent);
            Node node5 = node2 = node3 == null ? node4 : node3;
            if (node2 == null) {
                return;
            }
            Node node6 = node = node3 == null ? BpelModelImpl.this.getAccess().getNewEventParentNode(propertyChangeEvent) : BpelModelImpl.this.getAccess().getOldEventParentNode(propertyChangeEvent);
            if (node2.getNodeType() == 2) {
                assert (BpelModelImpl.this.myTransaction != null);
                BpelModelImpl.this.myTransaction.addAttributeChange(node, node3, node4);
            }
            if (node2 instanceof Text) {
                this.handleChangeInText(node3, node4, node);
            }
        }

        private void handleChangeInText(Node node, Node node2, Node node3) {
            DocumentComponent documentComponent;
            if (node3 instanceof Element && (documentComponent = BpelModelImpl.this.findComponent(BpelModelImpl.this.getAccess().getPathFromRoot(BpelModelImpl.this.getDocument(), (Element)node3))) instanceof ContentElement) {
                String string = null;
                String string2 = null;
                if (node != null) {
                    string = node.getNodeValue();
                }
                if (node2 != null) {
                    string2 = node2.getNodeValue();
                }
                PropertyUpdateEvent propertyUpdateEvent = new PropertyUpdateEvent(BpelModelImpl.this.getSource(), (BpelEntity)documentComponent, "<content>", string, string2);
                assert (BpelModelImpl.this.myTransaction != null);
                BpelModelImpl.this.myTransaction.add(propertyUpdateEvent);
            }
        }
    }

    private final class Transaction {
        private Queue<ChangeEvent> myFullTransactionEventSet;
        private boolean isCommit;
        private Object mySource;
        private List<Node> myParents = new ArrayList<Node>();
        private List<Node> myOldAttrs = new ArrayList<Node>();
        private List<Node> myNewAttrs = new ArrayList<Node>();

        private Transaction() {
            this.myFullTransactionEventSet = new LinkedList<ChangeEvent>();
        }

        void start() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void end() {
            if (BpelModelImpl.this.myLock.getWriteHoldCount() == 1) {
                try {
                    this.commitEvents();
                    if (!BpelModelImpl.this.inUndoRedo() && BpelModelImpl.this.myUndoSupport.editInProgress()) {
                        BpelModelImpl.this.myUndoSupport.endUpdate();
                    }
                }
                finally {
                    if (BpelModelImpl.this.inSync()) {
                        BpelModelImpl.this.setInUndoRedo(false);
                        BpelModelImpl.this.setInSync(false);
                    }
                    this.setSource(null);
                    this.cleanEvents();
                    this.cleanAttributeChanges();
                }
            }
        }

        private void cleanEvents() {
            this.myFullTransactionEventSet.clear();
        }

        void add(ChangeEvent changeEvent) {
            assert (BpelModelImpl.this.myLock.getWriteHoldCount() > 0);
            if (this.isCommit) {
                throw new IllegalStateException("Model should not be changed inside event listener.");
            }
            this.myFullTransactionEventSet.offer(changeEvent);
        }

        Object getSource() {
            if (this.mySource == null) {
                return Thread.currentThread();
            }
            return this.mySource;
        }

        void setSource(Object object) {
            this.mySource = object;
        }

        void addAttributeChange(Node node, Node node2, Node node3) {
            this.myParents.add(node);
            this.myOldAttrs.add(node2);
            this.myNewAttrs.add(node3);
        }

        int remove(Node node) {
            assert (node instanceof Node);
            int n = 0;
            int n2 = -1;
            for (Node node2 : this.myParents) {
                if (BpelModelImpl.this.areSameNodes(node2, node)) {
                    n2 = n;
                }
                ++n;
            }
            if (n2 >= 0) {
                this.myParents.remove(n2);
            }
            return n2;
        }

        Node removeOldAttribute(int n) {
            return this.myOldAttrs.remove(n);
        }

        Node removeNewAttribute(int n) {
            return this.myNewAttrs.remove(n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void commitEvents() {
            this.isCommit = true;
            try {
                ChangeEvent changeEvent;
                boolean bl = false;
                while ((changeEvent = this.myFullTransactionEventSet.poll()) != null) {
                    if (this.myFullTransactionEventSet.size() > 0) {
                        changeEvent.setNotLast();
                    } else {
                        bl = true;
                        changeEvent.setLast();
                    }
                    BpelModelImpl.this.mySupport.fireChangeEvent(changeEvent);
                }
                if (!BpelModelImpl.this.inSync() && bl) {
                    BpelModelImpl.this.getAccess().flush();
                }
            }
            finally {
                this.isCommit = false;
            }
        }

        private void cleanAttributeChanges() {
            if (!BpelModelImpl.this.inSync()) {
                return;
            }
            this.myParents.clear();
            this.myOldAttrs.clear();
            this.myNewAttrs.clear();
        }
    }

    protected class BpelModelUndoableEdit
    extends AbstractModel.ModelUndoableEdit {
        private static final long serialVersionUID = 3771336438002454367L;

        protected BpelModelUndoableEdit() {
            super((AbstractModel)BpelModelImpl.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void redo() {
            BpelModelImpl.this.writeLock(true, true);
            try {
                super.redo();
                BpelModelImpl.this.setInUndoRedo(true);
            }
            finally {
                BpelModelImpl.this.writeUnlock(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void undo() {
            BpelModelImpl.this.writeLock(true, true);
            try {
                super.undo();
                BpelModelImpl.this.setInUndoRedo(true);
            }
            finally {
                BpelModelImpl.this.writeUnlock(true);
            }
        }
    }

    protected class BpelModelUndoableEditSupport
    extends UndoableEditSupport {
        private boolean inProgress;

        protected BpelModelUndoableEditSupport() {
        }

        public synchronized void beginUpdate() {
            super.beginUpdate();
            this.inProgress = true;
        }

        public synchronized void endUpdate() {
            this.inProgress = false;
            super.endUpdate();
        }

        protected CompoundEdit createCompoundEdit() {
            return new BpelModelUndoableEdit();
        }

        protected boolean editInProgress() {
            return this.inProgress;
        }

        protected void abortUpdate() {
            AbstractModel.ModelUndoableEdit modelUndoableEdit = (AbstractModel.ModelUndoableEdit)this.compoundEdit;
            modelUndoableEdit.justUndo();
            this.compoundEdit = this.createCompoundEdit();
        }
    }
}

