/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.project.jsf.ui;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.visualweb.project.jsf.api.JsfProjectUtils;
import org.netbeans.modules.visualweb.project.jsf.ui.PagebeanPackagePanelGUI;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class PagebeanPackagePanel
implements WizardDescriptor.Panel,
ChangeListener {
    private final List listeners = new ArrayList();
    private PagebeanPackagePanelGUI gui;
    private Project project;
    private WizardDescriptor wizard;

    PagebeanPackagePanel(Project project) {
        this.project = project;
        this.gui = null;
    }

    public Component getComponent() {
        if (this.gui == null) {
            this.gui = new PagebeanPackagePanelGUI(this.project);
            this.gui.addChangeListener(this);
        }
        return this.gui;
    }

    public HelpCtx getHelp() {
        return null;
    }

    public boolean isValid() {
        if (this.gui == null) {
            return false;
        }
        String string = this.gui.getPackageName();
        if (!JsfProjectUtils.isValidJavaPackageName(string)) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PagebeanPackagePanel.class, (String)"MSG_InvalidPackageName", (Object)string));
            return false;
        }
        return true;
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ArrayList arrayList;
        ChangeEvent changeEvent = new ChangeEvent(this);
        Object object = this;
        synchronized (object) {
            arrayList = new ArrayList(this.listeners);
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            ((ChangeListener)object.next()).stateChanged(changeEvent);
        }
    }

    public void readSettings(Object object) {
        this.wizard = (WizardDescriptor)object;
        if (this.gui == null) {
            this.getComponent();
        }
        this.gui.initValues(this.project);
    }

    public void storeSettings(Object object) {
        if (WizardDescriptor.PREVIOUS_OPTION.equals(((WizardDescriptor)object).getValue())) {
            return;
        }
        if (this.isValid()) {
            ((WizardDescriptor)object).putProperty("jsf.pagebean.package", (Object)this.gui.getPackageName());
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.wizard != null && this.isValid()) {
            this.wizard.putProperty("jsf.pagebean.package", (Object)this.gui.getPackageName());
        }
        this.fireChange();
    }
}

