/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.project.jsf.libraries.provider;

import java.beans.Customizer;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.visualweb.project.jsf.libraries.provider.ThemeVolumeCustomizer;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryTypeProvider;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class ThemeLibraryTypeProvider
implements LibraryTypeProvider {
    private static final String LIB_PREFIX = "libs.";
    public static final String LIBRARY_TYPE = "theme";
    public static final String VOLUME_TYPE_CLASSPATH = "classpath";
    public static final String VOLUME_TYPE_SRC = "src";
    public static final String VOLUME_TYPE_JAVADOC = "javadoc";
    public static final String VOLUME_TYPE_RUNTIME = "runtime";
    public static final String[] VOLUME_TYPES = new String[]{"classpath", "src", "javadoc", "runtime"};

    private ThemeLibraryTypeProvider() {
    }

    public String getLibraryType() {
        return LIBRARY_TYPE;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(ThemeLibraryTypeProvider.class, (String)"TXT_ThemeLibraryType");
    }

    public String[] getSupportedVolumeTypes() {
        return VOLUME_TYPES;
    }

    public LibraryImplementation createLibrary() {
        return LibrariesSupport.createLibraryImplementation((String)LIBRARY_TYPE, (String[])VOLUME_TYPES);
    }

    public void libraryCreated(final LibraryImplementation libraryImplementation) {
        assert (libraryImplementation != null);
        ProjectManager.mutex().postWriteRequest(new Runnable(){

            public void run() {
                try {
                    EditableProperties editableProperties = PropertyUtils.getGlobalProperties();
                    boolean bl = ThemeLibraryTypeProvider.addLibraryIntoBuild(libraryImplementation, editableProperties);
                    if (bl) {
                        PropertyUtils.putGlobalProperties((EditableProperties)editableProperties);
                    }
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        });
    }

    public void libraryDeleted(final LibraryImplementation libraryImplementation) {
        assert (libraryImplementation != null);
        ProjectManager.mutex().postWriteRequest(new Runnable(){

            public void run() {
                try {
                    EditableProperties editableProperties = PropertyUtils.getGlobalProperties();
                    for (int i = 0; i < VOLUME_TYPES.length; ++i) {
                        String string = ThemeLibraryTypeProvider.LIB_PREFIX + libraryImplementation.getName() + '.' + VOLUME_TYPES[i];
                        editableProperties.remove((Object)string);
                    }
                    PropertyUtils.putGlobalProperties((EditableProperties)editableProperties);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        });
    }

    public Customizer getCustomizer(String string) {
        if (VOLUME_TYPES[0].equals(string) || VOLUME_TYPES[1].equals(string) || VOLUME_TYPES[2].equals(string) || VOLUME_TYPES[3].equals(string)) {
            return new ThemeVolumeCustomizer(string);
        }
        return null;
    }

    public Lookup getLookup() {
        return Lookup.EMPTY;
    }

    public static LibraryTypeProvider create() {
        return new ThemeLibraryTypeProvider();
    }

    private static boolean addLibraryIntoBuild(LibraryImplementation libraryImplementation, EditableProperties editableProperties) {
        boolean bl = false;
        for (int i = 0; i < VOLUME_TYPES.length; ++i) {
            Object object2;
            String string = LIB_PREFIX + libraryImplementation.getName() + '.' + VOLUME_TYPES[i];
            List list = libraryImplementation.getContent(VOLUME_TYPES[i]);
            if (list == null) continue;
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl2 = true;
            for (Object object2 : list) {
                URI uRI;
                if ("jar".equals(((URL)object2).getProtocol())) {
                    object2 = FileUtil.getArchiveFile((URL)object2);
                }
                File file = null;
                FileObject fileObject = URLMapper.findFileObject((URL)object2);
                if (fileObject != null) {
                    file = FileUtil.toFile((FileObject)fileObject);
                } else if ("file".equals(((URL)object2).getProtocol()) && (uRI = URI.create(((URL)object2).toExternalForm())) != null) {
                    file = new File(uRI);
                }
                if (file != null) {
                    if (!bl2) {
                        stringBuffer.append(File.pathSeparatorChar);
                    }
                    bl2 = false;
                    file = FileUtil.normalizeFile((File)file);
                    stringBuffer.append(file.getAbsolutePath());
                    continue;
                }
                ErrorManager.getDefault().log("J2SELibraryTypeProvider: Can not resolve URL: " + object2);
            }
            String string2 = editableProperties.getProperty(string);
            object2 = stringBuffer.toString();
            if (((String)object2).equals(string2)) continue;
            if (((String)object2).length() > 0) {
                editableProperties.setProperty(string, (String)object2);
                bl = true;
                continue;
            }
            if (string2 == null) continue;
            editableProperties.remove((Object)string);
            bl = true;
        }
        return bl;
    }
}

