/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.runprofiles.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.Env;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.RunProfile;
import org.netbeans.modules.cnd.makeproject.runprofiles.ui.ListTableModel;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class EnvPanel
extends JPanel
implements HelpCtx.Provider,
PropertyChangeListener,
ListSelectionListener {
    private RunProfile currentProfile;
    private ListTableModel envvarModel = null;
    private JTable envvarTable = null;
    private Env env;
    private PropertyEditorSupport editor;
    private JButton addButton;
    private JPanel buttonPanel;
    private JLabel environmentLabel;
    private JPanel environmentPanel;
    private JScrollPane envvarScrollPane;
    private JButton removeButton;
    private ResourceBundle bundle;

    public EnvPanel(Env env, PropertyEditorSupport propertyEditorSupport, PropertyEnv propertyEnv) {
        this.initComponents();
        this.env = env;
        this.editor = propertyEditorSupport;
        this.envvarScrollPane.getViewport().setBackground(Color.WHITE);
        this.envvarModel = new ListTableModel(this.getString("EnvName"), this.getString("EnvValue"));
        this.envvarTable = new JTable(this.envvarModel);
        this.envvarModel.setTable(this.envvarTable);
        this.envvarScrollPane.setViewportView(this.envvarTable);
        this.initValues(env);
        propertyEnv.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
        propertyEnv.addPropertyChangeListener((PropertyChangeListener)this);
        this.environmentLabel.setLabelFor(this.envvarTable);
        this.envvarTable.getAccessibleContext().setAccessibleDescription(this.getString("ACSD_ENV_VAR_TABLE"));
        this.addButton.getAccessibleContext().setAccessibleDescription(this.getString("ACSD_ADD_BUTTON"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(this.getString("ACSD_REMOVE_BUTTON"));
        this.envvarTable.getSelectionModel().addListSelectionListener(this);
        this.validateButtons();
    }

    private void validateButtons() {
        int[] nArray = this.envvarTable.getSelectedRows();
        this.removeButton.setEnabled(this.envvarModel.getRowCount() > 0 && nArray != null && nArray.length > 0);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.validateButtons();
    }

    public void initValues(Env env) {
        String[][] stringArray = env.getenvAsPairs();
        if (stringArray != null) {
            int n = stringArray.length;
            ArrayList<String> arrayList = new ArrayList<String>(n + 3);
            ArrayList<String> arrayList2 = new ArrayList<String>(n + 3);
            for (int i = 0; i < n; ++i) {
                arrayList.add(stringArray[i][0]);
                arrayList2.add(stringArray[i][1]);
            }
            this.envvarModel.setData(n, arrayList, arrayList2);
        }
        this.initFocus();
    }

    public void initFocus() {
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("Environment");
    }

    private void initComponents() {
        this.environmentPanel = new JPanel();
        this.environmentLabel = new JLabel();
        this.envvarScrollPane = new JScrollPane();
        this.buttonPanel = new JPanel();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEtchedBorder());
        this.environmentPanel.setLayout(new GridBagLayout());
        this.environmentLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/runprofiles/ui/Bundle").getString("ENVIRONMENT_MNE").charAt(0));
        this.environmentLabel.setLabelFor(this.envvarScrollPane);
        this.environmentLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/runprofiles/ui/Bundle").getString("ENVIRONMENT_LBL"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.environmentPanel.add((Component)this.environmentLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.environmentPanel.add((Component)this.envvarScrollPane, gridBagConstraints);
        this.buttonPanel.setLayout(new GridBagLayout());
        this.addButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/runprofiles/ui/Bundle").getString("ADD_BUTTON_MNE").charAt(0));
        this.addButton.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/runprofiles/ui/Bundle").getString("ADD_BUTTON"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EnvPanel.this.addButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.buttonPanel.add((Component)this.addButton, gridBagConstraints);
        this.removeButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/runprofiles/ui/Bundle").getString("REMOVE_BUTTON_MNE").charAt(0));
        this.removeButton.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/runprofiles/ui/Bundle").getString("REMOVE_BUTTON"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EnvPanel.this.removeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.buttonPanel.add((Component)this.removeButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 0, 0);
        this.environmentPanel.add((Component)this.buttonPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 12, 0, 12);
        this.add((Component)this.environmentPanel, gridBagConstraints);
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.envvarTable.getSelectedRows();
        if (nArray != null && nArray.length > 0) {
            this.envvarModel.removeRows(nArray);
        }
        this.validateButtons();
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        this.envvarModel.addRow();
        this.validateButtons();
    }

    private Object getPropertyValue() throws IllegalStateException {
        this.env.removeAll();
        int n = this.envvarModel.getRowCount();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                String string = ((String)this.envvarModel.getValueAt(i, 0)).trim();
                if (string.length() == 0) continue;
                String string2 = ((String)this.envvarModel.getValueAt(i, 1)).trim();
                this.env.putenv(string, string2);
            }
        }
        return this.env;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("state".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getNewValue() == PropertyEnv.STATE_VALID) {
            this.editor.setValue(this.getPropertyValue());
        }
    }

    private String getString(String string) {
        if (this.bundle == null) {
            this.bundle = NbBundle.getBundle(EnvPanel.class);
        }
        return this.bundle.getString(string);
    }
}

