/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.packaging;

import java.io.BufferedWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.makeproject.MakeOptions;
import org.netbeans.modules.cnd.makeproject.api.PackagerDescriptor;
import org.netbeans.modules.cnd.makeproject.api.PackagerFileElement;
import org.netbeans.modules.cnd.makeproject.api.PackagerInfoElement;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.PackagingConfiguration;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVR4Packager
implements PackagerDescriptor {
    public static String PACKAGER_NAME = "SVR4";

    @Override
    public String getName() {
        return PACKAGER_NAME;
    }

    @Override
    public String getDisplayName() {
        return SVR4Packager.getString("SCR4Package");
    }

    @Override
    public boolean hasInfoList() {
        return true;
    }

    @Override
    public List<PackagerInfoElement> getDefaultInfoList(MakeConfiguration makeConfiguration, PackagingConfiguration packagingConfiguration) {
        String string = makeConfiguration.getPlatform().getValue() == 1 ? "i386" : (makeConfiguration.getPlatform().getValue() == 0 ? "sparc" : "i386");
        ArrayList<PackagerInfoElement> arrayList = new ArrayList<PackagerInfoElement>();
        arrayList.add(new PackagerInfoElement(PACKAGER_NAME, "PKG", packagingConfiguration.getOutputName(), true, true));
        arrayList.add(new PackagerInfoElement(PACKAGER_NAME, "NAME", "Package description ...", true, true));
        arrayList.add(new PackagerInfoElement(PACKAGER_NAME, "ARCH", string, true, true));
        arrayList.add(new PackagerInfoElement(PACKAGER_NAME, "CATEGORY", "application", true, true));
        arrayList.add(new PackagerInfoElement(PACKAGER_NAME, "VERSION", "1.0", true, true));
        arrayList.add(new PackagerInfoElement(PACKAGER_NAME, "BASEDIR", "/opt", false, true));
        arrayList.add(new PackagerInfoElement(PACKAGER_NAME, "PSTAMP", new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()), false, true));
        arrayList.add(new PackagerInfoElement(PACKAGER_NAME, "CLASSES", "none", false, true));
        return arrayList;
    }

    @Override
    public List<String> getOptionalInfoList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("BASEDIR");
        arrayList.add("CLASSES");
        arrayList.add("DESC");
        arrayList.add("EMAIL");
        arrayList.add("HOTLINE");
        arrayList.add("INTONLY");
        arrayList.add("ISTATES");
        arrayList.add("MAXINST");
        arrayList.add("ORDER");
        arrayList.add("PSTAMP");
        arrayList.add("RSTATES");
        arrayList.add("SUNW_ISA");
        arrayList.add("SUNW_LOC");
        arrayList.add("SUNW_PKG_DIR");
        arrayList.add("SUNW_PKG_ALLZONES");
        arrayList.add("SUNW_PKG_HOLLOW");
        arrayList.add("SUNW_PKG_THISZONE");
        arrayList.add("SUNW_PKGLIST");
        arrayList.add("SUNW_PKGTYPE");
        arrayList.add("SUNW_PKGVERS");
        arrayList.add("SUNW_PRODNAME");
        arrayList.add("SUNW_PRODVERS");
        arrayList.add("ULIMIT");
        arrayList.add("VENDOR");
        arrayList.add("VSTOCK");
        return arrayList;
    }

    @Override
    public String getDefaultOptions() {
        return "";
    }

    @Override
    public String getDefaultTool() {
        return "pkgmk";
    }

    @Override
    public boolean isOutputAFolder() {
        return true;
    }

    @Override
    public String getOutputFileName(MakeConfiguration makeConfiguration, PackagingConfiguration packagingConfiguration) {
        return null;
    }

    @Override
    public String getOutputFileSuffix() {
        return null;
    }

    @Override
    public String getTopDir(MakeConfiguration makeConfiguration, PackagingConfiguration packagingConfiguration) {
        return packagingConfiguration.findInfoValueName("PKG");
    }

    @Override
    public boolean supportsGroupAndOwner() {
        return true;
    }

    @Override
    public PackagerDescriptor.ShellSciptWriter getShellFileWriter() {
        return new ScriptWriter();
    }

    private static String getString(String string) {
        return NbBundle.getMessage(PackagingConfiguration.class, (String)string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ScriptWriter
    implements PackagerDescriptor.ShellSciptWriter {
        @Override
        public void writeShellScript(BufferedWriter bufferedWriter, MakeConfiguration makeConfiguration, PackagingConfiguration packagingConfiguration) throws IOException {
            this.writePackagingScriptBodySVR4(bufferedWriter, makeConfiguration);
        }

        private List<String> findUndefinedDirectories(PackagingConfiguration packagingConfiguration) {
            String string;
            List list = packagingConfiguration.getFiles().getValue();
            HashSet<String> hashSet = new HashSet<String>();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (PackagerFileElement packagerFileElement : list) {
                if (packagerFileElement.getType() != PackagerFileElement.FileType.DIRECTORY) continue;
                string = packagingConfiguration.expandMacros(packagerFileElement.getTo());
                if (string.endsWith("/")) {
                    string = string.substring(0, string.length() - 1);
                }
                hashSet.add(string);
            }
            for (PackagerFileElement packagerFileElement : list) {
                if (packagerFileElement.getType() != PackagerFileElement.FileType.FILE && packagerFileElement.getType() != PackagerFileElement.FileType.SOFTLINK) continue;
                string = IpeUtils.getDirName((String)packagingConfiguration.expandMacros(packagerFileElement.getTo()));
                String string2 = "";
                if (string == null || string.length() <= 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
                while (stringTokenizer.hasMoreTokens()) {
                    if (string2.length() > 0) {
                        string2 = string2 + "/";
                    }
                    if (hashSet.contains(string2 = string2 + stringTokenizer.nextToken())) continue;
                    hashSet.add(string2);
                    arrayList.add(string2);
                }
            }
            return arrayList;
        }

        private void writePackagingScriptBodySVR4(BufferedWriter bufferedWriter, MakeConfiguration makeConfiguration) throws IOException {
            PackagingConfiguration packagingConfiguration = makeConfiguration.getPackagingConfiguration();
            String string = packagingConfiguration.findInfoValueName("PKG");
            bufferedWriter.write("# Create pkginfo and prototype files\n");
            bufferedWriter.write("PKGINFOFILE=${TMPDIR}/pkginfo\n");
            bufferedWriter.write("PROTOTYPEFILE=${TMPDIR}/prototype\n");
            bufferedWriter.write("rm -f $PKGINFOFILE $PROTOTYPEFILE\n");
            bufferedWriter.write("\n");
            bufferedWriter.write("cd \"${TOP}\"\n");
            List<PackagerInfoElement> list = packagingConfiguration.getHeaderSubList(PACKAGER_NAME);
            for (PackagerInfoElement object22 : list) {
                bufferedWriter.write("echo '" + object22.getName() + "=\"" + packagingConfiguration.expandMacros(object22.getValue()) + "\"'" + " >> $PKGINFOFILE\n");
            }
            bufferedWriter.write("\n");
            bufferedWriter.write("cd \"${TOP}\"\n");
            bufferedWriter.write("echo \"i pkginfo=pkginfo\" >> $PROTOTYPEFILE\n");
            bufferedWriter.write("\n");
            List<String> list2 = this.findUndefinedDirectories(packagingConfiguration);
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                bufferedWriter.write("echo \"");
                bufferedWriter.write("d");
                bufferedWriter.write(" none");
                bufferedWriter.write(" " + (String)string2);
                bufferedWriter.write(" 0" + MakeOptions.getInstance().getDefExePerm());
                bufferedWriter.write(" " + MakeOptions.getInstance().getDefOwner());
                bufferedWriter.write(" " + MakeOptions.getInstance().getDefGroup());
                bufferedWriter.write("\"");
                bufferedWriter.write(" >> $PROTOTYPEFILE\n");
            }
            bufferedWriter.write("\n");
            List list3 = packagingConfiguration.getFiles().getValue();
            for (PackagerFileElement packagerFileElement : list3) {
                bufferedWriter.write("echo \"");
                if (packagerFileElement.getType() == PackagerFileElement.FileType.DIRECTORY) {
                    bufferedWriter.write("d");
                } else if (packagerFileElement.getType() == PackagerFileElement.FileType.FILE) {
                    bufferedWriter.write("f");
                } else if (packagerFileElement.getType() == PackagerFileElement.FileType.SOFTLINK) {
                    bufferedWriter.write("s");
                } else assert (false);
                bufferedWriter.write(" none");
                bufferedWriter.write(" " + packagerFileElement.getTo());
                if (packagerFileElement.getFrom().length() > 0) {
                    String string3 = packagerFileElement.getFrom();
                    if (IpeUtils.isPathAbsolute((String)string3)) {
                        string3 = IpeUtils.toRelativePath((String)makeConfiguration.getBaseDir(), (String)string3);
                    }
                    bufferedWriter.write("=" + string3);
                }
                if (packagerFileElement.getType() != PackagerFileElement.FileType.SOFTLINK) {
                    bufferedWriter.write(" 0" + packagerFileElement.getPermission());
                    bufferedWriter.write(" " + packagerFileElement.getOwner());
                    bufferedWriter.write(" " + packagerFileElement.getGroup());
                }
                bufferedWriter.write("\"");
                bufferedWriter.write(" >> $PROTOTYPEFILE\n");
            }
            bufferedWriter.write("\n");
            bufferedWriter.write("# Make package\n");
            bufferedWriter.write("cd \"${TOP}\"\n");
            bufferedWriter.write(packagingConfiguration.getToolValue() + " " + packagingConfiguration.getOptionsValue() + " -o -f $PROTOTYPEFILE -r . -d $TMPDIR\n");
            bufferedWriter.write("checkReturnCode\n");
            bufferedWriter.write("rm -rf " + packagingConfiguration.getOutputValue() + "/" + string + "\n");
            bufferedWriter.write("mv ${TMPDIR}/" + string + " " + packagingConfiguration.getOutputValue() + "\n");
            bufferedWriter.write("checkReturnCode\n");
            bufferedWriter.write("echo Solaris SVR4: " + packagingConfiguration.getOutputValue() + "/" + string + "\n");
            bufferedWriter.write("\n");
        }
    }
}

