/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.packaging;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.makeproject.api.PackagerDescriptor;
import org.netbeans.modules.cnd.makeproject.api.PackagerFileElement;
import org.netbeans.modules.cnd.makeproject.api.PackagerInfoElement;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.PackagingConfiguration;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RPMPackager
implements PackagerDescriptor {
    public static String PACKAGER_NAME = "RPM";

    @Override
    public String getName() {
        return PACKAGER_NAME;
    }

    @Override
    public String getDisplayName() {
        return RPMPackager.getString("RPM");
    }

    @Override
    public boolean hasInfoList() {
        return true;
    }

    @Override
    public List<PackagerInfoElement> getDefaultInfoList(MakeConfiguration makeConfiguration, PackagingConfiguration packagingConfiguration) {
        ArrayList<PackagerInfoElement> arrayList = new ArrayList<PackagerInfoElement>();
        arrayList.add(new PackagerInfoElement(PACKAGER_NAME, "Summary", "Sumary...", true, true));
        arrayList.add(new PackagerInfoElement(PACKAGER_NAME, "Name", packagingConfiguration.getOutputName(), true, true));
        arrayList.add(new PackagerInfoElement(PACKAGER_NAME, "Version", "1.0", true, true));
        arrayList.add(new PackagerInfoElement(PACKAGER_NAME, "Release", "1", true, true));
        arrayList.add(new PackagerInfoElement(PACKAGER_NAME, "Group", "Applications/System", true, true));
        arrayList.add(new PackagerInfoElement(PACKAGER_NAME, "License", "BSD-type", true, true));
        arrayList.add(new PackagerInfoElement(PACKAGER_NAME, "%description", "Description...", true, true));
        return arrayList;
    }

    @Override
    public List<String> getOptionalInfoList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Patch");
        arrayList.add("%changelog");
        arrayList.add("%pre");
        arrayList.add("%post");
        arrayList.add("%preun");
        arrayList.add("%postun");
        return arrayList;
    }

    @Override
    public String getDefaultOptions() {
        return "";
    }

    @Override
    public String getDefaultTool() {
        return "rpmbuild";
    }

    @Override
    public boolean isOutputAFolder() {
        return true;
    }

    @Override
    public String getOutputFileName(MakeConfiguration makeConfiguration, PackagingConfiguration packagingConfiguration) {
        return null;
    }

    @Override
    public String getOutputFileSuffix() {
        return null;
    }

    @Override
    public String getTopDir(MakeConfiguration makeConfiguration, PackagingConfiguration packagingConfiguration) {
        return "/usr";
    }

    @Override
    public boolean supportsGroupAndOwner() {
        return true;
    }

    @Override
    public PackagerDescriptor.ShellSciptWriter getShellFileWriter() {
        return new ScriptWriter();
    }

    private static String getString(String string) {
        return NbBundle.getMessage(PackagingConfiguration.class, (String)string);
    }

    public class ScriptWriter
    implements PackagerDescriptor.ShellSciptWriter {
        public void writeShellScript(BufferedWriter bufferedWriter, MakeConfiguration makeConfiguration, PackagingConfiguration packagingConfiguration) throws IOException {
            this.writePackagingScriptBodyRPM(bufferedWriter, makeConfiguration);
        }

        private void writePackagingScriptBodyRPM(BufferedWriter bufferedWriter, MakeConfiguration makeConfiguration) throws IOException {
            String string;
            Object object2;
            Iterator iterator2;
            PackagingConfiguration packagingConfiguration = makeConfiguration.getPackagingConfiguration();
            List list = packagingConfiguration.getFiles().getValue();
            String string2 = packagingConfiguration.getOutputValue();
            bufferedWriter.write("# Copy files and create directories and links\n");
            for (Iterator iterator2 : list) {
                bufferedWriter.write("cd \"${TOP}\"\n");
                if (((PackagerFileElement)((Object)iterator2)).getType() == PackagerFileElement.FileType.FILE) {
                    object2 = IpeUtils.getDirName((String)makeConfiguration.getPackagingConfiguration().expandMacros(((PackagerFileElement)((Object)iterator2)).getTo()));
                    if (object2 != null && ((String)object2).length() >= 0) {
                        bufferedWriter.write("makeDirectory ${TMPDIR}/" + (String)object2 + "\n");
                    }
                    bufferedWriter.write("copyFileToTmpDir \"" + ((PackagerFileElement)((Object)iterator2)).getFrom() + "\" \"${TMPDIR}/" + ((PackagerFileElement)((Object)iterator2)).getTo() + "\" 0" + ((PackagerFileElement)((Object)iterator2)).getPermission() + "\n");
                } else if (((PackagerFileElement)((Object)iterator2)).getType() == PackagerFileElement.FileType.DIRECTORY) {
                    bufferedWriter.write("makeDirectory  \"${TMPDIR}/" + ((PackagerFileElement)((Object)iterator2)).getTo() + "\"" + " 0" + ((PackagerFileElement)((Object)iterator2)).getPermission() + "\n");
                } else if (((PackagerFileElement)((Object)iterator2)).getType() == PackagerFileElement.FileType.SOFTLINK) {
                    object2 = IpeUtils.getDirName((String)((PackagerFileElement)((Object)iterator2)).getTo());
                    string = IpeUtils.getBaseName((String)((PackagerFileElement)((Object)iterator2)).getTo());
                    if (object2 != null && ((String)object2).length() >= 0) {
                        bufferedWriter.write("makeDirectory \"${TMPDIR}/" + (String)object2 + "\"" + "\n");
                    }
                    bufferedWriter.write("cd \"${TMPDIR}/" + (String)object2 + "\"" + "\n");
                    bufferedWriter.write("ln -s \"" + ((PackagerFileElement)((Object)iterator2)).getFrom() + "\"" + " " + "\"" + string + "\"" + "\n");
                } else if (((PackagerFileElement)((Object)iterator2)).getType() != PackagerFileElement.FileType.UNKNOWN) assert (false);
                bufferedWriter.write("\n");
            }
            bufferedWriter.write("\n");
            bufferedWriter.write("# Ensure proper rpm build environment\n");
            bufferedWriter.write("RPMMACROS=~/.rpmmacros\n");
            bufferedWriter.write("NBTOPDIR=~/.netbeans/6.5/cnd2/rpms\n");
            bufferedWriter.write("\n");
            bufferedWriter.write("if [ ! -f ${RPMMACROS} ]\n");
            bufferedWriter.write("then\n");
            bufferedWriter.write("    touch ${RPMMACROS}\n");
            bufferedWriter.write("fi\n");
            bufferedWriter.write("\n");
            bufferedWriter.write("TOPDIR=`grep _topdir ${RPMMACROS}`\n");
            bufferedWriter.write("if [ \"$TOPDIR\" == \"\" ]\n");
            bufferedWriter.write("then\n");
            bufferedWriter.write("    echo \"**********************************************************************************************************\"\n");
            bufferedWriter.write("    echo Warning: rpm build environment updated:\n");
            bufferedWriter.write("    echo \\\"%_topdir ${NBTOPDIR}\\\" added to ${RPMMACROS}\n");
            bufferedWriter.write("    echo \"**********************************************************************************************************\"\n");
            bufferedWriter.write("    echo %_topdir ${NBTOPDIR} >> ${RPMMACROS}\n");
            bufferedWriter.write("fi  \n");
            bufferedWriter.write("mkdir -p ${NBTOPDIR}/RPMS\n");
            bufferedWriter.write("\n");
            bufferedWriter.write("# Create spec file\n");
            bufferedWriter.write("cd \"${TOP}\"\n");
            bufferedWriter.write("SPEC_FILE=${TMPDIR}/../${OUTPUT_BASENAME}.spec\n");
            bufferedWriter.write("rm -f ${SPEC_FILE}\n");
            bufferedWriter.write("\n");
            bufferedWriter.write("cd \"${TOP}\"\n");
            bufferedWriter.write("echo BuildRoot: ${TOP}/${TMPDIR} >> ${SPEC_FILE}\n");
            List<PackagerInfoElement> list2 = packagingConfiguration.getHeaderSubList(PACKAGER_NAME);
            iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                object2 = (PackagerInfoElement)iterator2.next();
                if (((PackagerInfoElement)object2).getName().startsWith("%")) {
                    bufferedWriter.write("echo '" + ((PackagerInfoElement)object2).getName() + "' >> ${SPEC_FILE}\n");
                    string = ((PackagerInfoElement)object2).getValue();
                    int n = 0;
                    int n2 = string.indexOf("\\n");
                    while (n2 >= 0) {
                        bufferedWriter.write("echo '" + string.substring(n, n2) + "' >> ${SPEC_FILE}\n");
                        n = n2 + 2;
                        n2 = string.indexOf("\\n", n);
                    }
                    if (n < string.length()) {
                        bufferedWriter.write("echo '" + string.substring(n) + "' >> ${SPEC_FILE}\n");
                    }
                    bufferedWriter.write("echo  >> ${SPEC_FILE}\n");
                    continue;
                }
                bufferedWriter.write("echo " + ((PackagerInfoElement)object2).getName() + ": " + packagingConfiguration.expandMacros(((PackagerInfoElement)object2).getValue()) + " >> ${SPEC_FILE}\n");
            }
            bufferedWriter.write("echo '%files' >> ${SPEC_FILE}\n");
            for (Object object2 : list) {
                if (((PackagerFileElement)object2).getType() != PackagerFileElement.FileType.FILE && ((PackagerFileElement)object2).getType() != PackagerFileElement.FileType.SOFTLINK) continue;
                bufferedWriter.write("echo \\\"/" + ((PackagerFileElement)object2).getTo() + "\\\" >> ${SPEC_FILE}\n");
            }
            bufferedWriter.write("echo '%dir' >> ${SPEC_FILE}\n");
            for (Object object2 : list) {
                if (((PackagerFileElement)object2).getType() != PackagerFileElement.FileType.DIRECTORY) continue;
                bufferedWriter.write("echo \\\"/" + ((PackagerFileElement)object2).getTo() + "\\\" >> ${SPEC_FILE}\n");
            }
            bufferedWriter.write("\n");
            bufferedWriter.write("# Create RPM Package\n");
            bufferedWriter.write("cd \"${TOP}\"\n");
            bufferedWriter.write("LOG_FILE=${TMPDIR}/../${OUTPUT_BASENAME}.log\n");
            bufferedWriter.write(packagingConfiguration.getToolValue() + " " + packagingConfiguration.getOptionsValue() + " -bb ${SPEC_FILE} > ${LOG_FILE}\n");
            bufferedWriter.write("checkReturnCode\n");
            bufferedWriter.write("cat ${LOG_FILE}\n");
            bufferedWriter.write("RPM_PATH=`cat $LOG_FILE | grep .rpm | tail -1 |awk -F: '{ print $2 }'`\n");
            bufferedWriter.write("RPM_NAME=`basename ${RPM_PATH}`\n");
            bufferedWriter.write("mv ${RPM_PATH} " + packagingConfiguration.getOutputValue() + "\n");
            bufferedWriter.write("checkReturnCode\n");
            bufferedWriter.write("echo RPM: " + packagingConfiguration.getOutputValue() + "/" + "${RPM_NAME}" + "\n");
            bufferedWriter.write("\n");
        }
    }
}

