/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.configurations.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.IllegalCharsetNameException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.UIResource;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.makeproject.MakeProject;
import org.netbeans.modules.cnd.makeproject.api.MakeCustomizerProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.ui.utils.DirectoryChooserInnerPanel;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class ProjectPropPanel
extends JPanel
implements ActionListener {
    private SourceRootChooser sourceRootChooser;
    private Project project;
    private MakeConfigurationDescriptor makeConfigurationDescriptor;
    private String originalEncoding;
    private JComboBox encoding;
    private JLabel encodingLabel;
    private JPanel encodingPanel;
    private JLabel projectLabel;
    private JTextField projectTextField;
    private JPanel sourceRootPanel;

    public ProjectPropPanel(Project project, ConfigurationDescriptor configurationDescriptor) {
        this.project = project;
        this.makeConfigurationDescriptor = (MakeConfigurationDescriptor)configurationDescriptor;
        this.initComponents();
        this.projectTextField.setText(FileUtil.toFile((FileObject)project.getProjectDirectory()).getPath());
        this.sourceRootChooser = new SourceRootChooser(configurationDescriptor.getBaseDir(), this.makeConfigurationDescriptor.getSourceRootsAsArray());
        this.sourceRootPanel.add(this.sourceRootChooser);
        MakeCustomizerProvider makeCustomizerProvider = (MakeCustomizerProvider)project.getLookup().lookup(MakeCustomizerProvider.class);
        makeCustomizerProvider.addActionListener(this);
        this.originalEncoding = ((MakeProject)project).getSourceEncoding();
        if (this.originalEncoding == null) {
            this.originalEncoding = Charset.defaultCharset().name();
        }
        this.encoding.setModel(new EncodingModel(this.originalEncoding));
        this.encoding.setRenderer(new EncodingRenderer());
        this.encoding.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectPropPanel.this.handleEncodingChange();
            }
        });
    }

    private void handleEncodingChange() {
    }

    public void save() {
        Charset charset = (Charset)this.encoding.getSelectedItem();
        String string = charset != null ? charset.name() : this.originalEncoding;
        ((MakeProject)this.project).setSourceEncoding(string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        if (this.sourceRootChooser.isChanged()) {
            object = this.sourceRootChooser.getListData();
            this.makeConfigurationDescriptor.setSourceRootsList(new ArrayList<String>((Collection<String>)object));
        }
        object = (MakeCustomizerProvider)this.project.getLookup().lookup(MakeCustomizerProvider.class);
        ((MakeCustomizerProvider)object).removeActionListener(this);
    }

    private void initComponents() {
        this.projectLabel = new JLabel();
        this.projectTextField = new JTextField();
        this.sourceRootPanel = new JPanel();
        this.encodingPanel = new JPanel();
        this.encodingLabel = new JLabel();
        this.encoding = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.projectLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/configurations/ui/Bundle").getString("ProjectPropPanel.projectLabel.mn").charAt(0));
        this.projectLabel.setLabelFor(this.projectTextField);
        this.projectLabel.setText(NbBundle.getMessage(ProjectPropPanel.class, (String)"ProjectPropPanel.projectLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.add((Component)this.projectLabel, gridBagConstraints);
        this.projectLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectPropPanel.class, (String)"ProjectPropPanel.projectLabel.ad"));
        this.projectTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.projectTextField, gridBagConstraints);
        this.sourceRootPanel.setBackground(new Color(255, 255, 255));
        this.sourceRootPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.add((Component)this.sourceRootPanel, gridBagConstraints);
        this.encodingLabel.setLabelFor(this.encoding);
        Mnemonics.setLocalizedText((JLabel)this.encodingLabel, (String)NbBundle.getMessage(ProjectPropPanel.class, (String)"ProjectPropPanel.encodingLabel.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this.encodingPanel);
        this.encodingPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.encodingLabel).addPreferredGap(0).add((Component)this.encoding, -2, 137, -2).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.encodingLabel).add((Component)this.encoding, -2, -1, -2)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.encodingPanel, gridBagConstraints);
    }

    private static String getString(String string) {
        return NbBundle.getMessage(ProjectPropPanel.class, (String)string);
    }

    class SourceRootChooser
    extends DirectoryChooserInnerPanel {
        public SourceRootChooser(String string, Object[] objectArray) {
            super(string, objectArray);
            this.getCopyButton().setVisible(false);
            this.getEditButton().setVisible(false);
        }

        public String getListLabelText() {
            return ProjectPropPanel.getString("ProjectPropPanel.sourceRootLabel.text");
        }

        public char getListLabelMnemonic() {
            return ProjectPropPanel.getString("ProjectPropPanel.sourceRootLabel.mn").charAt(0);
        }

        public char getAddButtonMnemonics() {
            return ProjectPropPanel.getString("ADD_BUTTON_MN").charAt(0);
        }

        public String getAddButtonText() {
            return ProjectPropPanel.getString("ADD_BUTTON_TXT");
        }
    }

    private static class UnknownCharset
    extends Charset {
        UnknownCharset(String string) {
            super(string, new String[0]);
        }

        public boolean contains(Charset charset) {
            throw new UnsupportedOperationException();
        }

        public CharsetDecoder newDecoder() {
            throw new UnsupportedOperationException();
        }

        public CharsetEncoder newEncoder() {
            throw new UnsupportedOperationException();
        }
    }

    private static class EncodingModel
    extends DefaultComboBoxModel {
        public EncodingModel(String string) {
            Charset charset = null;
            for (Charset charset2 : Charset.availableCharsets().values()) {
                if (charset2.name().equals(string)) {
                    charset = charset2;
                }
                this.addElement(charset2);
            }
            if (charset == null) {
                try {
                    charset = new UnknownCharset(string);
                    this.addElement(charset);
                }
                catch (IllegalCharsetNameException illegalCharsetNameException) {
                    Logger.getLogger(this.getClass().getName()).info("IllegalCharsetName: " + string);
                }
            }
            if (charset == null) {
                charset = Charset.defaultCharset();
            }
            this.setSelectedItem(charset);
        }
    }

    private static class EncodingRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public EncodingRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            assert (object instanceof Charset);
            this.setName("ComboBox.listRenderer");
            this.setText(((Charset)object).displayName());
            this.setIcon(null);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }

        public String getName() {
            String string = super.getName();
            return string == null ? "ComboBox.renderer" : string;
        }
    }
}

