/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

public class BooleanConfiguration {
    private BooleanConfiguration master;
    private boolean def;
    private String falseValue;
    private String trueValue;
    private boolean value;
    private boolean modified;
    private boolean dirty = false;

    public BooleanConfiguration(BooleanConfiguration booleanConfiguration, boolean bl) {
        this.master = booleanConfiguration;
        this.def = bl;
        this.falseValue = "";
        this.trueValue = "";
        this.reset();
    }

    public BooleanConfiguration(BooleanConfiguration booleanConfiguration, boolean bl, String string, String string2) {
        this.master = booleanConfiguration;
        this.def = bl;
        this.falseValue = string;
        this.trueValue = string2;
        this.reset();
    }

    protected BooleanConfiguration getMaster() {
        return this.master;
    }

    public void setValue(boolean bl) {
        this.value = bl;
        if (this.master != null) {
            this.setModified(true);
        } else {
            this.setModified(bl != this.getDefault());
        }
    }

    public boolean getValue() {
        if (this.master != null && !this.getModified()) {
            return this.master.getValue();
        }
        return this.value;
    }

    public void setModified(boolean bl) {
        this.modified = bl;
    }

    public boolean getModified() {
        return this.modified;
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public boolean getDirty() {
        return this.dirty;
    }

    public boolean getDefault() {
        return this.def;
    }

    public void setDefault(boolean bl) {
        this.def = bl;
        this.setModified(this.value != this.def);
    }

    public void reset() {
        this.value = this.getDefault();
        this.setModified(false);
    }

    public String getOption() {
        if (this.getValue()) {
            return this.trueValue;
        }
        return this.falseValue;
    }

    public void assign(BooleanConfiguration booleanConfiguration) {
        this.dirty |= booleanConfiguration.getValue() ^ this.getValue();
        this.setValue(booleanConfiguration.getValue());
        this.setModified(booleanConfiguration.getModified());
    }

    public Object clone() {
        BooleanConfiguration booleanConfiguration = new BooleanConfiguration(this.master, this.def, this.falseValue, this.trueValue);
        booleanConfiguration.setValue(this.getValue());
        booleanConfiguration.setModified(this.getModified());
        return booleanConfiguration;
    }
}

