/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.cnd.makeproject.api.PackagerDescriptor;
import org.netbeans.modules.cnd.makeproject.api.PackagerDescriptorProvider;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackagerManager {
    private static List<PackagerDescriptor> list = null;
    private static PackagerManager instance;

    public static PackagerManager getDefault() {
        if (instance == null) {
            instance = new PackagerManager();
            list = new ArrayList<PackagerDescriptor>();
            instance.addRegisteredPackagers();
        }
        return instance;
    }

    private void addRegisteredPackagers() {
        Set<PackagerDescriptorProvider> set = PackagerManager.getPackagerDescriptorProviders();
        for (PackagerDescriptorProvider packagerDescriptorProvider : set) {
            List<PackagerDescriptor> list = packagerDescriptorProvider.getPackagerDescriptorProviderList();
            for (PackagerDescriptor packagerDescriptor : list) {
                this.addPackagingDescriptor(packagerDescriptor);
            }
        }
    }

    public void addPackagingDescriptor(PackagerDescriptor packagerDescriptor) {
        PackagerDescriptor packagerDescriptor2 = this.getPackager(packagerDescriptor.getName());
        if (packagerDescriptor2 != null) {
            return;
        }
        list.add(packagerDescriptor);
    }

    public List<PackagerDescriptor> getPackagerList() {
        return list;
    }

    public PackagerDescriptor getPackager(String string) {
        for (PackagerDescriptor packagerDescriptor : list) {
            if (!packagerDescriptor.getName().equals(string)) continue;
            return packagerDescriptor;
        }
        return null;
    }

    public int getNameIndex(String string) {
        int n = 0;
        for (PackagerDescriptor packagerDescriptor : list) {
            if (packagerDescriptor.getName().equals(string)) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    public String[] getDisplayNames() {
        String[] stringArray = new String[list.size()];
        int n = 0;
        for (PackagerDescriptor packagerDescriptor : list) {
            stringArray[n++] = packagerDescriptor.getDisplayName();
        }
        return stringArray;
    }

    public String getDisplayName(String string) {
        for (PackagerDescriptor packagerDescriptor : list) {
            if (!packagerDescriptor.getName().equals(string)) continue;
            return packagerDescriptor.getDisplayName();
        }
        return null;
    }

    public String getName(String string) {
        for (PackagerDescriptor packagerDescriptor : list) {
            if (!packagerDescriptor.getDisplayName().equals(string)) continue;
            return packagerDescriptor.getName();
        }
        return null;
    }

    private static Set<PackagerDescriptorProvider> getPackagerDescriptorProviders() {
        HashSet<PackagerDescriptorProvider> hashSet = new HashSet<PackagerDescriptorProvider>();
        Lookup.Template template = new Lookup.Template(PackagerDescriptorProvider.class);
        Lookup.Result result = Lookup.getDefault().lookup(template);
        Collection collection = result.allInstances();
        for (Object e : collection) {
            if (!(e instanceof PackagerDescriptorProvider)) continue;
            hashSet.add((PackagerDescriptorProvider)e);
        }
        return hashSet;
    }
}

