/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.includes;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.completion.includes.CsmIncludeCompletionItem;
import org.netbeans.modules.cnd.loaders.HDataLoader;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.openide.loaders.ExtensionList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsmIncludeCompletionQuery {
    private static final Collection<String> EXCLUDED_DIR_NAMES = Arrays.asList("CVS", ".hg", "nbproject", "SCCS", "SunWS_cache");
    private Map<String, CsmIncludeCompletionItem> results;
    private final CsmFile file;

    public CsmIncludeCompletionQuery(CsmFile csmFile) {
        this.file = csmFile;
    }

    public Collection<CsmIncludeCompletionItem> query(BaseDocument baseDocument, String string, int n, Boolean bl, boolean bl2) {
        File file;
        String string2;
        this.results = new HashMap<String, CsmIncludeCompletionItem>(100);
        CsmFile csmFile = this.file;
        if (csmFile == null) {
            csmFile = CsmUtilities.getCsmFile((Document)baseDocument, (boolean)false);
        }
        Collection<Object> collection = Collections.emptyList();
        Collection<Object> collection2 = Collections.emptyList();
        File file2 = new File(string);
        if (file2.isAbsolute()) {
            this.addFolderItems("", "", string, true, bl != null ? bl : false, true, n);
            return this.results.values();
        }
        if (csmFile != null) {
            string2 = ((Object)csmFile.getAbsolutePath()).toString();
            collection = this.getFileIncludes(csmFile, false);
            collection2 = this.getFileIncludes(csmFile, true);
        } else {
            file = CsmUtilities.getFile((Document)baseDocument);
            if (file == null) {
                return Collections.emptyList();
            }
            string2 = file.getAbsolutePath();
        }
        file = new File(string2).getParentFile();
        if (bl == null || bl == Boolean.TRUE) {
            this.addFolderItems(file.getAbsolutePath(), ".", string, false, false, true, n);
            if (bl2) {
                for (String string3 : collection) {
                    this.addFolderItems(string3, string3, string, false, false, true, n);
                }
                for (String string3 : collection2) {
                    this.addFolderItems(string3, string3, string, false, true, false, n);
                }
            }
            if (file.getParentFile() != null) {
                this.addParentFolder(n, string, false);
            }
        } else {
            for (String string4 : collection2) {
                this.addFolderItems(string4, string4, string, false, true, false, n);
            }
            if (bl2) {
                for (String string5 : collection) {
                    this.addFolderItems(string5, string5, string, false, false, true, n);
                }
                this.addFolderItems(file.getAbsolutePath(), ".", string, false, false, true, n);
                if (file.getParentFile() != null) {
                    this.addParentFolder(n, string, true);
                }
            }
        }
        return this.results.values();
    }

    private void addFolderItems(String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3, int n) {
        File file = new File(string, string3);
        if (file != null && file.exists()) {
            File[] fileArray;
            File[] fileArray2 = fileArray = bl3 ? file.listFiles(new MyFileFilter(HDataLoader.getInstance().getExtensions())) : file.listFiles(new DefFileFilter());
            if (fileArray != null) {
                for (File file2 : fileArray) {
                    String string4 = file2.getName();
                    CsmIncludeCompletionItem csmIncludeCompletionItem = CsmIncludeCompletionItem.createItem(n, string4, string2, string3, bl2, bl, file2.isDirectory(), true);
                    if (this.results.containsKey(string4)) continue;
                    this.results.put(string4, csmIncludeCompletionItem);
                }
            }
        }
    }

    private void addParentFolder(int n, String string, boolean bl) {
        if (!this.results.isEmpty()) {
            CsmIncludeCompletionItem csmIncludeCompletionItem = CsmIncludeCompletionItem.createItem(n, "..", ".", string, bl, false, true, false);
            this.results.put("..", csmIncludeCompletionItem);
        }
    }

    private Collection<String> getFileIncludes(CsmFile csmFile, boolean bl) {
        if (bl) {
            return CsmFileInfoQuery.getDefault().getSystemIncludePaths(csmFile);
        }
        return CsmFileInfoQuery.getDefault().getUserIncludePaths(csmFile);
    }

    private static boolean specialFile(File file) {
        String string = file.getName();
        if (string.startsWith(".")) {
            return true;
        }
        if (string.endsWith("~")) {
            return true;
        }
        return file.isDirectory() && EXCLUDED_DIR_NAMES.contains(string);
    }

    private static final class MyFileFilter
    implements FileFilter {
        private final ExtensionList exts;

        protected MyFileFilter(ExtensionList extensionList) {
            this.exts = extensionList;
        }

        public boolean accept(File file) {
            return !CsmIncludeCompletionQuery.specialFile(file) && (this.exts.isRegistered(file.getName()) || file.isDirectory());
        }
    }

    private static final class DefFileFilter
    implements FileFilter {
        private DefFileFilter() {
        }

        public boolean accept(File file) {
            return !CsmIncludeCompletionQuery.specialFile(file);
        }
    }
}

