/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html.parser;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.editor.ext.html.parser.AstPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AstNode {
    private String name;
    private NodeType nodeType;
    private int startOffset;
    private int endOffset;
    private List<AstNode> children = null;
    private AstNode parent = null;
    private Map<String, Object> attributes = null;

    AstNode(String string, NodeType nodeType, int n, int n2) {
        this.name = string;
        this.nodeType = nodeType;
        this.startOffset = n;
        this.endOffset = n2;
    }

    public String name() {
        return this.name;
    }

    public NodeType type() {
        return this.nodeType;
    }

    public int startOffset() {
        return this.startOffset;
    }

    public int endOffset() {
        return this.endOffset;
    }

    public List<AstNode> children() {
        return this.children == null ? Collections.EMPTY_LIST : this.children;
    }

    void addChild(AstNode astNode) {
        if (this.children == null) {
            this.children = new LinkedList<AstNode>();
        }
        this.children.add(astNode);
        astNode.setParent(this);
    }

    void markUnmatched() {
        this.nodeType = NodeType.UNMATCHED_TAG;
    }

    void setAttribute(String string, Object object) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(string, object);
    }

    public Object getAttribute(String string) {
        return this.attributes == null ? null : this.attributes.get(string);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (AstNode astNode : this.children()) {
            String string = astNode.toString();
            for (String string2 : string.split("\n")) {
                stringBuilder.append("-");
                stringBuilder.append(string2);
                stringBuilder.append('\n');
            }
        }
        return this.name() + ":" + (Object)((Object)this.type()) + "<" + this.startOffset() + "," + this.endOffset() + ">\n" + stringBuilder.toString();
    }

    String signature() {
        return this.name() + "[" + (Object)((Object)this.type()) + "]";
    }

    public AstNode parent() {
        return this.parent;
    }

    public AstPath path() {
        return new AstPath(null, this);
    }

    void removeTagChildren() {
        Iterator<AstNode> iterator = this.children().iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().isTagNode()) continue;
            iterator.remove();
        }
    }

    boolean isTagNode() {
        return this.type() == NodeType.TAG || this.type() == NodeType.UNMATCHED_TAG;
    }

    private void setParent(AstNode astNode) {
        this.parent = astNode;
    }

    void setEndOffset(int n) {
        this.endOffset = n;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NodeType {
        COMMENT,
        DECLARATION,
        ERROR,
        TEXT,
        TAG,
        UNMATCHED_TAG,
        OPEN_TAG,
        ENDTAG,
        ENTITY_REFERENCE;

    }
}

