/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localhistory.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.openide.filesystems.FileUtil;

public class FileUtils {
    private FileUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, File file2) throws IOException {
        if (file == null || file2 == null) {
            throw new NullPointerException("sourceFile and targetFile must not be null");
        }
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = FileUtils.createInputStream(file);
            FileUtils.copy(bufferedInputStream, file2);
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    ((InputStream)bufferedInputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File file, OutputStream outputStream) throws IOException {
        if (file == null) {
            throw new NullPointerException("file must not be null");
        }
        if (outputStream == null) {
            throw new NullPointerException("output stream must not be null");
        }
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = FileUtils.createInputStream(file);
            FileUtil.copy((InputStream)bufferedInputStream, (OutputStream)outputStream);
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    ((InputStream)bufferedInputStream).close();
                }
                catch (IOException iOException) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream inputStream, File file) throws IOException {
        if (inputStream == null || file == null) {
            throw new NullPointerException("sourcStream and targetFile must not be null");
        }
        File file2 = file.getParentFile();
        if (!file2.exists() && !file2.mkdirs()) {
            throw new IOException("Could not create directory '" + file2 + "'");
        }
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedOutputStream = FileUtils.createOutputStream(file);
            try {
                byte[] byArray = new byte[32768];
                int n = inputStream.read(byArray);
                while (n > 0) {
                    ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
                    n = inputStream.read(byArray);
                }
            }
            catch (IOException iOException) {
                file.delete();
                throw iOException;
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (bufferedOutputStream != null) {
                try {
                    ((OutputStream)bufferedOutputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void deleteRecursively(File file) {
        File[] fileArray;
        if (file == null) {
            return;
        }
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                FileUtils.deleteRecursively(fileArray[i]);
            }
        }
        file.delete();
    }

    public static void renameFile(File file, File file2) throws IOException {
        int n;
        boolean bl = file2.exists();
        if (bl) {
            for (n = 0; n < 3; ++n) {
                if (file2.delete()) {
                    bl = false;
                    break;
                }
                try {
                    Thread.sleep(71L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (!bl) {
            for (n = 0; n < 3; ++n) {
                if (file.renameTo(file2)) {
                    return;
                }
                try {
                    Thread.sleep(71L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        FileUtils.copyFile(file, file2);
        for (n = 0; n < 3; ++n) {
            if (file.delete()) {
                return;
            }
            try {
                Thread.sleep(71L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        throw new IOException("Can not delete: " + file.getAbsolutePath());
    }

    private static BufferedInputStream createInputStream(File file) throws IOException {
        int n = 0;
        while (true) {
            try {
                return new BufferedInputStream(new FileInputStream(file));
            }
            catch (IOException iOException) {
                if (++n > 7) {
                    throw iOException;
                }
                try {
                    Thread.sleep(n * 34);
                }
                catch (InterruptedException interruptedException) {
                    throw iOException;
                }
            }
        }
    }

    private static BufferedOutputStream createOutputStream(File file) throws IOException {
        int n = 0;
        while (true) {
            try {
                return new BufferedOutputStream(new FileOutputStream(file));
            }
            catch (IOException iOException) {
                if (++n > 7) {
                    throw iOException;
                }
                try {
                    Thread.sleep(n * 34);
                }
                catch (InterruptedException interruptedException) {
                    throw iOException;
                }
            }
        }
    }
}

