/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localhistory.ui.view;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.api.diff.DiffController;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.localhistory.LocalHistory;
import org.netbeans.modules.localhistory.store.StoreEntry;
import org.netbeans.modules.localhistory.ui.view.DiffPanel;
import org.netbeans.modules.localhistory.ui.view.LocalHistoryTopComponent;
import org.netbeans.modules.localhistory.ui.view.StoreEntryNode;
import org.netbeans.modules.localhistory.utils.FileUtils;
import org.netbeans.modules.versioning.util.NoContentPanel;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.VersioningEvent;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public class LocalHistoryDiffView
implements PropertyChangeListener,
ActionListener,
VersioningListener {
    private final LocalHistoryTopComponent master;
    private DiffPanel panel;
    private Component diffComponent;
    private DiffController diffView;
    private DiffPrepareTask prepareTask = null;
    private boolean selected;

    public LocalHistoryDiffView(LocalHistoryTopComponent localHistoryTopComponent) {
        this.master = localHistoryTopComponent;
        this.panel = new DiffPanel();
        this.panel.nextButton.addActionListener(this);
        this.panel.prevButton.addActionListener(this);
        LocalHistory.getInstance().addVersioningListener(this);
        this.showNoContent(NbBundle.getMessage(LocalHistoryDiffView.class, (String)"MSG_DiffPanel_NoVersion"));
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
            this.disableNavigationButtons();
            this.selectionChanged(propertyChangeEvent);
        } else if ("(void) differencesChanged".equals(propertyChangeEvent.getPropertyName())) {
            this.refreshNavigationButtons();
        }
    }

    public void versioningEvent(VersioningEvent versioningEvent) {
        if (versioningEvent.getId() != LocalHistory.EVENT_FILE_CREATED) {
            return;
        }
        File file = (File)versioningEvent.getParams()[0];
        if (file == null || this.prepareTask == null || !this.selected || !file.equals(this.prepareTask.entry.getFile())) {
            return;
        }
        LocalHistoryDiffView.scheduleTask(this.prepareTask);
    }

    JPanel getPanel() {
        return this.panel;
    }

    private void selectionChanged(PropertyChangeEvent propertyChangeEvent) {
        Node[] nodeArray = (Node[])propertyChangeEvent.getNewValue();
        this.selected = true;
        if (nodeArray == null || nodeArray.length == 0) {
            this.selected = false;
            this.showNoContent(NbBundle.getMessage(LocalHistoryDiffView.class, (String)"MSG_DiffPanel_NoVersion"));
            return;
        }
        StoreEntry storeEntry = (StoreEntry)nodeArray[0].getLookup().lookup(StoreEntry.class);
        if (storeEntry == null) {
            this.selected = false;
            this.showNoContent(NbBundle.getMessage(LocalHistoryDiffView.class, (String)"MSG_DiffPanel_IllegalSelection"));
            return;
        }
        this.refreshDiffPanel(storeEntry);
    }

    private void refreshDiffPanel(StoreEntry storeEntry) {
        this.prepareTask = new DiffPrepareTask(storeEntry);
        LocalHistoryDiffView.scheduleTask(this.prepareTask);
    }

    private static void scheduleTask(Runnable runnable) {
        RequestProcessor.Task task = RequestProcessor.getDefault().create(runnable);
        task.schedule(0);
    }

    private void showNoContent(String string) {
        this.setDiffComponent((Component)new NoContentPanel(string));
    }

    private void setDiffComponent(Component component) {
        if (this.diffComponent != null) {
            this.panel.diffPanel.remove(this.diffComponent);
        }
        this.panel.diffPanel.add(component, "Center");
        this.diffComponent = component;
        this.panel.diffPanel.revalidate();
        this.panel.diffPanel.repaint();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.panel.nextButton) {
            this.onNextButton();
        } else if (actionEvent.getSource() == this.panel.prevButton) {
            this.onPrevButton();
        }
    }

    private void onNextButton() {
        if (this.diffView == null) {
            return;
        }
        int n = this.diffView.getDifferenceIndex() + 1;
        if (n < this.diffView.getDifferenceCount()) {
            this.setCurrentDifference(n);
        }
    }

    private void onPrevButton() {
        if (this.diffView == null) {
            return;
        }
        int n = this.diffView.getDifferenceIndex() - 1;
        if (n > -1) {
            this.setCurrentDifference(n);
        }
    }

    private void setCurrentDifference(int n) {
        this.diffView.setLocation(DiffController.DiffPane.Modified, DiffController.LocationType.DifferenceIndex, n);
        this.refreshNavigationButtons();
    }

    private void disableNavigationButtons() {
        this.panel.prevButton.setEnabled(false);
        this.panel.nextButton.setEnabled(false);
    }

    private void refreshNavigationButtons() {
        int n = this.diffView.getDifferenceIndex();
        this.panel.prevButton.setEnabled(n > 0);
        this.panel.nextButton.setEnabled(n < this.diffView.getDifferenceCount() - 1);
    }

    private class LHStreamSource
    extends StreamSource {
        private final File file;
        private final String title;
        private final String mimeType;

        public LHStreamSource(File file, String string, String string2) {
            this.file = file;
            this.title = string;
            this.mimeType = string2;
        }

        public boolean isEditable() {
            FileObject fileObject = FileUtil.toFileObject((File)this.file);
            return this.isPrimary(fileObject);
        }

        private boolean isPrimary(FileObject fileObject) {
            if (fileObject != null) {
                try {
                    DataObject dataObject = DataObject.find((FileObject)fileObject);
                    return fileObject.equals(dataObject.getPrimaryFile());
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    // empty catch block
                }
            }
            return true;
        }

        public Lookup getLookup() {
            FileObject fileObject = FileUtil.toFileObject((File)this.file);
            if (fileObject != null && this.isPrimary(fileObject)) {
                return Lookups.fixed((Object[])new Object[]{fileObject});
            }
            return Lookups.fixed((Object[])new Object[0]);
        }

        public String getName() {
            return this.title;
        }

        public String getTitle() {
            return this.title;
        }

        public String getMIMEType() {
            return this.mimeType;
        }

        public Reader createReader() throws IOException {
            return new FileReader(this.file);
        }

        public Writer createWriter(Difference[] differenceArray) throws IOException {
            return null;
        }
    }

    private class DiffPrepareTask
    implements Runnable {
        private final StoreEntry entry;

        public DiffPrepareTask(StoreEntry storeEntry) {
            this.entry = storeEntry;
        }

        public void run() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        StreamSource streamSource;
                        File file = DiffPrepareTask.this.entry.getFile();
                        File file2 = Utils.getTempFolder();
                        File file3 = new File(file2, file.getName());
                        file3.deleteOnExit();
                        FileUtils.copy(DiffPrepareTask.this.entry.getStoreFileInputStream(), file3);
                        Utils.associateEncoding((File)file, (File)file3);
                        LHStreamSource lHStreamSource = new LHStreamSource(file3, DiffPrepareTask.this.entry.getFile().getName() + " " + StoreEntryNode.getFormatedDate(DiffPrepareTask.this.entry), DiffPrepareTask.this.entry.getMIMEType());
                        if (file.exists()) {
                            String string = NbBundle.getMessage(LocalHistoryDiffView.class, (String)"LBL_Diff_CurrentFile");
                            streamSource = new LHStreamSource(file, string, DiffPrepareTask.this.entry.getMIMEType());
                        } else {
                            String string = NbBundle.getMessage(LocalHistoryDiffView.class, (String)"LBL_Diff_FileDeleted");
                            streamSource = StreamSource.createSource((String)"currentfile", (String)string, (String)DiffPrepareTask.this.entry.getMIMEType(), (Reader)new StringReader(""));
                        }
                        LocalHistoryDiffView.this.diffView = DiffController.create((StreamSource)lHStreamSource, (StreamSource)streamSource);
                        LocalHistoryDiffView.this.diffView.addPropertyChangeListener((PropertyChangeListener)LocalHistoryDiffView.this);
                        JComponent jComponent = LocalHistoryDiffView.this.diffView.getJComponent();
                        LocalHistoryDiffView.this.setDiffComponent(jComponent);
                        LocalHistoryDiffView.this.master.setDiffView(jComponent);
                        if (LocalHistoryDiffView.this.diffView.getDifferenceCount() > 0) {
                            LocalHistoryDiffView.this.setCurrentDifference(0);
                        } else {
                            LocalHistoryDiffView.this.refreshNavigationButtons();
                        }
                        LocalHistoryDiffView.this.panel.revalidate();
                        LocalHistoryDiffView.this.panel.repaint();
                    }
                    catch (IOException iOException) {
                        LocalHistory.LOG.log(Level.SEVERE, null, iOException);
                    }
                }
            });
        }
    }
}

