/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.wsdlextensions.jms.validator;

import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import org.netbeans.modules.wsdlextensions.jms.validator.ConnectionUrl;
import org.netbeans.modules.wsdlextensions.jms.validator.Str;
import org.netbeans.modules.wsdlextensions.jms.validator.SunOneConnectionUrl;
import org.netbeans.modules.wsdlextensions.jms.validator.ValidationException;

public class SunOneUrlParser
extends ConnectionUrl {
    private SunOneConnectionUrl[] mConnectionUrls;
    public static final String PROT_MQ = "mq";
    public static final String PROT_MQTCP = "mqtcp";
    public static final String PROT_MQSSL = "mqssl";
    public static final String PROT_HTTP = "httpjms";
    public static final String PROT_HTTPS = "httpsjms";
    public static final String[] URL_PREFIXES = new String[]{"mq://", "mqtcp://", "mqssl://", "httpjms://", "httpsjms://"};
    public static final String[] PROTOCOLS = new String[]{"mq", "mqtcp", "mqssl", "httpjms", "httpsjms"};

    public SunOneUrlParser(String string) {
        ArrayList<SunOneConnectionUrl> arrayList = new ArrayList<SunOneConnectionUrl>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            arrayList.add(new SunOneConnectionUrl(string2));
        }
        this.mConnectionUrls = arrayList.toArray(new SunOneConnectionUrl[arrayList.size()]);
    }

    public void getQueryProperties(Properties properties) throws ValidationException {
        SunOneConnectionUrl[] sunOneConnectionUrlArray = this.getConnectionUrls();
        for (int i = 0; i < sunOneConnectionUrlArray.length; ++i) {
            sunOneConnectionUrlArray[i].getQueryProperties(properties);
        }
    }

    public boolean validate() throws ValidationException {
        if (this.mConnectionUrls.length == 0) {
            throw new ValidationException("URL should be a comma delimited set of URLs");
        }
        boolean bl = true;
        for (int i = 0; i < this.mConnectionUrls.length; ++i) {
            SunOneConnectionUrl sunOneConnectionUrl = this.mConnectionUrls[i];
            bl = false;
            for (int j = 0; j < PROTOCOLS.length; ++j) {
                if (!PROTOCOLS[j].equals(sunOneConnectionUrl.getProtocol())) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            throw new ValidationException("Invalid protocol [" + sunOneConnectionUrl.getProtocol() + "]: should be one of [" + Str.concat(PROTOCOLS, ", ") + "].");
        }
        return bl;
    }

    public SunOneConnectionUrl[] getConnectionUrls() {
        return this.mConnectionUrls;
    }

    public String getSunOneUrlSet() throws ValidationException {
        SunOneConnectionUrl[] sunOneConnectionUrlArray = this.getConnectionUrls();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < sunOneConnectionUrlArray.length; ++i) {
            if (i != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(sunOneConnectionUrlArray[i].getProtocol() + "://" + sunOneConnectionUrlArray[i].getHost() + ":" + sunOneConnectionUrlArray[i].getPort() + "/" + sunOneConnectionUrlArray[i].getService());
        }
        return stringBuffer.toString();
    }

    public String getSunOneUrlAdminSet() throws ValidationException {
        SunOneConnectionUrl[] sunOneConnectionUrlArray = this.getConnectionUrls();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < sunOneConnectionUrlArray.length; ++i) {
            if (i != 0) {
                stringBuffer.append(",");
            }
            if ("jms".equals(sunOneConnectionUrlArray[i].getService())) {
                stringBuffer.append(sunOneConnectionUrlArray[i].getProtocol() + "://" + sunOneConnectionUrlArray[i].getHost() + ":" + sunOneConnectionUrlArray[i].getPort() + "/admin");
                continue;
            }
            if ("jssljms".equals(sunOneConnectionUrlArray[i].getService())) {
                stringBuffer.append(sunOneConnectionUrlArray[i].getProtocol() + "://" + sunOneConnectionUrlArray[i].getHost() + ":" + sunOneConnectionUrlArray[i].getPort() + "/ssladmin");
                continue;
            }
            stringBuffer.append(sunOneConnectionUrlArray[i].getProtocol() + "://" + sunOneConnectionUrlArray[i].getHost() + ":" + sunOneConnectionUrlArray[i].getPort() + "/admin");
        }
        return stringBuffer.toString();
    }
}

