/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.wsdlextensions.jms.validator;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.netbeans.modules.wsdlextensions.jms.JMSAddress;
import org.netbeans.modules.wsdlextensions.jms.JMSBinding;
import org.netbeans.modules.wsdlextensions.jms.JMSComponent;
import org.netbeans.modules.wsdlextensions.jms.JMSJNDIEnv;
import org.netbeans.modules.wsdlextensions.jms.JMSJNDIEnvEntry;
import org.netbeans.modules.wsdlextensions.jms.JMSMapMessage;
import org.netbeans.modules.wsdlextensions.jms.JMSMessage;
import org.netbeans.modules.wsdlextensions.jms.JMSOperation;
import org.netbeans.modules.wsdlextensions.jms.JMSOption;
import org.netbeans.modules.wsdlextensions.jms.JMSOptions;
import org.netbeans.modules.wsdlextensions.jms.JMSProperties;
import org.netbeans.modules.wsdlextensions.jms.JMSProperty;
import org.netbeans.modules.wsdlextensions.jms.validator.RedeliveryHandlingParser;
import org.netbeans.modules.wsdlextensions.jms.validator.SunOneUrlParser;
import org.netbeans.modules.wsdlextensions.jms.validator.UrlParser;
import org.netbeans.modules.wsdlextensions.jms.validator.ValidationException;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.Input;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.OperationParameter;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.wsdl.model.Service;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.Reference;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.netbeans.modules.xml.xam.spi.Validation;
import org.netbeans.modules.xml.xam.spi.ValidationResult;
import org.netbeans.modules.xml.xam.spi.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSComponentValidator
implements Validator {
    private static final ResourceBundle mMessages = ResourceBundle.getBundle("org.netbeans.modules.wsdlextensions.jms.validator.Bundle");
    private Validation mValidation;
    private Validation.ValidationType mValidationType;
    private ValidationResult mValidationResult;
    public static final ValidationResult EMPTY_RESULT = new ValidationResult((Collection)Collections.EMPTY_SET, (Collection)Collections.EMPTY_SET);

    public String getName() {
        return this.getClass().getName();
    }

    public ValidationResult validate(Model model, Validation validation, Validation.ValidationType validationType) {
        this.mValidation = validation;
        this.mValidationType = validationType;
        HashSet<Validator.ResultItem> hashSet = new HashSet<Validator.ResultItem>();
        HashSet<Model> hashSet2 = new HashSet<Model>();
        hashSet2.add(model);
        this.mValidationResult = new ValidationResult(hashSet, hashSet2);
        if (model instanceof WSDLModel) {
            Object object;
            BindingOperation bindingOperation;
            int n;
            Object object2;
            WSDLModel wSDLModel = (WSDLModel)model;
            if (model.getState() == Model.State.NOT_WELL_FORMED) {
                return EMPTY_RESULT;
            }
            Definitions definitions = wSDLModel.getDefinitions();
            Iterator iterator = definitions.getServices().iterator();
            while (iterator.hasNext()) {
                for (Binding binding : ((Service)iterator.next()).getPorts()) {
                    List list = binding.getExtensibilityElements(JMSJNDIEnv.class);
                    if (list.size() > 0) {
                        hashSet.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)binding, this.getMessage("JMSBindingValidation.INVALID_USAGE_OF_JMS_JNDIENV_ELEM", new Object[]{binding.getName(), new Integer(list.size())})));
                    }
                    if (binding.getBinding() == null || (object2 = (Binding)binding.getBinding().get()) == null) continue;
                    n = object2.getExtensibilityElements(JMSBinding.class).size();
                    List list2 = binding.getExtensibilityElements(JMSAddress.class);
                    bindingOperation = list2.iterator();
                    if (n > 0 && list2.size() == 0) {
                        hashSet.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)binding, this.getMessage("JMSAddressValidation.MISSING_JMS_ADDRESS", new Object[]{binding.getName(), new Integer(n)})));
                    }
                    if (list2.size() > 1) {
                        hashSet.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)binding, this.getMessage("JMSAddressValidation.ONLY_ONE_JMS_ADDRESS_ALLOWED", new Object[]{binding.getName(), new Integer(list2.size())})));
                    }
                    while (bindingOperation.hasNext()) {
                        object = (JMSAddress)bindingOperation.next();
                        this.validate((JMSAddress)object);
                        if (!object.getConnectionURL().startsWith("jndi://")) continue;
                        for (List list3 : object2.getBindingOperations()) {
                        }
                    }
                }
            }
            for (Binding binding : definitions.getBindings()) {
                int n2;
                if (binding.getType() == null || binding.getType().get() == null || (n2 = binding.getExtensibilityElements(JMSBinding.class).size()) == 0) continue;
                if (n2 > 0 && n2 != 1) {
                    hashSet.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)binding, this.getMessage("JMSBindingValidation.ONLY_ONE_JMS_BINDING_ALLOWED", new Object[]{binding.getName(), new Integer(n2)})));
                }
                object2 = binding.getBindingOperations().iterator();
                n = 0;
                int n3 = 0;
                while (object2.hasNext()) {
                    List list3;
                    bindingOperation = (BindingOperation)object2.next();
                    object = bindingOperation.getExtensibilityElements(JMSOperation.class);
                    Iterator iterator2 = object.iterator();
                    if (object.size() > 1) {
                        hashSet.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)bindingOperation, this.getMessage("JMSBindingValidation.ONLY_ONE_JMS_OPERATION_ALLOWED", new Object[]{binding.getName(), bindingOperation.getName(), new Integer(object.size())})));
                    }
                    while (iterator2.hasNext()) {
                        this.validate(bindingOperation, (JMSOperation)iterator2.next());
                    }
                    if (object.size() > 0) {
                        Object object3;
                        Iterator iterator3;
                        Object object4;
                        n = 1;
                        if (!this.checkSignature(bindingOperation)) {
                            hashSet.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)bindingOperation, this.getMessage("JMSBindingValidation.OP_SIG_MISMATCH_BINDING_ABSTRACT", new Object[]{binding.getName(), bindingOperation.getName()})));
                            continue;
                        }
                        list3 = bindingOperation.getBindingInput();
                        if (list3 != null) {
                            n3 = 0;
                            object4 = list3.getExtensibilityElements(JMSMessage.class).iterator();
                            if (object4 != null) {
                                while (object4.hasNext()) {
                                    ++n3;
                                    iterator3 = (JMSMessage)object4.next();
                                    this.validate(bindingOperation, (OperationParameter)list3.getInput().get(), (JMSMessage)((Object)iterator3));
                                }
                                if (n3 > 1) {
                                    hashSet.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)list3, this.getMessage("JMSBindingValidation.ATMOST_ONE_MESSAGE_IN_INPUT", new Object[]{bindingOperation.getName(), new Integer(n3), list3.getName()})));
                                }
                            }
                            if (n3 == 0) {
                                hashSet.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)list3, this.getMessage("JMSBindingValidation.NO_MESSAGE_FOUND_IN_INPUT", new Object[]{bindingOperation.getName(), list3.getName()})));
                            }
                            if ((iterator3 = list3.getExtensibilityElements(JMSProperties.class)) != null && iterator3.size() > 0) {
                                hashSet.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)list3, this.getMessage("JMSBindingValidation.INVALID_USAGE_OF_JMS_PROPERITES_ELEM", new Object[]{bindingOperation.getName(), list3.getName()})));
                            }
                            if ((object3 = list3.getExtensibilityElements(JMSMapMessage.class)) != null && object3.size() > 0) {
                                hashSet.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)list3, this.getMessage("JMSBindingValidation.INVALID_USAGE_OF_JMS_MAPMESSAGE_ELEM", new Object[]{bindingOperation.getName(), list3.getName()})));
                            }
                        }
                        if ((object4 = bindingOperation.getBindingOutput()) != null) {
                            List list;
                            n3 = 0;
                            iterator3 = object4.getExtensibilityElements(JMSMessage.class).iterator();
                            if (iterator3 != null) {
                                while (iterator3.hasNext()) {
                                    ++n3;
                                    object3 = (JMSMessage)iterator3.next();
                                    this.validate(bindingOperation, (OperationParameter)object4.getOutput().get(), (JMSMessage)object3);
                                }
                                if (n3 > 1) {
                                    hashSet.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)object4, this.getMessage("JMSBindingValidation.ATMOST_ONE_MESSAGE_IN_OUTPUT", new Object[]{bindingOperation.getName(), new Integer(n3), object4.getName()})));
                                }
                            }
                            if (n3 == 0) {
                                hashSet.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)object4, this.getMessage("JMSBindingValidation.NO_MESSAGE_FOUND_IN_OUTPUT", new Object[]{bindingOperation.getName(), object4.getName()})));
                            }
                            if ((object3 = object4.getExtensibilityElements(JMSProperties.class)) != null && object3.size() > 0) {
                                hashSet.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)object4, this.getMessage("JMSBindingValidation.INVALID_USAGE_OF_JMS_PROPERITES_ELEM", new Object[]{bindingOperation.getName(), object4.getName()})));
                            }
                            if ((list = object4.getExtensibilityElements(JMSMapMessage.class)) != null && list.size() > 0) {
                                hashSet.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)object4, this.getMessage("JMSBindingValidation.INVALID_USAGE_OF_JMS_MAPMESSAGE_ELEM", new Object[]{bindingOperation.getName(), object4.getName()})));
                            }
                        }
                    }
                    if ((list3 = bindingOperation.getExtensibilityElements(JMSOptions.class)).size() <= 0) continue;
                    hashSet.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)list3.get(0), this.getMessage("JMSBindingValidation.IMPROPER_USAGE_OF_OPTIONS", new Object[]{binding.getName(), list3.size()})));
                }
                if (n2 > 0 && n == 0) {
                    hashSet.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)binding, this.getMessage("JMSBindingValidation.MISSING_JMS_OPERATION", new Object[]{binding.getName()})));
                }
                if (n2 != 0 || n == 0) continue;
                hashSet.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)binding, this.getMessage("JMSBindingValidation.JMS_OPERATION_WO_JMS_BINDING", new Object[]{binding.getName()})));
            }
        }
        this.mValidation = null;
        this.mValidationType = null;
        return this.mValidationResult;
    }

    private void validate(JMSAddress jMSAddress) {
        Collection collection = this.mValidationResult.getValidationResult();
        StringTokenizer stringTokenizer = new StringTokenizer(jMSAddress.getConnectionURL(), ",");
        while (stringTokenizer.hasMoreTokens()) {
            int n;
            String string = stringTokenizer.nextToken();
            if (this.isAToken(string, jMSAddress)) continue;
            UrlParser urlParser = new UrlParser(string);
            String string2 = null;
            String string3 = null;
            int n2 = n = -291;
            try {
                List list;
                Object object;
                Object object2;
                string2 = urlParser.getProtocol();
                string3 = urlParser.getHost();
                n2 = urlParser.getPort();
                if (string2 == null || string2.length() == 0) {
                    collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)jMSAddress, this.getMessage("JMSAddress.NO_PROTOCOL_SPECIFIED", new Object[]{string})));
                } else if (string2.equals("mq")) {
                    try {
                        object2 = new SunOneUrlParser(string);
                        ((SunOneUrlParser)object2).validate();
                    }
                    catch (ValidationException validationException) {
                        collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)jMSAddress, this.getMessage("JMSAddress.INVALID_CONNECTION_URL", new Object[]{string, validationException})));
                    }
                } else if (!(string2.equals("wmq") || string2.equals("jnp") || string2.equals("stcms") || string2.equals("tcp") || string2.equals("t3") || string2.equals("jndi"))) {
                    collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)jMSAddress, this.getMessage("JMSAddress.PROVIDER_NOT_SUPPORTED", new Object[]{string, string2})));
                }
                if (!string2.equals("jndi")) {
                    if (string3 == null || string3.length() == 0) {
                        collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)jMSAddress, this.getMessage("JMSAddress.NO_HOST_SPECIFIED", new Object[]{string})));
                    }
                    if (n2 == n) {
                        collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)jMSAddress, this.getMessage("JMSAddress.NO_PORT_SPECIFIED", new Object[]{string})));
                    } else if (n2 <= 0) {
                        collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)jMSAddress, this.getMessage("JMSAddress.INVALID_PORT_SPECIFIED", new Object[]{string, new Integer(n2)})));
                    }
                    object2 = jMSAddress.getUsername();
                    if (object2 != null) {
                        this.isAToken((String)object2, jMSAddress);
                        object = jMSAddress.getPassword();
                        if (object == null) {
                            collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)jMSAddress, this.getMessage("JMSAddress.MISSING_PASSWORD", new Object[]{object2})));
                        } else {
                            this.isAToken((String)object, jMSAddress);
                        }
                    }
                    if (jMSAddress.getConnectionFactoryName() != null) {
                        collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.WARNING, (Component)jMSAddress, this.getMessage("JMSAddress.JNDI_CF_NAME_IN_JMS_ADDRESS_IGNORED", new Object[]{string, jMSAddress.getConnectionFactoryName()})));
                    }
                    if (jMSAddress.getInitialContextFactory() != null) {
                        collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.WARNING, (Component)jMSAddress, this.getMessage("JMSAddress.JNDI_INIT_CTX_FACT_IN_JMS_ADDRESS_IGNORED", new Object[]{string, jMSAddress.getInitialContextFactory()})));
                    }
                    if (jMSAddress.getProviderURL() != null) {
                        collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.WARNING, (Component)jMSAddress, this.getMessage("JMSAddress.JNDI_PROVIDER_URL_IN_JMS_ADDRESS_IGNORED", new Object[]{string, jMSAddress.getProviderURL()})));
                    }
                    if (jMSAddress.getSecurityPrincial() != null) {
                        collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.WARNING, (Component)jMSAddress, this.getMessage("JMSAddress.JNDI_SEC_PRINCIPAL_IN_JMS_ADDRESS_IGNORED", new Object[]{string, jMSAddress.getSecurityPrincial()})));
                    }
                    if (jMSAddress.getSecurityCredentials() != null) {
                        collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.WARNING, (Component)jMSAddress, this.getMessage("JMSAddress.JNDI_SEC_CREDENTIALS_IN_JMS_ADDRESS_IGNORED", new Object[]{string, jMSAddress.getSecurityCredentials()})));
                    }
                    if ((object = jMSAddress.getExtensibilityElements(JMSJNDIEnv.class)).size() <= 0) continue;
                    collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.WARNING, (Component)jMSAddress, this.getMessage("JMSAddress.JNDIENV_ELEM_IN_JMS_ADDRESS_IGNORED", new Object[]{string})));
                    continue;
                }
                if (jMSAddress.getConnectionFactoryName() == null) {
                    collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)jMSAddress, this.getMessage("JMSAddress.JNDI_CONNECTION_FACTORY_NAME_UNDEFINED", new Object[]{string})));
                }
                if (jMSAddress.getInitialContextFactory() != null && jMSAddress.getProviderURL() == null) {
                    collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)jMSAddress, this.getMessage("JMSAddress.JNDI_PROVIDER_URL_UNDEFINED", new Object[]{string, jMSAddress.getInitialContextFactory()})));
                }
                if ((object2 = jMSAddress.getSecurityPrincial()) != null) {
                    this.isAToken((String)object2, jMSAddress);
                    object = jMSAddress.getSecurityCredentials();
                    if (object == null) {
                        collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)jMSAddress, this.getMessage("JMSAddress.MISSING_JNDI_SECURITY_CREDENTIALS", new Object[]{object2})));
                    } else {
                        this.isAToken((String)object, jMSAddress);
                    }
                }
                if ((object = jMSAddress.getExtensibilityElements(JMSJNDIEnv.class)).size() > 1) {
                    collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)jMSAddress, this.getMessage("JMSAddress.ATMOST_ONE_JNDIENV_ELEM_IN_JMS_ADDRESS", new Object[]{object.size()})));
                }
                if (object.size() == 1 && (list = ((JMSJNDIEnv)object.get(0)).getExtensibilityElements(JMSJNDIEnvEntry.class)).size() == 0) {
                    collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)object.get(0), this.getMessage("JMSAddress.MISSING_JNDIENVENTRY_ELEMS_IN_JMS_JNDIENV", new Object[]{jMSAddress.getConnectionURL()})));
                }
                if ((list = jMSAddress.getExtensibilityElements(JMSJNDIEnvEntry.class)).size() <= 0) continue;
                collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)jMSAddress, this.getMessage("JMSAddress.IMPROPER_USAGE_OF_JNDIENVENTRY", new Object[]{list.size()})));
            }
            catch (Throwable throwable) {
                collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)jMSAddress, this.getMessage("JMSAddress.INVALID_CONNECTION_URL", new Object[]{string, throwable.getLocalizedMessage()})));
            }
        }
    }

    private void validate(JMSBinding jMSBinding) {
    }

    private void validate(BindingOperation bindingOperation, JMSOperation jMSOperation) {
        List list;
        List list2;
        int n;
        String string;
        String string2;
        boolean bl;
        Collection collection = this.mValidationResult.getValidationResult();
        String string3 = "in-only";
        boolean bl2 = bindingOperation.getBindingInput() != null;
        boolean bl3 = bl = bindingOperation.getBindingOutput() != null;
        if (bl2 && bl) {
            string3 = "in-out";
        }
        String string4 = jMSOperation.getDestination();
        this.isAToken(string4, jMSOperation);
        String string5 = jMSOperation.getDestinationType();
        if (string4 == null && string4.length() == 0) {
            collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)jMSOperation, this.getMessage("JMSOperation.EMPTY_DESTINATION_EMPTY", new Object[]{bindingOperation.getName()})));
        }
        if ((string2 = jMSOperation.getSubscriptionDurability()) != null && string2.equals("Durable")) {
            String string6 = jMSOperation.getSubscriptionName();
            if (string6 == null || string6.length() == 0) {
                collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)jMSOperation, this.getMessage("JMSOperation.DURABLE_SUBSCRIBER_BUT_NO_SUBSCRIPTION_NAME", new Object[]{bindingOperation.getName()})));
            }
            this.isAToken(string6, jMSOperation);
            if (string5.equals("Queue")) {
                collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)jMSOperation, this.getMessage("JMSOperation.DURABLE_SUBSCRIBER_BUT_DESTINATION_TYPE_IS_QUEUE", new Object[]{bindingOperation.getName()})));
            }
            if ((string = jMSOperation.getClientID()) == null || string.length() == 0) {
                collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.WARNING, (Component)jMSOperation, this.getMessage("JMSOperation.DURABLE_SUBSCRIBER_BUT_NO_CLIENT_ID", new Object[]{bindingOperation.getName()})));
            }
            this.isAToken(string, jMSOperation);
        }
        if ((n = jMSOperation.getMaxConcurrentConsumers()) > 1 && string5.equals("Topic")) {
            collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.WARNING, (Component)jMSOperation, this.getMessage("JMSOperation.MAX_CONCURRENT_CONSUMERS_SUPPORTED_FOR_TOPICS", new Object[]{bindingOperation.getName(), n})));
        }
        if ((string = jMSOperation.getRedeliveryHandling()) != null && string.length() > 0 && !this.isAToken(string, jMSOperation)) {
            try {
                RedeliveryHandlingParser.parse(string, "none", "Queue");
            }
            catch (Throwable throwable) {
                collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)jMSOperation, this.getMessage("JMSOperation.INVALID_REDELIVERY_HANDLING_ACTIONS", new Object[]{bindingOperation.getName(), string, throwable.getLocalizedMessage()})));
            }
        }
        if ((list2 = jMSOperation.getExtensibilityElements(JMSOptions.class)).size() > 1) {
            collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)jMSOperation, this.getMessage("JMSOperation.ATMOST_ONE_OPTIONS_ELEM_IN_JMS_OPERATION", new Object[]{bindingOperation.getName(), list2.size()})));
        }
        if ((list = jMSOperation.getExtensibilityElements(JMSOption.class)).size() > 0) {
            collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)list.get(0), this.getMessage("JMSOperation.IMPROPER_USAGE_OF_OPTION", new Object[]{bindingOperation.getName(), list.size()})));
        }
    }

    private void validate(BindingOperation bindingOperation, OperationParameter operationParameter, JMSMessage jMSMessage) {
        String string;
        Object object;
        Object object2;
        Object object3;
        Iterator iterator;
        Object object4;
        Object object5;
        Object object6;
        Collection collection;
        block62: {
            String string2;
            block63: {
                block61: {
                    collection = this.mValidationResult.getValidationResult();
                    string2 = jMSMessage.getMessageType();
                    if (!string2.equals("TextMessage")) break block61;
                    object6 = jMSMessage.getTextPart();
                    if (object6 == null || ((String)object6).length() == 0) {
                        collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)jMSMessage, this.getMessage("JMSMessage.TEXT_MESSAGE_TEXTPART_NOT_SPECIFIED", new Object[]{bindingOperation.getName(), operationParameter instanceof Input ? "input" : "output", operationParameter.getName()})));
                    } else if (!this.referencesValidMessagePart((NamedComponentReference<Message>)operationParameter.getMessage(), (String)object6)) {
                        collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)jMSMessage, this.getMessage("JMSMessage.TEXT_PART_REFERENCES_NON_EXISTENT_PART", new Object[]{bindingOperation.getName(), operationParameter instanceof Input ? "input" : "output", operationParameter.getName(), object6, operationParameter.getMessage().getQName()})));
                    }
                    object5 = jMSMessage.getExtensibilityElements(JMSMapMessage.class);
                    if (object5.size() > 0) {
                        collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)object5.iterator().next(), this.getMessage("JMSMessage.TEXT_MESSAGE_CANNOT_HAVE_MAPMESSAGE_ELEM", new Object[]{bindingOperation.getName(), operationParameter instanceof Input ? "input" : "output", operationParameter.getName()})));
                    }
                    if ((object4 = jMSMessage.getUse()) != null && ((String)object4).length() > 0) {
                        iterator = jMSMessage.getJMSEncodingStyle();
                        if (((String)object4).equals("encoded")) {
                            if (iterator == null || ((String)((Object)iterator)).length() == 0) {
                                collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)jMSMessage, this.getMessage("JMSMessage.ENCODING_STYLE_NOT_SPECIFIED", new Object[]{bindingOperation.getName(), operationParameter instanceof Input ? "input" : "output", operationParameter.getName()})));
                            }
                        } else if (iterator != null && ((String)((Object)iterator)).length() > 0) {
                            collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)jMSMessage, this.getMessage("JMSMessage.ENCODING_STYLE_INVALID_USE", new Object[]{bindingOperation.getName(), operationParameter instanceof Input ? "input" : "output", operationParameter.getName(), iterator})));
                        }
                    }
                    break block62;
                }
                if (!string2.equals("MapMessage")) break block63;
                object6 = jMSMessage.getTextPart();
                if (object6 != null && ((String)object6).length() > 0) {
                    collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)jMSMessage, this.getMessage("JMSMessage.MAP_MESSAGE_CANNOT_HAVE_TEXTPART_ATTR", new Object[]{bindingOperation.getName(), operationParameter instanceof Input ? "input" : "output", operationParameter.getName()})));
                }
                if ((object5 = jMSMessage.getUse()) != null && ((String)object5).length() > 0) {
                    collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.WARNING, (Component)jMSMessage, this.getMessage("JMSMessage.USE_IGNORED", new Object[]{bindingOperation.getName(), operationParameter instanceof Input ? "input" : "output", operationParameter.getName(), object5})));
                }
                object4 = jMSMessage.getExtensibilityElements(JMSMapMessage.class);
                block0 : switch (object4.size()) {
                    case 0: {
                        collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)jMSMessage, this.getMessage("JMSMessage.MISSING_MAPMESSAGE_ELEM_IN_JMS_MESSAGE", new Object[]{bindingOperation.getName(), operationParameter instanceof Input ? "input" : "output", operationParameter.getName()})));
                        break;
                    }
                    case 1: {
                        iterator = (JMSMapMessage)object4.iterator().next();
                        object3 = iterator.getMapMessageParts();
                        switch (object3.size()) {
                            case 0: {
                                collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, iterator, this.getMessage("JMSMessage.EMPTY_MAPMESSAGE_PARTS", new Object[]{bindingOperation.getName(), operationParameter instanceof Input ? "input" : "output", operationParameter.getName()})));
                                break block0;
                            }
                        }
                        object2 = object3.iterator();
                        while (object2.hasNext()) {
                            object = object2.next();
                            string = object.getName();
                            String string3 = object.getType();
                            String string4 = object.getPart();
                            if (string == null || string.length() == 0) {
                                collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)object, this.getMessage("JMSMessage.EMTPY_MAPPART_NAME", new Object[]{bindingOperation.getName(), operationParameter instanceof Input ? "input" : "output", operationParameter.getName()})));
                            }
                            if (string3 == null || string3.length() == 0) {
                                collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)object, this.getMessage("JMSMessage.EMTPY_MAPPART_TYPE", new Object[]{bindingOperation.getName(), operationParameter instanceof Input ? "input" : "output", operationParameter.getName()})));
                            }
                            if (string4 == null || string4.length() == 0) {
                                collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)object, this.getMessage("JMSMessage.EMTPY_MAPPART_PART", new Object[]{bindingOperation.getName(), operationParameter instanceof Input ? "input" : "output", operationParameter.getName()})));
                                continue;
                            }
                            if (this.referencesValidMessagePart((NamedComponentReference<Message>)operationParameter.getMessage(), string4)) continue;
                            collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)object, this.getMessage("JMSMessage.MAPPART_PART_REFERENCES_NON_EXISTENT_PART", new Object[]{bindingOperation.getName(), operationParameter instanceof Input ? "input" : "output", operationParameter.getName(), string4, operationParameter.getMessage().getQName()})));
                        }
                        break block62;
                    }
                    default: {
                        collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)jMSMessage, this.getMessage("JMSMessage.ATMOST_ONE_MAPMESSAGE_ELEM_IN_JMS_MESSAGE", new Object[]{bindingOperation.getName(), operationParameter instanceof Input ? "input" : "output", operationParameter.getName(), object4.size()})));
                    }
                }
                break block62;
            }
            collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)jMSMessage, this.getMessage("JMSMessage.MESSAGE_TYPE_IS_NOT_SUPPORTED", new Object[]{bindingOperation.getName(), operationParameter instanceof Input ? "input" : "output", operationParameter.getName(), string2})));
        }
        object6 = jMSMessage.getExtensibilityElements(JMSProperties.class);
        block7 : switch (object6.size()) {
            case 0: {
                break;
            }
            case 1: {
                object5 = (JMSProperties)object6.iterator().next();
                object4 = object5.getProperties();
                switch (object4.size()) {
                    case 0: {
                        collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)object5, this.getMessage("JMSMessage.EMPTY_PROPERTIES_PARTS", new Object[]{bindingOperation.getName(), operationParameter instanceof Input ? "input" : "output", operationParameter.getName()})));
                        break block7;
                    }
                }
                iterator = object4.iterator();
                while (iterator.hasNext()) {
                    object3 = (JMSProperty)iterator.next();
                    object2 = object3.getName();
                    object = object3.getType();
                    string = object3.getPart();
                    if (object2 == null || ((String)object2).length() == 0) {
                        collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)object3, this.getMessage("JMSMessage.EMTPY_PROPERTY_NAME", new Object[]{bindingOperation.getName(), operationParameter instanceof Input ? "input" : "output", operationParameter.getName()})));
                    }
                    if (object == null || ((String)object).length() == 0) {
                        collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)object3, this.getMessage("JMSMessage.EMTPY_PROPERTY_TYPE", new Object[]{bindingOperation.getName(), operationParameter instanceof Input ? "input" : "output", operationParameter.getName()})));
                    }
                    if (string == null || string.length() == 0) {
                        collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)object3, this.getMessage("JMSMessage.EMTPY_PROPERTY_PART", new Object[]{bindingOperation.getName(), operationParameter instanceof Input ? "input" : "output", operationParameter.getName()})));
                        continue;
                    }
                    if (this.referencesValidMessagePart((NamedComponentReference<Message>)operationParameter.getMessage(), string)) continue;
                    collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)object3, this.getMessage("JMSMessage.PROPERTY_PART_REFERENCES_NON_EXISTENT_PART", new Object[]{bindingOperation.getName(), operationParameter instanceof Input ? "input" : "output", operationParameter.getName(), string, operationParameter.getMessage().getQName()})));
                }
                break;
            }
            default: {
                collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)jMSMessage, this.getMessage("JMSMessage.ATMOST_ONE_PROPERTIES_ELEM_IN_JMS_MESSAGE", new Object[]{bindingOperation.getName(), operationParameter instanceof Input ? "input" : "output", operationParameter.getName(), object6.size()})));
            }
        }
        object5 = jMSMessage.getCorrelationIdPart();
        if (object5 != null) {
            if (((String)object5).length() == 0) {
                collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)jMSMessage, this.getMessage("JMSMessage.EMTPY_CORRELATIONID_PART", new Object[]{bindingOperation.getName(), operationParameter instanceof Input ? "input" : "output", operationParameter.getName()})));
            } else if (!this.referencesValidMessagePart((NamedComponentReference<Message>)operationParameter.getMessage(), (String)object5)) {
                collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)jMSMessage, this.getMessage("JMSMessage.CORRELATIONID_PART_REFERENCES_NON_EXISTENT_PART", new Object[]{bindingOperation.getName(), operationParameter instanceof Input ? "input" : "output", operationParameter.getName(), object5, operationParameter.getMessage().getQName()})));
            }
        }
        if ((object4 = jMSMessage.getDeliveryModePart()) != null) {
            if (((String)object4).length() == 0) {
                collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)jMSMessage, this.getMessage("JMSMessage.EMTPY_DELIVERYMODE_PART", new Object[]{bindingOperation.getName(), operationParameter instanceof Input ? "input" : "output", operationParameter.getName()})));
            } else if (!this.referencesValidMessagePart((NamedComponentReference<Message>)operationParameter.getMessage(), (String)object4)) {
                collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)jMSMessage, this.getMessage("JMSMessage.DELIVERYMODE_PART_REFERENCES_NON_EXISTENT_PART", new Object[]{bindingOperation.getName(), operationParameter instanceof Input ? "input" : "output", operationParameter.getName(), object4, operationParameter.getMessage().getQName()})));
            }
        }
        if ((iterator = jMSMessage.getPriorityPart()) != null) {
            if (((String)((Object)iterator)).length() == 0) {
                collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)jMSMessage, this.getMessage("JMSMessage.EMTPY_PRIORITY_PART", new Object[]{bindingOperation.getName(), operationParameter instanceof Input ? "input" : "output", operationParameter.getName()})));
            } else if (!this.referencesValidMessagePart((NamedComponentReference<Message>)operationParameter.getMessage(), (String)((Object)iterator))) {
                collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)jMSMessage, this.getMessage("JMSMessage.PRIORITY_PART_REFERENCES_NON_EXISTENT_PART", new Object[]{bindingOperation.getName(), operationParameter instanceof Input ? "input" : "output", operationParameter.getName(), iterator, operationParameter.getMessage().getQName()})));
            }
        }
        if ((object3 = jMSMessage.getTypePart()) != null) {
            if (((String)object3).length() == 0) {
                collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)jMSMessage, this.getMessage("JMSMessage.EMTPY_TYPE_PART", new Object[]{bindingOperation.getName(), operationParameter instanceof Input ? "input" : "output", operationParameter.getName()})));
            } else if (!this.referencesValidMessagePart((NamedComponentReference<Message>)operationParameter.getMessage(), (String)object3)) {
                collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)jMSMessage, this.getMessage("JMSMessage.TYPE_PART_REFERENCES_NON_EXISTENT_PART", new Object[]{bindingOperation.getName(), operationParameter instanceof Input ? "input" : "output", operationParameter.getName(), object3, operationParameter.getMessage().getQName()})));
            }
        }
        if ((object2 = jMSMessage.getMessageIDPart()) != null) {
            if (((String)object2).length() == 0) {
                collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)jMSMessage, this.getMessage("JMSMessage.EMTPY_MESSAGEID_PART", new Object[]{bindingOperation.getName(), operationParameter instanceof Input ? "input" : "output", operationParameter.getName()})));
            } else if (!this.referencesValidMessagePart((NamedComponentReference<Message>)operationParameter.getMessage(), (String)object2)) {
                collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)jMSMessage, this.getMessage("JMSMessage.MESSAGEID_PART_REFERENCES_NON_EXISTENT_PART", new Object[]{bindingOperation.getName(), operationParameter instanceof Input ? "input" : "output", operationParameter.getName(), object2, operationParameter.getMessage().getQName()})));
            }
        }
        if ((object = jMSMessage.getRedeliveredPart()) != null) {
            if (((String)object).length() == 0) {
                collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)jMSMessage, this.getMessage("JMSMessage.EMTPY_REDELIVERED_PART", new Object[]{bindingOperation.getName(), operationParameter instanceof Input ? "input" : "output", operationParameter.getName()})));
            } else if (!this.referencesValidMessagePart((NamedComponentReference<Message>)operationParameter.getMessage(), (String)object)) {
                collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)jMSMessage, this.getMessage("JMSMessage.REDELIVERED_PART_REFERENCES_NON_EXISTENT_PART", new Object[]{bindingOperation.getName(), operationParameter instanceof Input ? "input" : "output", operationParameter.getName(), object, operationParameter.getMessage().getQName()})));
            }
        }
        if ((string = jMSMessage.getTimestampPart()) != null) {
            if (string.length() == 0) {
                collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)jMSMessage, this.getMessage("JMSMessage.EMTPY_TIMESTAMP_PART", new Object[]{bindingOperation.getName(), operationParameter instanceof Input ? "input" : "output", operationParameter.getName()})));
            } else if (!this.referencesValidMessagePart((NamedComponentReference<Message>)operationParameter.getMessage(), string)) {
                collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)jMSMessage, this.getMessage("JMSMessage.TIMESTAMP_PART_REFERENCES_NON_EXISTENT_PART", new Object[]{bindingOperation.getName(), operationParameter instanceof Input ? "input" : "output", operationParameter.getName(), string, operationParameter.getMessage().getQName()})));
            }
        }
    }

    private boolean checkSignature(BindingOperation bindingOperation) {
        boolean bl = true;
        Reference reference = bindingOperation.getOperation();
        if (reference == null) {
            return false;
        }
        Operation operation = (Operation)reference.get();
        if (operation == null) {
            return false;
        }
        if (!(operation.getInput() == null && bindingOperation.getBindingInput() == null || operation.getInput() != null && bindingOperation.getBindingInput() != null)) {
            bl = false;
        }
        if (!(operation.getOutput() == null && bindingOperation.getBindingOutput() == null || operation.getOutput() != null && bindingOperation.getBindingOutput() != null)) {
            bl = false;
        }
        return bl;
    }

    private boolean referencesValidMessagePart(NamedComponentReference<Message> namedComponentReference, String string) {
        if (namedComponentReference == null || namedComponentReference.get() == null || ((Message)namedComponentReference.get()).getParts() == null) {
            return true;
        }
        boolean bl = false;
        for (Part part : ((Message)namedComponentReference.get()).getParts()) {
            if (!part.getName().equals(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean isAToken(String string, JMSComponent jMSComponent) {
        Collection collection = this.mValidationResult.getValidationResult();
        boolean bl = false;
        if (string != null && string.startsWith("${")) {
            bl = true;
            if (!string.endsWith("}")) {
                collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)jMSComponent, this.getMessage("JMSComponentValidator.INVALID_ENVIRONMENT_TOKEN_NAME", new Object[]{string})));
            }
        }
        return bl;
    }

    private String getMessage(String string, String string2) {
        return this.getMessage(string, new Object[]{string2});
    }

    private String getMessage(String string, Object[] objectArray) {
        String string2 = mMessages.getString(string);
        if (objectArray != null) {
            return MessageFormat.format(string2, objectArray);
        }
        return string2;
    }
}

