/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.editor;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.editor.Utilities;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.util.ImageUtilities;

public class PPVariableCompletionItem
implements CompletionItem {
    private final String varName;
    private final String varDesc;
    private static ImageIcon icon;
    private String leftText;

    PPVariableCompletionItem(String string, String string2) {
        this.varName = string;
        this.varDesc = string2;
    }

    public void defaultAction(JTextComponent jTextComponent) {
        this.substitute(jTextComponent, this.varName);
        Completion.get().hideAll();
    }

    private void substitute(JTextComponent jTextComponent, String string) {
        int n = jTextComponent.getCaret().getDot();
        Document document = jTextComponent.getDocument();
        try {
            int n2 = Utilities.getWordStart((JTextComponent)jTextComponent, (int)n);
            int n3 = Utilities.getWordEnd((JTextComponent)jTextComponent, (int)n);
            if (n2 > 0) {
                String string2 = document.getText(n2, n3 - n2);
                if ("()".equals(string2) || "(".equals(string2)) {
                    document.insertString(n2 + 1, string, null);
                } else if (")".equals(string2)) {
                    document.insertString(n2, string, null);
                } else {
                    document.remove(n2, string2.length());
                    document.insertString(n2, string, null);
                }
            } else {
                document.insertString(n, string, null);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void processKeyEvent(KeyEvent keyEvent) {
    }

    public int getPreferredWidth(Graphics graphics, Font font) {
        return CompletionUtilities.getPreferredWidth((String)this.getLeftText(), (String)this.getRightText(), (Graphics)graphics, (Font)font);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Graphics graphics, Font font, Color color, Color color2, int n, int n2, boolean bl) {
        PPVariableCompletionItem pPVariableCompletionItem = this;
        synchronized (pPVariableCompletionItem) {
            if (icon == null) {
                icon = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/mobility/editor/resources/v.png"));
            }
        }
        if (bl) {
            graphics.setColor(color2);
            graphics.fillRect(0, 0, n, n2);
            graphics.setColor(color);
        }
        CompletionUtilities.renderHtml((ImageIcon)icon, (String)this.getLeftText(), (String)this.getRightText(), (Graphics)graphics, (Font)font, (Color)color, (int)n, (int)n2, (boolean)bl);
    }

    public CompletionTask createDocumentationTask() {
        return null;
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public boolean instantSubstitution(JTextComponent jTextComponent) {
        return false;
    }

    public int getSortPriority() {
        return 50;
    }

    public CharSequence getSortText() {
        return this.varName;
    }

    private String getLeftText() {
        if (this.leftText == null) {
            this.leftText = "<b>" + PPVariableCompletionItem.toHtmlText(this.varName) + "</b>  ";
        }
        return this.leftText;
    }

    private String getRightText() {
        return PPVariableCompletionItem.toHtmlText(this.varDesc);
    }

    private static String toHtmlText(String string) {
        StringBuffer stringBuffer = null;
        for (int i = 0; i < string.length(); ++i) {
            String string2;
            char c = string.charAt(i);
            switch (c) {
                case '\n': {
                    string2 = "<br>";
                    break;
                }
                default: {
                    string2 = null;
                }
            }
            if (string2 != null) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(120 * string.length() / 100);
                    if (i > 0) {
                        stringBuffer.append(string.substring(0, i));
                    }
                }
                stringBuffer.append(string2);
                continue;
            }
            if (stringBuffer == null) continue;
            stringBuffer.append(c);
        }
        return stringBuffer != null ? stringBuffer.toString() : string;
    }

    public CharSequence getInsertPrefix() {
        return this.varName;
    }
}

