/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.editor;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JEditorPane;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.project.Project;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.mobility.antext.preprocessor.CommentingPreProcessor;
import org.netbeans.mobility.antext.preprocessor.PPBlockInfo;
import org.netbeans.mobility.antext.preprocessor.PPLine;
import org.netbeans.mobility.antext.preprocessor.PPToken;
import org.netbeans.mobility.antext.preprocessor.PreprocessorException;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.mobility.editor.ConfigurationHighlightsLayerFactory;
import org.netbeans.modules.mobility.editor.hints.DisableHint;
import org.netbeans.modules.mobility.editor.hints.InlineIncludeHint;
import org.netbeans.modules.mobility.editor.hints.ReplaceOldSyntaxHint;
import org.netbeans.modules.mobility.project.J2MEProjectUtils;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.netbeans.modules.mobility.project.bridge.J2MEProjectUtilitiesProvider;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.HintsController;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class J2MEEditorDocument
extends NbEditorDocument {
    public static final String PREPROCESSOR_LINE_LIST = "preprocessor.line.list";
    static final long serialVersionUID = 4863325941230276217L;
    static final Pattern BLOCK_HEADER_PATTERN = Pattern.compile("^\\s*/((/#)|(\\*[\\$#]))\\S");
    protected ArrayList<PPLine> lineList = new ArrayList();
    DocumentListener dl;
    Timer timer;

    public J2MEEditorDocument(String string) {
        super(string);
        J2MEEditorDocument.updateBlockChain((Document)((Object)this));
        this.dl = new DL();
        this.addDocumentListener(this.dl);
        this.getDocumentProperties().put("TEXT_SWITCH_SUPPORT", new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                J2MEEditorDocument.updateBlockChain((Document)((Object)J2MEEditorDocument.this));
            }
        });
    }

    final void setLineList(ArrayList<PPLine> arrayList) {
        ConfigurationHighlightsLayerFactory.Highlighting highlighting;
        this.lineList = arrayList;
        this.putProperty(PREPROCESSOR_LINE_LIST, arrayList);
        ConfigurationHighlightsLayerFactory.Highlighting highlighting2 = (ConfigurationHighlightsLayerFactory.Highlighting)this.getProperty(ConfigurationHighlightsLayerFactory.PROP_HIGLIGHT_HEADER_LAYER);
        if (highlighting2 != null) {
            highlighting2.updateBags();
        }
        if ((highlighting = (ConfigurationHighlightsLayerFactory.Highlighting)this.getProperty(ConfigurationHighlightsLayerFactory.PROP_HIGLIGHT_BLOCKS_LAYER)) != null) {
            highlighting.updateBags();
        }
        this.processAnnotations();
    }

    void restartTimer() {
        if (this.timer == null) {
            this.timer = new Timer(200, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    J2MEEditorDocument.updateBlockChain((Document)((Object)J2MEEditorDocument.this));
                }
            });
            this.timer.setRepeats(false);
        }
        this.timer.restart();
    }

    public static final void updateBlockChain(Document document) {
        Project project;
        if (document instanceof J2MEEditorDocument && (project = J2MEProjectUtils.getProjectForDocument((Document)document)) != null) {
            ProjectConfigurationsHelper projectConfigurationsHelper = (ProjectConfigurationsHelper)project.getLookup().lookup(ProjectConfigurationsHelper.class);
            if (projectConfigurationsHelper == null || !projectConfigurationsHelper.isPreprocessorOn()) {
                return;
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>(projectConfigurationsHelper.getActiveAbilities());
            hashMap.put(projectConfigurationsHelper.getActiveConfiguration().getDisplayName(), null);
            try {
                J2MEProjectUtilitiesProvider j2MEProjectUtilitiesProvider = (J2MEProjectUtilitiesProvider)Lookup.getDefault().lookup(J2MEProjectUtilitiesProvider.class);
                if (j2MEProjectUtilitiesProvider == null) {
                    return;
                }
                CommentingPreProcessor commentingPreProcessor = new CommentingPreProcessor(j2MEProjectUtilitiesProvider.createPPDocumentSource((StyledDocument)document), null, hashMap);
                commentingPreProcessor.run();
                ((J2MEEditorDocument)((Object)document)).setLineList(commentingPreProcessor.getLines());
            }
            catch (PreprocessorException preprocessorException) {
                ErrorManager.getDefault().notify((Throwable)preprocessorException);
            }
            J2MEEditorDocument.repaintDocument(document);
        }
    }

    public static void repaintDocument(Document document) {
        JEditorPane[] jEditorPaneArray;
        DataObject dataObject = NbEditorUtilities.getDataObject((Document)document);
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie != null && (jEditorPaneArray = editorCookie.getOpenedPanes()) != null) {
            for (int i = 0; i < jEditorPaneArray.length; ++i) {
                try {
                    if (jEditorPaneArray[0] == null) continue;
                    jEditorPaneArray[i].getUI().damageRange(jEditorPaneArray[i], 0, document.getLength() + 1);
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
    }

    static String prefixPropertyName(String string, String string2) {
        return "configs." + string + '.' + string2;
    }

    void processAnnotations() {
        ArrayList<ErrorDescription> arrayList = new ArrayList<ErrorDescription>();
        DataObject dataObject = NbEditorUtilities.getDataObject((Document)((Object)this));
        FileObject fileObject = dataObject == null ? null : dataObject.getPrimaryFile();
        for (PPLine pPLine : this.lineList) {
            PPToken pPToken;
            for (PPLine.Error error : pPLine.getErrors()) {
                pPToken = error.token;
                int n = pPToken.getType() == 257 || pPToken.getType() == 258 || pPToken.getType() == 300 ? Math.max(1, pPToken.getPadding().length()) : 0;
                int n2 = NbDocument.findLineOffset((StyledDocument)((Object)this), (int)(pPLine.getLineNumber() - 1));
                arrayList.add(ErrorDescriptionFactory.createErrorDescription((Severity)(error.warning ? Severity.WARNING : Severity.ERROR), (String)error.message, (FileObject)fileObject, (int)(n2 + pPToken.getColumn() - n), (int)(n2 + pPToken.getColumn() + pPToken.getText().length())));
            }
            ArrayList arrayList2 = new ArrayList();
            int n = Utilities.getRowStartFromLineOffset((BaseDocument)this, (int)(pPLine.getLineNumber() - 1));
            if (pPLine.getTokens().size() > 1 && "//#include".equals(((PPToken)pPLine.getTokens().get(0)).getText())) {
                arrayList2.add(new InlineIncludeHint((BaseDocument)this, n, ((PPToken)pPLine.getTokens().get(1)).getText()));
            } else if (pPLine.getType() == 13 || pPLine.getType() == 14) {
                for (pPToken = pPLine.getBlock(); pPToken != null && pPToken.getType() != 13; pPToken = pPToken.getParent()) {
                }
                if (pPToken != null) {
                    arrayList2.add(new ReplaceOldSyntaxHint((Document)((Object)this), this.lineList, (PPBlockInfo)pPToken));
                }
            }
            if (pPLine.getType() == -1) {
                arrayList2.add(new DisableHint((BaseDocument)this, n));
            }
            if (arrayList2.size() <= 0) continue;
            arrayList.add(ErrorDescriptionFactory.createErrorDescription((Severity)Severity.HINT, (String)NbBundle.getMessage(J2MEEditorDocument.class, (String)"LBL_PreprocessorHint"), (List)arrayList2, (Document)((Object)this), (int)pPLine.getLineNumber()));
        }
        HintsController.setErrors((Document)((Object)this), (String)"preprocessor-errors", arrayList);
    }

    class DL
    implements DocumentListener {
        DL() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            J2MEEditorDocument.this.restartTimer();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            J2MEEditorDocument.this.restartTimer();
        }
    }
}

