/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.trace;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.trace.NativeProjectProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraceModelBase {
    private boolean useCSysIncludes = Boolean.getBoolean("cnd.modelimpl.c.include");
    private boolean useCSysDefines = Boolean.getBoolean("cnd.modelimpl.c.define");
    private boolean useCppSysIncludes = Boolean.getBoolean("cnd.modelimpl.cpp.include");
    private boolean useCppSysDefines = Boolean.getBoolean("cnd.modelimpl.cpp.define");
    private ModelImpl model;
    private CsmUID<CsmProject> projectUID;
    private List<String> quoteIncludePaths = new ArrayList<String>();
    private List<String> systemIncludePaths = new ArrayList<String>();
    private List<File> files = new ArrayList<File>();
    private List<String> currentIncludePaths = null;
    private List<String> macros = new ArrayList<String>();
    private boolean pathsRelCurFile = false;

    public TraceModelBase() {
        Logger logger = Logger.getLogger("org.openide.loaders");
        logger.setLevel(Level.SEVERE);
        RepositoryUtils.cleanCashes();
        this.model = (ModelImpl)CsmModelAccessor.getModel();
        if (this.model == null) {
            this.model = new ModelImpl();
        }
        this.model.startup();
        this.currentIncludePaths = this.quoteIncludePaths;
    }

    protected final void setIncludePaths(List<String> list, List<String> list2) {
        this.quoteIncludePaths = list2;
        this.systemIncludePaths = list;
        this.currentIncludePaths = this.quoteIncludePaths;
    }

    protected final void shutdown() {
        this.waitModelTasks();
        this.model.shutdown();
        this.waitModelTasks();
        RepositoryUtils.cleanCashes();
    }

    private void waitModelTasks() {
        Cancellable cancellable = this.model.enqueueModelTask(new Runnable(){

            public void run() {
            }
        }, "wait finished other tasks");
        if (cancellable instanceof RequestProcessor.Task) {
            ((RequestProcessor.Task)cancellable).waitFinished();
        }
    }

    public void processArguments(String ... stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith("--")) {
                this.processFlag(stringArray[i].substring(2));
                continue;
            }
            if (stringArray[i].startsWith("-")) {
                ProcessFlagResult processFlagResult;
                for (int j = 1; j < stringArray[i].length() && (processFlagResult = this.processFlag(stringArray[i].charAt(j), stringArray[i].substring(j + 1))) != ProcessFlagResult.ALL_PROCESSED; ++j) {
                }
                continue;
            }
            this.addFile(this.files, new File(stringArray[i]));
        }
    }

    protected ProcessFlagResult processFlag(char c, String string) {
        ProcessFlagResult processFlagResult = ProcessFlagResult.CHAR_PROCESSED;
        switch (c) {
            case 'I': {
                if (string.length() <= 0) break;
                if (string.charAt(0) == '-') {
                    this.currentIncludePaths = this.currentIncludePaths == this.quoteIncludePaths ? this.systemIncludePaths : this.quoteIncludePaths;
                    string = string.substring(1);
                }
                String string2 = string;
                this.currentIncludePaths.add(string2);
                processFlagResult = ProcessFlagResult.ALL_PROCESSED;
                break;
            }
            case 'D': {
                this.macros.add(string);
                processFlagResult = ProcessFlagResult.ALL_PROCESSED;
                break;
            }
            default: {
                processFlagResult = ProcessFlagResult.NONE_PROCESSED;
            }
        }
        return processFlagResult;
    }

    protected boolean processFlag(String string) {
        if ("relpath".equals(string)) {
            this.pathsRelCurFile = true;
            return true;
        }
        return false;
    }

    private void addFile(List<File> list, File file) {
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                this.addFile(list, new File(file, stringArray[i]));
            }
        } else {
            list.add(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectBase getProject() {
        TraceModelBase traceModelBase = this;
        synchronized (traceModelBase) {
            if (this.projectUID == null) {
                this.projectUID = this.createProject().getUID();
            }
        }
        return this.projectUID == null ? null : (ProjectBase)this.projectUID.getObject();
    }

    public static void closeProject(CsmProject csmProject) {
        TraceModelBase.closeProject(csmProject, false);
    }

    public static void closeProject(CsmProject csmProject, boolean bl) {
        Object object = csmProject.getPlatformProject();
        ((ModelImpl)CsmModelAccessor.getModel()).closeProject(object, bl);
    }

    public void resetProject() {
        this.resetProject(false);
    }

    public void resetProject(boolean bl) {
        ProjectBase projectBase = this.getProject();
        if (projectBase != null) {
            TraceModelBase.closeProject(projectBase, bl);
        }
        this.projectUID = null;
    }

    private ProjectBase createProject() {
        NativeProject nativeProject = null;
        if (this.files.size() == 1 && this.files.get(0).getName().equals("project.xml")) {
            try {
                FileObject fileObject = FileUtil.toFileObject((File)this.files.get(0).getParentFile().getParentFile());
                Project project = ProjectManager.getDefault().findProject(fileObject);
                nativeProject = (NativeProject)project.getLookup().lookup(NativeProject.class);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(iOException);
            }
        } else {
            nativeProject = NativeProjectProvider.createProject("DummyProject", this.files, this.getSystemIncludes(), this.quoteIncludePaths, this.getSysMacros(), this.macros, this.pathsRelCurFile);
        }
        return this.model.addProject(nativeProject, nativeProject.getProjectDisplayName(), true);
    }

    protected List<String> getSystemIncludes() {
        HashSet<String> hashSet = new HashSet<String>(this.systemIncludePaths);
        if (this.useCppSysIncludes) {
            if ((Utilities.getOperatingSystem() & 8) != 0) {
                hashSet.add("/usr/sfw/lib/gcc/i386-pc-solaris2.10/3.4.3/../../../../include/c++/3.4.3");
                hashSet.add("/usr/sfw/lib/gcc/i386-pc-solaris2.10/3.4.3/../../../../include/c++/3.4.3/i386-pc-solaris2.10");
                hashSet.add("/usr/sfw/lib/gcc/i386-pc-solaris2.10/3.4.3/../../../../include/c++/3.4.3/backward");
                hashSet.add("/usr/local/include");
                hashSet.add("/usr/sfw/include");
                hashSet.add("/usr/sfw/lib/gcc/i386-pc-solaris2.10/3.4.3/include");
                hashSet.add("/usr/include");
            } else {
                hashSet.add("/usr/include/g++");
                hashSet.add("/usr/include/g++/i586-suse-linux");
                hashSet.add("/usr/include/g++/backward");
                hashSet.add("/usr/local/include");
                hashSet.add("/usr/lib/gcc-lib/i586-suse-linux/3.3.4/include");
                hashSet.add("/usr/i586-suse-linux/include");
                hashSet.add("/usr/include");
            }
        } else if (this.useCSysIncludes) {
            hashSet.add("/usr/local/include");
            hashSet.add("/usr/lib/gcc-lib/i586-suse-linux/3.3.4/include");
            hashSet.add("/usr/i586-suse-linux/include");
            hashSet.add("/usr/include");
        }
        return new ArrayList<String>(hashSet);
    }

    protected List<String> getSysMacros() {
        HashSet<String> hashSet = new HashSet<String>();
        if (this.useCppSysDefines) {
            if ((Utilities.getOperatingSystem() & 8) != 0) {
                hashSet.add("__DBL_MIN_EXP__=(-1021)");
                hashSet.add("__EXTENSIONS__=1");
                hashSet.add("__FLT_MIN__=1.17549435e-38F");
                hashSet.add("__CHAR_BIT__=8");
                hashSet.add("_XOPEN_SOURCE=500");
                hashSet.add("__WCHAR_MAX__=2147483647");
                hashSet.add("__DBL_DENORM_MIN__=4.9406564584124654e-324");
                hashSet.add("__FLT_EVAL_METHOD__=2");
                hashSet.add("__DBL_MIN_10_EXP__=(-307)");
                hashSet.add("__FINITE_MATH_ONLY__=0");
                hashSet.add("__GNUC_PATCHLEVEL__=3");
                hashSet.add("__SHRT_MAX__=32767");
                hashSet.add("__LDBL_MAX__=1.18973149535723176502e+4932L");
                hashSet.add("__unix=1");
                hashSet.add("__LDBL_MAX_EXP__=16384");
                hashSet.add("__SCHAR_MAX__=127");
                hashSet.add("__USER_LABEL_PREFIX__=");
                hashSet.add("__STDC_HOSTED__=1");
                hashSet.add("_LARGEFILE64_SOURCE=1");
                hashSet.add("__LDBL_HAS_INFINITY__=1");
                hashSet.add("__DBL_DIG__=15");
                hashSet.add("__FLT_EPSILON__=1.19209290e-7F");
                hashSet.add("__GXX_WEAK__=1");
                hashSet.add("__LDBL_MIN__=3.36210314311209350626e-4932L");
                hashSet.add("__unix__=1");
                hashSet.add("__DECIMAL_DIG__=21");
                hashSet.add("_LARGEFILE_SOURCE=1");
                hashSet.add("__LDBL_HAS_QUIET_NAN__=1");
                hashSet.add("__GNUC__=3");
                hashSet.add("__DBL_MAX__=1.7976931348623157e+308");
                hashSet.add("__DBL_HAS_INFINITY__=1");
                hashSet.add("__SVR4=1");
                hashSet.add("__cplusplus=1");
                hashSet.add("__DEPRECATED=1");
                hashSet.add("__DBL_MAX_EXP__=1024");
                hashSet.add("__GNUG__=3");
                hashSet.add("__LONG_LONG_MAX__=9223372036854775807LL");
                hashSet.add("__GXX_ABI_VERSION=1002");
                hashSet.add("__FLT_MIN_EXP__=(-125)");
                hashSet.add("__DBL_MIN__=2.2250738585072014e-308");
                hashSet.add("__FLT_MIN_10_EXP__=(-37)");
                hashSet.add("__DBL_HAS_QUIET_NAN__=1");
                hashSet.add("__tune_i386__=1");
                hashSet.add("__sun=1");
                hashSet.add("__REGISTER_PREFIX__=");
                hashSet.add("__NO_INLINE__=1");
                hashSet.add("__i386=1");
                hashSet.add("__FLT_MANT_DIG__=24");
                hashSet.add("__VERSION__=\"3.4.3(csl-sol210-3_4-branch+sol_rpath)\"");
                hashSet.add("i386=1");
                hashSet.add("sun=1");
                hashSet.add("unix=1");
                hashSet.add("__i386__=1");
                hashSet.add("__SIZE_TYPE__=unsignedint");
                hashSet.add("__ELF__=1");
                hashSet.add("__FLT_RADIX__=2");
                hashSet.add("__LDBL_EPSILON__=1.08420217248550443401e-19L");
                hashSet.add("__FLT_HAS_QUIET_NAN__=1");
                hashSet.add("__FLT_MAX_10_EXP__=38");
                hashSet.add("__LONG_MAX__=2147483647L");
                hashSet.add("__FLT_HAS_INFINITY__=1");
                hashSet.add("__PRAGMA_REDEFINE_EXTNAME=1");
                hashSet.add("__EXCEPTIONS=1");
                hashSet.add("__LDBL_MANT_DIG__=64");
                hashSet.add("__WCHAR_TYPE__=longint");
                hashSet.add("__FLT_DIG__=6");
                hashSet.add("__INT_MAX__=2147483647");
                hashSet.add("__FLT_MAX_EXP__=128");
                hashSet.add("__DBL_MANT_DIG__=53");
                hashSet.add("__WINT_TYPE__=longint");
                hashSet.add("__LDBL_MIN_EXP__=(-16381)");
                hashSet.add("__LDBL_MAX_10_EXP__=4932");
                hashSet.add("__DBL_EPSILON__=2.2204460492503131e-16");
                hashSet.add("__sun__=1");
                hashSet.add("__svr4__=1");
                hashSet.add("__FLT_DENORM_MIN__=1.40129846e-45F");
                hashSet.add("__FLT_MAX__=3.40282347e+38F");
                hashSet.add("__GNUC_MINOR__=4");
                hashSet.add("__DBL_MAX_10_EXP__=308");
                hashSet.add("__LDBL_DENORM_MIN__=3.64519953188247460253e-4951L");
                hashSet.add("__PTRDIFF_TYPE__=int");
                hashSet.add("__LDBL_MIN_10_EXP__=(-4931)");
                hashSet.add("__LDBL_DIG__=18");
            } else {
                hashSet.add("__CHAR_BIT__=8");
                hashSet.add("__cplusplus=1");
                hashSet.add("__DBL_DENORM_MIN__=4.9406564584124654e-324");
                hashSet.add("__DBL_DIG__=15");
                hashSet.add("__DBL_EPSILON__=2.2204460492503131e-16");
                hashSet.add("__DBL_MANT_DIG__=53");
                hashSet.add("__DBL_MAX_10_EXP__=308");
                hashSet.add("__DBL_MAX__=1.7976931348623157e+308");
                hashSet.add("__DBL_MAX_EXP__=1024");
                hashSet.add("__DBL_MIN_10_EXP__=(-307)");
                hashSet.add("__DBL_MIN__=2.2250738585072014e-308");
                hashSet.add("__DBL_MIN_EXP__=(-1021)");
                hashSet.add("__DECIMAL_DIG__=21");
                hashSet.add("__DEPRECATED=1");
                hashSet.add("__ELF__=1");
                hashSet.add("__EXCEPTIONS=1");
                hashSet.add("__FINITE_MATH_ONLY__=0");
                hashSet.add("__FLT_DENORM_MIN__=1.40129846e-45F");
                hashSet.add("__FLT_DIG__=6");
                hashSet.add("__FLT_EPSILON__=1.19209290e-7F");
                hashSet.add("__FLT_EVAL_METHOD__=2");
                hashSet.add("__FLT_MANT_DIG__=24");
                hashSet.add("__FLT_MAX_10_EXP__=38");
                hashSet.add("__FLT_MAX__=3.40282347e+38F");
                hashSet.add("__FLT_MAX_EXP__=128");
                hashSet.add("__FLT_MIN_10_EXP__=(-37)");
                hashSet.add("__FLT_MIN__=1.17549435e-38F");
                hashSet.add("__FLT_MIN_EXP__=(-125)");
                hashSet.add("__FLT_RADIX__=2");
                hashSet.add("__GNUC__=3");
                hashSet.add("__GNUC_MINOR__=3");
                hashSet.add("__GNUC_PATCHLEVEL__=4");
                hashSet.add("__GNUG__=3");
                hashSet.add("__gnu_linux__=1");
                hashSet.add("_GNU_SOURCE=1");
                hashSet.add("__GXX_ABI_VERSION=102");
                hashSet.add("__GXX_WEAK__=1");
                hashSet.add("__i386=1");
                hashSet.add("__i386__=1");
                hashSet.add("i386=1");
                hashSet.add("__INT_MAX__=2147483647");
                hashSet.add("__LDBL_DENORM_MIN__=3.64519953188247460253e-4951L");
                hashSet.add("__LDBL_DIG__=18");
                hashSet.add("__LDBL_EPSILON__=1.08420217248550443401e-19L");
                hashSet.add("__LDBL_MANT_DIG__=64");
                hashSet.add("__LDBL_MAX_10_EXP__=4932");
                hashSet.add("__LDBL_MAX__=1.18973149535723176502e+4932L");
                hashSet.add("__LDBL_MAX_EXP__=16384");
                hashSet.add("__LDBL_MIN_10_EXP__=(-4931)");
                hashSet.add("__LDBL_MIN__=3.36210314311209350626e-4932L");
                hashSet.add("__LDBL_MIN_EXP__=(-16381)");
                hashSet.add("__linux=1");
                hashSet.add("__linux__=1");
                hashSet.add("linux=1");
                hashSet.add("__LONG_LONG_MAX__=9223372036854775807LL");
                hashSet.add("__LONG_MAX__=2147483647L");
                hashSet.add("__NO_INLINE__=1");
                hashSet.add("__PTRDIFF_TYPE__=int");
                hashSet.add("__REGISTER_PREFIX__");
                hashSet.add("__SCHAR_MAX__=127");
                hashSet.add("__SHRT_MAX__=32767");
                hashSet.add("__SIZE_TYPE__=unsigned int");
                hashSet.add("__STDC_HOSTED__=1");
                hashSet.add("__tune_i586__=1");
                hashSet.add("__tune_pentium__=1");
                hashSet.add("__unix=1");
                hashSet.add("__unix__=1");
                hashSet.add("unix=1");
                hashSet.add("__USER_LABEL_PREFIX__");
                hashSet.add("__VERSION__=\"3.3.4 (pre 3.3.5 20040809)\"");
                hashSet.add("__WCHAR_MAX__=2147483647");
                hashSet.add("__WCHAR_TYPE__=long int");
                hashSet.add("__WINT_TYPE__=unsigned int");
            }
        } else if (this.useCSysDefines) {
            hashSet.add("__DBL_MIN_EXP__=(-1021)");
            hashSet.add("__FLT_MIN__=1.17549435e-38F");
            hashSet.add("__CHAR_BIT__=8");
            hashSet.add("__WCHAR_MAX__=2147483647");
            hashSet.add("__DBL_DENORM_MIN__=4.9406564584124654e-324");
            hashSet.add("__FLT_EVAL_METHOD__=2");
            hashSet.add("__unix__=1");
            hashSet.add("unix=1");
            hashSet.add("__i386__=1");
            hashSet.add("__SIZE_TYPE__=unsigned=int");
            hashSet.add("__ELF__=1");
            hashSet.add("__DBL_MIN_10_EXP__=(-307)");
            hashSet.add("__FINITE_MATH_ONLY__=0");
            hashSet.add("__GNUC_PATCHLEVEL__=4");
            hashSet.add("__FLT_RADIX__=2");
            hashSet.add("__LDBL_EPSILON__=1.08420217248550443401e-19L");
            hashSet.add("__SHRT_MAX__=32767");
            hashSet.add("__LDBL_MAX__=1.18973149535723176502e+4932L");
            hashSet.add("__linux=1");
            hashSet.add("__unix=1");
            hashSet.add("__LDBL_MAX_EXP__=16384");
            hashSet.add("__LONG_MAX__=2147483647L");
            hashSet.add("__linux__=1");
            hashSet.add("__SCHAR_MAX__=127");
            hashSet.add("__DBL_DIG__=15");
            hashSet.add("__USER_LABEL_PREFIX__");
            hashSet.add("linux=1");
            hashSet.add("__tune_pentium__=1");
            hashSet.add("__STDC_HOSTED__=1");
            hashSet.add("__LDBL_MANT_DIG__=64");
            hashSet.add("__FLT_EPSILON__=1.19209290e-7F");
            hashSet.add("__LDBL_MIN__=3.36210314311209350626e-4932L");
            hashSet.add("__WCHAR_TYPE__=long int");
            hashSet.add("__FLT_DIG__=6");
            hashSet.add("__FLT_MAX_10_EXP__=38");
            hashSet.add("__INT_MAX__=2147483647");
            hashSet.add("__gnu_linux__=1");
            hashSet.add("__FLT_MAX_EXP__=128");
            hashSet.add("__DECIMAL_DIG__=21");
            hashSet.add("__DBL_MANT_DIG__=53");
            hashSet.add("__WINT_TYPE__=unsigned int");
            hashSet.add("__GNUC__=3");
            hashSet.add("__LDBL_MIN_EXP__=(-16381)");
            hashSet.add("__tune_i586__=1");
            hashSet.add("__LDBL_MAX_10_EXP__=4932");
            hashSet.add("__DBL_EPSILON__=2.2204460492503131e-16");
            hashSet.add("__DBL_MAX__=1.7976931348623157e+308");
            hashSet.add("__DBL_MAX_EXP__=1024");
            hashSet.add("__FLT_DENORM_MIN__=1.40129846e-45F");
            hashSet.add("__LONG_LONG_MAX__=9223372036854775807LL");
            hashSet.add("__FLT_MAX__=3.40282347e+38F");
            hashSet.add("__GXX_ABI_VERSION=102");
            hashSet.add("__FLT_MIN_10_EXP__=(-37)");
            hashSet.add("__FLT_MIN_EXP__=(-125)");
            hashSet.add("i386=1");
            hashSet.add("__GNUC_MINOR__=3");
            hashSet.add("__DBL_MAX_10_EXP__=308");
            hashSet.add("__LDBL_DENORM_MIN__=3.64519953188247460253e-4951L");
            hashSet.add("__DBL_MIN__=2.2250738585072014e-308");
            hashSet.add("__PTRDIFF_TYPE__=int");
            hashSet.add("__LDBL_MIN_10_EXP__=(-4931)");
            hashSet.add("__REGISTER_PREFIX__");
            hashSet.add("__LDBL_DIG__=18");
            hashSet.add("__NO_INLINE__=1");
            hashSet.add("__i386=1");
            hashSet.add("__FLT_MANT_DIG__=24");
            hashSet.add("__VERSION__=\"3.3.4 (pre 3.3.5 20040809)\"");
        }
        return new ArrayList<String>(hashSet);
    }

    public ModelImpl getModel() {
        return this.model;
    }

    public List<String> getMacros() {
        return Collections.unmodifiableList(this.macros);
    }

    public boolean isPathsRelCurFile() {
        return this.pathsRelCurFile;
    }

    public List<File> getFiles() {
        return Collections.unmodifiableList(this.files);
    }

    public List<String> getQuoteIncludePaths() {
        return Collections.unmodifiableList(this.quoteIncludePaths);
    }

    public void setUseCSysDefines(boolean bl) {
        this.useCSysDefines = bl;
    }

    public void setUseCSysIncludes(boolean bl) {
        this.useCSysIncludes = bl;
    }

    public void setUseCppSysDefines(boolean bl) {
        this.useCppSysDefines = bl;
    }

    public void setUseCppSysIncludes(boolean bl) {
        this.useCppSysIncludes = bl;
    }

    public void setUseSysPredefined(boolean bl) {
        this.setUseCSysDefines(bl);
        this.setUseCSysIncludes(bl);
        this.setUseCppSysDefines(bl);
        this.setUseCppSysIncludes(bl);
    }

    protected final void initDataObjects() {
        ProjectBase projectBase = this.getProject();
        if (projectBase != null) {
            Collection<CsmFile> collection = projectBase.getAllFiles();
            for (CsmFile csmFile : collection) {
                if (!(csmFile instanceof FileImpl)) continue;
                try {
                    FileImpl fileImpl = (FileImpl)csmFile;
                    NativeFileItem nativeFileItem = fileImpl.getNativeFileItem();
                    FileObject fileObject = nativeFileItem == null ? null : FileUtil.toFileObject((File)nativeFileItem.getFile());
                    DataObject dataObject = fileObject == null ? null : DataObject.find((FileObject)fileObject);
                    NativeProjectProvider.registerItemInDataObject(dataObject, nativeFileItem);
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum ProcessFlagResult {
        NONE_PROCESSED,
        CHAR_PROCESSED,
        ALL_PROCESSED;

    }
}

