/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.trace;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeFileItemSet;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.project.NativeProjectItemsListener;
import org.netbeans.modules.cnd.loaders.CCDataLoader;
import org.netbeans.modules.cnd.loaders.CCDataObject;
import org.netbeans.modules.cnd.loaders.CDataLoader;
import org.netbeans.modules.cnd.loaders.CDataObject;
import org.netbeans.modules.cnd.loaders.CndDataObject;
import org.netbeans.modules.cnd.loaders.HDataLoader;
import org.netbeans.modules.cnd.loaders.HDataObject;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NativeProjectProvider {
    private NativeProjectProvider() {
    }

    public static NativeProject createProject(String string, List<File> list, List<String> list2, List<String> list3, List<String> list4, List<String> list5, boolean bl) {
        NativeProjectImpl nativeProjectImpl = new NativeProjectImpl(string, list2, list3, list4, list5, bl);
        nativeProjectImpl.addFiles(list);
        return nativeProjectImpl;
    }

    public static void fireAllFilesChanged(NativeProject nativeProject) {
        if (nativeProject instanceof NativeProjectImpl) {
            ((NativeProjectImpl)nativeProject).fireAllFilesChanged();
        }
    }

    public static void setUserMacros(NativeProject nativeProject, List<String> list) {
        if (nativeProject instanceof NativeProjectImpl) {
            ((NativeProjectImpl)nativeProject).usrMacros.clear();
            ((NativeProjectImpl)nativeProject).usrMacros.addAll(list);
        }
    }

    private static DataObject getDataObject(File file) {
        DataObject dataObject = null;
        try {
            FileObject fileObject = FileUtil.toFileObject((File)file.getCanonicalFile());
            if (fileObject != null) {
                try {
                    dataObject = DataObject.find((FileObject)fileObject);
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {}
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return dataObject;
    }

    static void registerItemInDataObject(DataObject dataObject, NativeFileItem nativeFileItem) {
        if (dataObject != null) {
            NativeFileItemSet nativeFileItemSet = (NativeFileItemSet)dataObject.getLookup().lookup(NativeFileItemSet.class);
            if (nativeFileItemSet == null) {
                nativeFileItemSet = new NativeFileItemSetImpl();
                if (dataObject instanceof CndDataObject) {
                    ((CndDataObject)dataObject).addCookie((Node.Cookie)nativeFileItemSet);
                }
            }
            nativeFileItemSet.add(nativeFileItem);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NativeFileItemImpl
    implements NativeFileItem {
        private final File file;
        private final NativeProjectImpl project;
        private final NativeFileItem.Language lang;

        public NativeFileItemImpl(File file, NativeProjectImpl nativeProjectImpl, NativeFileItem.Language language) {
            this.project = nativeProjectImpl;
            this.file = file;
            this.lang = language;
        }

        public NativeProject getNativeProject() {
            return this.project;
        }

        public File getFile() {
            return this.file;
        }

        public List<String> getSystemIncludePaths() {
            List<String> list = this.project.getSystemIncludePaths();
            return this.project.pathsRelCurFile ? this.toAbsolute(list) : list;
        }

        public List<String> getUserIncludePaths() {
            List<String> list = this.project.getUserIncludePaths();
            return this.project.pathsRelCurFile ? this.toAbsolute(list) : list;
        }

        private List<String> toAbsolute(List<String> list) {
            File file = this.file.getParentFile();
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            for (String string : list) {
                File file2 = new File(string);
                if (file2.isAbsolute()) {
                    arrayList.add(string);
                    continue;
                }
                file2 = new File(file, string);
                arrayList.add(file2.getAbsolutePath());
            }
            return arrayList;
        }

        public List<String> getSystemMacroDefinitions() {
            return this.project.getSystemMacroDefinitions();
        }

        public List<String> getUserMacroDefinitions() {
            return this.project.getUserMacroDefinitions();
        }

        public NativeFileItem.Language getLanguage() {
            return this.lang;
        }

        public NativeFileItem.LanguageFlavor getLanguageFlavor() {
            return NativeFileItem.LanguageFlavor.GENERIC;
        }

        public boolean isExcluded() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NativeFileItemSetImpl
    implements NativeFileItemSet {
        private List<NativeFileItem> items = new ArrayList<NativeFileItem>(1);

        private NativeFileItemSetImpl() {
        }

        public synchronized Collection<NativeFileItem> getItems() {
            return new ArrayList<NativeFileItem>(this.items);
        }

        public synchronized void add(NativeFileItem nativeFileItem) {
            if (!this.items.contains(nativeFileItem)) {
                this.items.add(nativeFileItem);
            }
        }

        public synchronized void remove(NativeFileItem nativeFileItem) {
            this.items.remove(nativeFileItem);
        }

        public boolean isEmpty() {
            return this.items.isEmpty();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NativeProjectImpl
    implements NativeProject {
        private final List<String> sysIncludes;
        private final List<String> usrIncludes;
        private final List<String> sysMacros;
        private final List<String> usrMacros;
        private final List<NativeFileItem> files = new ArrayList<NativeFileItem>();
        private final String projectRoot;
        private boolean pathsRelCurFile;
        private List<NativeProjectItemsListener> listeners = new ArrayList<NativeProjectItemsListener>();
        private final Object listenersLock = new Object();

        public NativeProjectImpl(String string, List<String> list, List<String> list2, List<String> list3, List<String> list4) {
            this(string, list, list2, list3, list4, false);
        }

        public NativeProjectImpl(String string, List<String> list, List<String> list2, List<String> list3, List<String> list4, boolean bl) {
            this.projectRoot = string;
            this.pathsRelCurFile = bl;
            this.sysIncludes = this.createIncludes(list);
            this.usrIncludes = this.createIncludes(list2);
            this.sysMacros = new ArrayList<String>(list3);
            this.usrMacros = new ArrayList<String>(list4);
        }

        private List<String> createIncludes(List<String> list) {
            if (this.pathsRelCurFile) {
                return new ArrayList<String>(list);
            }
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            for (String string : list) {
                File file = new File(string);
                arrayList.add(file.getAbsolutePath());
            }
            return arrayList;
        }

        private void addFiles(List<File> list) {
            for (File file : list) {
                this.addFile(file);
            }
        }

        public Object getProject() {
            return null;
        }

        public List<String> getSourceRoots() {
            return Collections.emptyList();
        }

        public String getProjectRoot() {
            return this.projectRoot;
        }

        public String getProjectDisplayName() {
            return this.getProjectRoot();
        }

        public List<NativeFileItem> getAllFiles() {
            return Collections.unmodifiableList(this.files);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addProjectItemsListener(NativeProjectItemsListener nativeProjectItemsListener) {
            Object object = this.listenersLock;
            synchronized (object) {
                this.listeners.add(nativeProjectItemsListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeProjectItemsListener(NativeProjectItemsListener nativeProjectItemsListener) {
            Object object = this.listenersLock;
            synchronized (object) {
                this.listeners.remove(nativeProjectItemsListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireAllFilesChanged() {
            ArrayList<NativeProjectItemsListener> arrayList;
            List<NativeFileItem> list = this.listenersLock;
            synchronized (list) {
                arrayList = new ArrayList<NativeProjectItemsListener>(this.listeners);
            }
            list = Collections.unmodifiableList(this.files);
            for (NativeProjectItemsListener nativeProjectItemsListener : arrayList) {
                nativeProjectItemsListener.filesPropertiesChanged(list);
            }
        }

        public NativeFileItem findFileItem(File file) {
            String string = file.getAbsolutePath();
            for (NativeFileItem nativeFileItem : this.files) {
                if (!nativeFileItem.getFile().getAbsolutePath().equalsIgnoreCase(string)) continue;
                return nativeFileItem;
            }
            return null;
        }

        public List<String> getSystemIncludePaths() {
            return this.sysIncludes;
        }

        public List<String> getUserIncludePaths() {
            return this.usrIncludes;
        }

        public List<String> getSystemMacroDefinitions() {
            return this.sysMacros;
        }

        public List<String> getUserMacroDefinitions() {
            return this.usrMacros;
        }

        private void addFile(File file) {
            DataObject dataObject = NativeProjectProvider.getDataObject(file);
            NativeFileItem.Language language = this.getLanguage(file, dataObject);
            NativeFileItemImpl nativeFileItemImpl = new NativeFileItemImpl(file, this, language);
            this.files.add(nativeFileItemImpl);
        }

        NativeFileItem.Language getLanguage(File file, DataObject dataObject) {
            if (dataObject == null) {
                String string = file.getAbsolutePath();
                if (CCDataLoader.getInstance().getDefaultExtensionList().isRegistered(string)) {
                    return NativeFileItem.Language.CPP;
                }
                if (CDataLoader.getInstance().getDefaultExtensionList().isRegistered(string)) {
                    return NativeFileItem.Language.C;
                }
                if (HDataLoader.getInstance().getDefaultExtensionList().isRegistered(string)) {
                    return NativeFileItem.Language.C_HEADER;
                }
                return NativeFileItem.Language.OTHER;
            }
            if (dataObject instanceof CCDataObject) {
                return NativeFileItem.Language.CPP;
            }
            if (dataObject instanceof HDataObject) {
                return NativeFileItem.Language.C_HEADER;
            }
            if (dataObject instanceof CDataObject) {
                return NativeFileItem.Language.C;
            }
            return NativeFileItem.Language.OTHER;
        }

        public List<NativeProject> getDependences() {
            return Collections.emptyList();
        }

        public void runOnCodeModelReadiness(Runnable runnable) {
            runnable.run();
        }
    }
}

