/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmIdentifiable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.apt.debug.DebugUtils;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.repository.FileKey;
import org.netbeans.modules.cnd.modelimpl.repository.KeyHolder;
import org.netbeans.modules.cnd.modelimpl.repository.KeyUtilities;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryListenerImpl;
import org.netbeans.modules.cnd.repository.api.Repository;
import org.netbeans.modules.cnd.repository.api.RepositoryAccessor;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.spi.RepositoryListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RepositoryUtils {
    private static final boolean TRACE_REPOSITORY_ACCESS = DebugUtils.getBoolean((String)"cnd.modelimpl.trace.repository", (boolean)false);
    private static final Repository repository = RepositoryAccessor.getRepository();
    private static int CURRENT_VERSION_OF_PERSISTENCY = 46;
    private static volatile int counter = 0;

    private RepositoryUtils() {
    }

    public static <T extends CsmIdentifiable> T get(CsmUID<T> csmUID) {
        Key key = RepositoryUtils.UIDtoKey(csmUID);
        Persistent persistent = RepositoryUtils.get(key);
        assert (persistent == null || persistent instanceof CsmIdentifiable);
        return (T)((CsmIdentifiable)persistent);
    }

    public static Persistent tryGet(Key key) {
        assert (key != null);
        Persistent persistent = repository.tryGet(key);
        if (TRACE_REPOSITORY_ACCESS) {
            System.err.printf("%d:trying key %s got %s", RepositoryUtils.nextIndex(), key, persistent);
        }
        return persistent;
    }

    public static Persistent get(Key key) {
        assert (key != null);
        if (TRACE_REPOSITORY_ACCESS) {
            long l = System.currentTimeMillis();
            int n = RepositoryUtils.nextIndex();
            System.err.println(n + ":getting key " + key);
            Persistent persistent = repository.get(key);
            l = System.currentTimeMillis() - l;
            System.err.println(n + ":got in " + l + "ms the key " + key);
            return persistent;
        }
        return repository.get(key);
    }

    private static synchronized int nextIndex() {
        return counter++;
    }

    public static void remove(CsmUID csmUID) {
        Key key = RepositoryUtils.UIDtoKey(csmUID);
        if (key != null) {
            if (TRACE_REPOSITORY_ACCESS) {
                long l = System.currentTimeMillis();
                int n = RepositoryUtils.nextIndex();
                System.err.println(n + ":removing key " + key);
                if (!TraceFlags.SAFE_REPOSITORY_ACCESS) {
                    repository.remove(key);
                }
                l = System.currentTimeMillis() - l;
                System.err.println(n + ":removed in " + l + "ms the key " + key);
                return;
            }
            if (!TraceFlags.SAFE_REPOSITORY_ACCESS) {
                repository.remove(key);
            }
        }
    }

    public static void remove(Collection<? extends CsmUID> collection) {
        if (collection != null) {
            for (CsmUID csmUID : collection) {
                RepositoryUtils.remove(csmUID);
            }
        }
    }

    public static CsmUID put(CsmIdentifiable csmIdentifiable) {
        CsmUID csmUID = null;
        if (csmIdentifiable != null) {
            csmUID = csmIdentifiable.getUID();
            assert (csmUID != null);
            Key key = RepositoryUtils.UIDtoKey(csmUID);
            RepositoryUtils.put(key, (Persistent)csmIdentifiable);
        }
        return csmUID;
    }

    public static void put(Key key, Persistent persistent) {
        if (key != null) {
            if (TRACE_REPOSITORY_ACCESS) {
                long l = System.currentTimeMillis();
                int n = RepositoryUtils.nextIndex();
                System.err.println(n + ":putting key " + key);
                repository.put(key, persistent);
                if (key instanceof FileKey) {
                    repository.hang(key, persistent);
                }
                l = System.currentTimeMillis() - l;
                System.err.println(n + ":put in " + l + "ms the key " + key);
                return;
            }
            repository.put(key, persistent);
            if (key instanceof FileKey) {
                repository.hang(key, persistent);
            }
        }
    }

    public static void hang(CsmIdentifiable csmIdentifiable) {
        CsmUID csmUID = null;
        if (csmIdentifiable != null) {
            csmUID = csmIdentifiable.getUID();
            assert (csmUID != null);
            Key key = RepositoryUtils.UIDtoKey(csmUID);
            RepositoryUtils.hang(key, (Persistent)csmIdentifiable);
        }
    }

    public static void hang(Key key, Persistent persistent) {
        if (key != null) {
            if (TRACE_REPOSITORY_ACCESS) {
                long l = System.currentTimeMillis();
                int n = RepositoryUtils.nextIndex();
                System.err.println(n + ":hanging key " + key);
                repository.hang(key, persistent);
                l = System.currentTimeMillis() - l;
                System.err.println(n + ":hung in " + l + "ms the key " + key);
                return;
            }
            repository.hang(key, persistent);
        }
    }

    public static <T extends CsmOffsetableDeclaration> List<CsmUID<T>> put(List<T> list) {
        assert (list != null);
        ArrayList<CsmUID<T>> arrayList = new ArrayList<CsmUID<T>>(list.size());
        for (CsmOffsetableDeclaration csmOffsetableDeclaration : list) {
            CsmUID csmUID = RepositoryUtils.put((CsmIdentifiable)csmOffsetableDeclaration);
            arrayList.add(csmUID);
        }
        return arrayList;
    }

    public static Key UIDtoKey(CsmUID csmUID) {
        if (csmUID instanceof KeyHolder) {
            return ((KeyHolder)csmUID).getKey();
        }
        return null;
    }

    public static CharSequence getUnitName(CsmUID csmUID) {
        Key key = RepositoryUtils.UIDtoKey(csmUID);
        assert (key != null);
        CharSequence charSequence = key.getUnit();
        return charSequence;
    }

    public static void startup() {
        repository.startup(CURRENT_VERSION_OF_PERSISTENCY);
        repository.unregisterRepositoryListener((RepositoryListener)RepositoryListenerImpl.instance());
        repository.registerRepositoryListener((RepositoryListener)RepositoryListenerImpl.instance());
    }

    public static void shutdown() {
        repository.shutdown();
    }

    public static void cleanCashes() {
        repository.cleanCaches();
    }

    public static void closeUnit(CsmUID csmUID, Set<String> set, boolean bl) {
        RepositoryUtils.closeUnit(RepositoryUtils.UIDtoKey(csmUID), set, bl);
    }

    public static void closeUnit(String string, Set<String> set) {
        RepositoryUtils.closeUnit(string, set, !TraceFlags.PERSISTENT_REPOSITORY);
    }

    public static void closeUnit(String string, Set<String> set, boolean bl) {
        RepositoryListenerImpl.instance().onExplicitClose(string);
        repository.closeUnit(string, bl, set);
    }

    public static void closeUnit(Key key, Set<String> set) {
        RepositoryUtils.closeUnit(key, set, !TraceFlags.PERSISTENT_REPOSITORY);
    }

    public static void closeUnit(Key key, Set<String> set, boolean bl) {
        assert (key != null);
        repository.closeUnit(((Object)key.getUnit()).toString(), bl, set);
    }

    public static void onProjectDeleted(NativeProject nativeProject) {
        Key key = KeyUtilities.createProjectKey(nativeProject);
        repository.removeUnit(((Object)key.getUnit()).toString());
    }

    public static void openUnit(ProjectBase projectBase) {
        CsmUID<CsmProject> csmUID = projectBase.getUID();
        assert (csmUID != null);
        Key key = RepositoryUtils.UIDtoKey(csmUID);
        RepositoryUtils.openUnit(key);
    }

    public static void openUnit(Key key) {
        RepositoryUtils.openUnit(key.getUnitId(), ((Object)key.getUnit()).toString());
    }

    private static void openUnit(int n, String string) {
        RepositoryListenerImpl.instance().onExplicitOpen(string);
        repository.openUnit(n, string);
    }

    public static void unregisterRepositoryListener(RepositoryListener repositoryListener) {
        repository.unregisterRepositoryListener(repositoryListener);
    }

    static int getUnitId(String string) {
        return RepositoryAccessor.getTranslator().getUnitId(string);
    }

    static String getUnitName(int n) {
        return RepositoryAccessor.getTranslator().getUnitName(n);
    }

    static int getFileIdByName(int n, String string) {
        return RepositoryAccessor.getTranslator().getFileIdByName(n, string);
    }

    static String getFileNameByIdSafe(int n, int n2) {
        return RepositoryAccessor.getTranslator().getFileNameByIdSafe(n, n2);
    }

    static String getFileNameById(int n, int n2) {
        return RepositoryAccessor.getTranslator().getFileNameById(n, n2);
    }
}

