/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.repository;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameter;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.deep.CsmCompoundStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmExpression;
import org.netbeans.modules.cnd.apt.support.APTHandlersSupport;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.apt.utils.APTSerializeUtils;
import org.netbeans.modules.cnd.modelimpl.csm.InheritanceImpl;
import org.netbeans.modules.cnd.modelimpl.csm.NestedType;
import org.netbeans.modules.cnd.modelimpl.csm.NoType;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateDescriptor;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateParameterImpl;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateParameterTypeImpl;
import org.netbeans.modules.cnd.modelimpl.csm.TypeFunPtrImpl;
import org.netbeans.modules.cnd.modelimpl.csm.TypeImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.AbstractFileBuffer;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileBuffer;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileBufferFile;
import org.netbeans.modules.cnd.modelimpl.csm.deep.CompoundStatementImpl;
import org.netbeans.modules.cnd.modelimpl.csm.deep.EmptyCompoundStatementImpl;
import org.netbeans.modules.cnd.modelimpl.csm.deep.ExpressionBase;
import org.netbeans.modules.cnd.modelimpl.csm.deep.LazyCompoundStatementImpl;
import org.netbeans.modules.cnd.modelimpl.csm.deep.StatementBase;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.utils.cache.APTStringManager;
import org.netbeans.modules.cnd.utils.cache.FilePathCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentUtils {
    private static final int UTF_LIMIT = 65535;
    private static final int FIRST_INDEX = 69;
    private static final int VISIBILITY_PUBLIC = 69;
    private static final int VISIBILITY_PROTECTED = 70;
    private static final int VISIBILITY_PRIVATE = 71;
    private static final int VISIBILITY_NONE = 72;
    private static final int EXPRESSION_BASE = 73;
    private static final int FILE_BUFFER_FILE = 74;
    private static final int NO_TYPE = 75;
    private static final int TYPE_IMPL = 76;
    private static final int NESTED_TYPE = 77;
    private static final int TYPE_FUN_PTR_IMPL = 78;
    private static final int TEMPLATE_PARAM_TYPE = 79;
    private static final int PREPROC_STATE_STATE_IMPL = 80;
    private static final int LAZY_COMPOUND_STATEMENT_IMPL = 81;
    private static final int EMPTY_COMPOUND_STATEMENT_IMPL = 82;
    private static final int COMPOUND_STATEMENT_IMPL = 83;
    public static final int LAST_INDEX = 83;

    private PersistentUtils() {
    }

    public static void writeBuffer(FileBuffer fileBuffer, DataOutput dataOutput) throws IOException {
        assert (fileBuffer != null);
        if (!(fileBuffer instanceof AbstractFileBuffer)) {
            throw new IllegalArgumentException("instance of unknown FileBuffer " + fileBuffer);
        }
        dataOutput.writeInt(74);
        File file = fileBuffer.getFile();
        dataOutput.writeUTF(file.getAbsolutePath());
    }

    public static FileBuffer readBuffer(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        assert (n == 74);
        CharSequence charSequence = FilePathCache.getString((CharSequence)dataInput.readUTF());
        FileBufferFile fileBufferFile = new FileBufferFile(new File(((Object)charSequence).toString()));
        return fileBufferFile;
    }

    public static void writeStrings(CharSequence[] charSequenceArray, DataOutput dataOutput) throws IOException {
        if (charSequenceArray == null) {
            dataOutput.writeInt(-1);
        } else {
            int n = charSequenceArray.length;
            dataOutput.writeInt(n);
            for (int i = 0; i < n; ++i) {
                assert (charSequenceArray[i] != null);
                dataOutput.writeUTF(((Object)charSequenceArray[i]).toString());
            }
        }
    }

    public static void writeCollectionStrings(Collection<String> collection, DataOutput dataOutput) throws IOException {
        if (collection == null) {
            dataOutput.writeInt(-1);
        } else {
            int n = collection.size();
            dataOutput.writeInt(n);
            for (String string : collection) {
                assert (string != null);
                dataOutput.writeUTF(string);
            }
        }
    }

    public static CharSequence[] readStrings(DataInput dataInput, APTStringManager aPTStringManager) throws IOException {
        CharSequence[] charSequenceArray = null;
        int n = dataInput.readInt();
        if (n != -1) {
            charSequenceArray = new CharSequence[n];
            for (int i = 0; i < n; ++i) {
                String string = dataInput.readUTF();
                assert (string != null);
                charSequenceArray[i] = aPTStringManager.getString((CharSequence)string);
            }
        }
        return charSequenceArray;
    }

    public static Collection<CharSequence> readCollectionStrings(DataInput dataInput, APTStringManager aPTStringManager) throws IOException {
        ArrayList<CharSequence> arrayList = null;
        int n = dataInput.readInt();
        if (n != -1) {
            arrayList = new ArrayList<CharSequence>(n);
            for (int i = 0; i < n; ++i) {
                String string = dataInput.readUTF();
                assert (string != null);
                if (aPTStringManager != null) {
                    arrayList.add(aPTStringManager.getString((CharSequence)string));
                    continue;
                }
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    public static void writeUTF(CharSequence charSequence, DataOutput dataOutput) throws IOException {
        if (charSequence != null) {
            dataOutput.writeShort(charSequence.length() / 65535 + (charSequence.length() % 65535 == 0 ? 0 : 1));
            for (int i = 0; i < charSequence.length(); i += 65535) {
                CharSequence charSequence2 = charSequence.subSequence(i, Math.min(i + 65535, charSequence.length()));
                dataOutput.writeUTF(((Object)charSequence2).toString());
            }
        } else {
            dataOutput.writeShort(-1);
        }
    }

    public static String readUTF(DataInput dataInput) throws IOException {
        int n = dataInput.readShort();
        switch (n) {
            case -1: {
                return null;
            }
            case 0: {
                return "";
            }
            case 1: {
                return dataInput.readUTF();
            }
        }
        StringBuilder stringBuilder = new StringBuilder(n * 65535);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(dataInput.readUTF());
        }
        return stringBuilder.toString();
    }

    public static void writeExpression(CsmExpression csmExpression, DataOutput dataOutput) throws IOException {
        if (csmExpression == null) {
            dataOutput.writeInt(-1);
        } else if (csmExpression instanceof ExpressionBase) {
            dataOutput.writeInt(73);
            ((ExpressionBase)csmExpression).write(dataOutput);
        } else {
            throw new IllegalArgumentException("instance of unknown CsmExpression " + csmExpression);
        }
    }

    public static CsmExpression readExpression(DataInput dataInput) throws IOException {
        ExpressionBase expressionBase;
        int n = dataInput.readInt();
        if (n == -1) {
            expressionBase = null;
        } else {
            assert (n == 73);
            expressionBase = new ExpressionBase(dataInput);
        }
        return expressionBase;
    }

    public static void writeExpressions(Collection<CsmExpression> collection, DataOutput dataOutput) throws IOException {
        if (collection == null) {
            dataOutput.writeInt(-1);
        } else {
            int n = collection.size();
            dataOutput.writeInt(n);
            for (CsmExpression csmExpression : collection) {
                assert (csmExpression != null);
                PersistentUtils.writeExpression(csmExpression, dataOutput);
            }
        }
    }

    public static <T extends Collection<CsmExpression>> T readExpressions(T t, DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        if (n != -1) {
            for (int i = 0; i < n; ++i) {
                CsmExpression csmExpression = PersistentUtils.readExpression(dataInput);
                assert (csmExpression != null);
                t.add((CsmExpression)csmExpression);
            }
            return t;
        }
        t = null;
        return t;
    }

    public static void writeExpressionKind(CsmExpression.Kind kind, DataOutput dataOutput) throws IOException {
        if (kind != null) {
            throw new UnsupportedOperationException("Not yet implemented");
        }
        dataOutput.writeInt(-1);
    }

    public static CsmExpression.Kind readExpressionKind(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        if (n != -1) {
            throw new UnsupportedOperationException("Not yet implemented");
        }
        CsmExpression.Kind kind = null;
        return kind;
    }

    public static CsmType readType(DataInput dataInput) throws IOException {
        Object object;
        int n = dataInput.readInt();
        switch (n) {
            case -1: {
                object = null;
                break;
            }
            case 75: {
                object = NoType.instance();
                break;
            }
            case 76: {
                object = new TypeImpl(dataInput);
                break;
            }
            case 77: {
                object = new NestedType(dataInput);
                break;
            }
            case 78: {
                object = new TypeFunPtrImpl(dataInput);
                break;
            }
            case 79: {
                object = new TemplateParameterTypeImpl(dataInput);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown type handler" + n);
            }
        }
        return object;
    }

    public static void writeType(CsmType csmType, DataOutput dataOutput) throws IOException {
        if (csmType == null) {
            dataOutput.writeInt(-1);
        } else if (csmType instanceof NoType) {
            dataOutput.writeInt(75);
        } else if (csmType instanceof TypeImpl) {
            if (csmType instanceof TypeFunPtrImpl) {
                dataOutput.writeInt(78);
                ((TypeFunPtrImpl)csmType).write(dataOutput);
            } else if (csmType instanceof NestedType) {
                dataOutput.writeInt(77);
                ((NestedType)csmType).write(dataOutput);
            } else {
                dataOutput.writeInt(76);
                ((TypeImpl)csmType).write(dataOutput);
            }
        } else if (csmType instanceof TemplateParameterTypeImpl) {
            dataOutput.writeInt(79);
            ((TemplateParameterTypeImpl)csmType).write(dataOutput);
        } else {
            throw new IllegalArgumentException("instance of unknown class " + csmType.getClass().getName());
        }
    }

    public static <T extends Collection<CsmType>> void readTypes(T t, DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        assert (n >= 0);
        for (int i = 0; i < n; ++i) {
            CsmType csmType = PersistentUtils.readType(dataInput);
            assert (csmType != null);
            t.add((CsmType)csmType);
        }
    }

    public static void writeTypes(Collection<? extends CsmType> collection, DataOutput dataOutput) throws IOException {
        assert (collection != null);
        int n = collection.size();
        dataOutput.writeInt(n);
        for (CsmType csmType : collection) {
            assert (csmType != null);
            PersistentUtils.writeType(csmType, dataOutput);
        }
    }

    private static void writeInheritance(CsmInheritance csmInheritance, DataOutput dataOutput) throws IOException {
        assert (csmInheritance != null);
        if (!(csmInheritance instanceof InheritanceImpl)) {
            throw new IllegalArgumentException("instance of unknown CsmInheritance " + csmInheritance);
        }
        ((InheritanceImpl)csmInheritance).write(dataOutput);
    }

    private static CsmInheritance readInheritance(DataInput dataInput) throws IOException {
        InheritanceImpl inheritanceImpl = new InheritanceImpl(dataInput);
        return inheritanceImpl;
    }

    public static <T extends Collection<CsmInheritance>> void readInheritances(T t, DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        assert (n >= 0);
        for (int i = 0; i < n; ++i) {
            CsmInheritance csmInheritance = PersistentUtils.readInheritance(dataInput);
            assert (csmInheritance != null);
            t.add((CsmInheritance)csmInheritance);
        }
    }

    public static void writeInheritances(Collection<? extends CsmInheritance> collection, DataOutput dataOutput) throws IOException {
        assert (collection != null);
        int n = collection.size();
        dataOutput.writeInt(n);
        for (CsmInheritance csmInheritance : collection) {
            assert (csmInheritance != null);
            PersistentUtils.writeInheritance(csmInheritance, dataOutput);
        }
    }

    public static void writeTemplateParameter(CsmTemplateParameter csmTemplateParameter, DataOutput dataOutput) throws IOException {
        assert (csmTemplateParameter != null);
        if (!(csmTemplateParameter instanceof TemplateParameterImpl)) {
            throw new IllegalArgumentException("instance of unknown TemplateParameterImpl " + csmTemplateParameter);
        }
        ((TemplateParameterImpl)csmTemplateParameter).write(dataOutput);
    }

    public static CsmTemplateParameter readTemplateParameter(DataInput dataInput) throws IOException {
        TemplateParameterImpl templateParameterImpl = new TemplateParameterImpl(dataInput);
        return templateParameterImpl;
    }

    public static List<CsmTemplateParameter> readTemplateParameters(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        if (n == -1) {
            return null;
        }
        ArrayList<CsmTemplateParameter> arrayList = new ArrayList<CsmTemplateParameter>();
        assert (n >= 0);
        for (int i = 0; i < n; ++i) {
            CsmTemplateParameter csmTemplateParameter = PersistentUtils.readTemplateParameter(dataInput);
            assert (csmTemplateParameter != null);
            arrayList.add(csmTemplateParameter);
        }
        return arrayList;
    }

    public static void writeTemplateParameters(Collection<CsmTemplateParameter> collection, DataOutput dataOutput) throws IOException {
        if (collection == null) {
            dataOutput.writeInt(-1);
        } else {
            int n = collection.size();
            dataOutput.writeInt(n);
            for (CsmTemplateParameter csmTemplateParameter : collection) {
                assert (csmTemplateParameter != null);
                PersistentUtils.writeTemplateParameter(csmTemplateParameter, dataOutput);
            }
        }
    }

    public static TemplateDescriptor readTemplateDescriptor(DataInput dataInput) throws IOException {
        List<CsmTemplateParameter> list = PersistentUtils.readTemplateParameters(dataInput);
        if (list == null) {
            return null;
        }
        CharSequence charSequence = NameCache.getManager().getString((CharSequence)dataInput.readUTF());
        return new TemplateDescriptor(list, charSequence);
    }

    public static void writeTemplateDescriptor(TemplateDescriptor templateDescriptor, DataOutput dataOutput) throws IOException {
        if (templateDescriptor == null) {
            dataOutput.writeInt(-1);
        } else {
            templateDescriptor.write(dataOutput);
        }
    }

    public static void writeVisibility(CsmVisibility csmVisibility, DataOutput dataOutput) throws IOException {
        assert (csmVisibility != null);
        int n = -1;
        if (csmVisibility == CsmVisibility.PUBLIC) {
            n = 69;
        } else if (csmVisibility == CsmVisibility.PROTECTED) {
            n = 70;
        } else if (csmVisibility == CsmVisibility.PRIVATE) {
            n = 71;
        } else if (csmVisibility == CsmVisibility.NONE) {
            n = 72;
        } else {
            throw new IllegalArgumentException("instance of unknown visibility " + csmVisibility);
        }
        dataOutput.writeInt(n);
    }

    public static CsmVisibility readVisibility(DataInput dataInput) throws IOException {
        CsmVisibility csmVisibility = null;
        int n = dataInput.readInt();
        switch (n) {
            case 69: {
                csmVisibility = CsmVisibility.PUBLIC;
                break;
            }
            case 70: {
                csmVisibility = CsmVisibility.PROTECTED;
                break;
            }
            case 71: {
                csmVisibility = CsmVisibility.PRIVATE;
                break;
            }
            case 72: {
                csmVisibility = CsmVisibility.NONE;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown handler" + n);
            }
        }
        return csmVisibility;
    }

    public static void writeCompoundStatement(CsmCompoundStatement csmCompoundStatement, DataOutput dataOutput) throws IOException {
        assert (csmCompoundStatement != null);
        if (csmCompoundStatement instanceof LazyCompoundStatementImpl) {
            dataOutput.writeInt(81);
            ((LazyCompoundStatementImpl)csmCompoundStatement).write(dataOutput);
        } else if (csmCompoundStatement instanceof EmptyCompoundStatementImpl) {
            dataOutput.writeInt(82);
            ((EmptyCompoundStatementImpl)csmCompoundStatement).write(dataOutput);
        } else if (csmCompoundStatement instanceof CompoundStatementImpl) {
            dataOutput.writeInt(83);
            ((CompoundStatementImpl)csmCompoundStatement).write(dataOutput);
        } else {
            throw new IllegalArgumentException("unknown compound statement " + csmCompoundStatement);
        }
    }

    public static CsmCompoundStatement readCompoundStatement(DataInput dataInput) throws IOException {
        StatementBase statementBase;
        int n = dataInput.readInt();
        switch (n) {
            case 81: {
                statementBase = new LazyCompoundStatementImpl(dataInput);
                break;
            }
            case 82: {
                statementBase = new EmptyCompoundStatementImpl(dataInput);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown handler" + n);
            }
        }
        return statementBase;
    }

    public static void writePreprocState(APTPreprocHandler.State state, DataOutput dataOutput) throws IOException {
        APTPreprocHandler.State state2 = APTHandlersSupport.createCleanPreprocState((APTPreprocHandler.State)state);
        APTSerializeUtils.writePreprocState((APTPreprocHandler.State)state2, (DataOutput)dataOutput);
    }

    public static APTPreprocHandler.State readPreprocState(DataInput dataInput) throws IOException {
        APTPreprocHandler.State state = APTSerializeUtils.readPreprocState((DataInput)dataInput);
        assert (state.isCleaned());
        return state;
    }
}

