/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.support.KeyFactory;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;

public abstract class ProjectComponent
implements Persistent,
SelfPersistent {
    private Key key;

    public ProjectComponent(Key key) {
        this.key = key;
    }

    public ProjectComponent(DataInput dataInput) throws IOException {
        this.key = KeyFactory.getDefaultFactory().readKey(dataInput);
        if (TraceFlags.TRACE_PROJECT_COMPONENT_RW) {
            System.err.printf("< ProjectComponent: Reading %s key %s\n", this, this.key);
        }
    }

    public Key getKey() {
        return this.key;
    }

    public void put() {
        if (TraceFlags.TRACE_PROJECT_COMPONENT_RW) {
            System.err.printf("> ProjectComponent: Hanging %s by key %s\n", this, this.key);
        }
        RepositoryUtils.hang(this.key, this);
    }

    private void putImpl() {
        if (TraceFlags.TRACE_PROJECT_COMPONENT_RW) {
            System.err.printf("> ProjectComponent: Putting %s by key %s\n", this, this.key);
        }
        RepositoryUtils.put(this.key, this);
    }

    public void write(DataOutput dataOutput) throws IOException {
        if (TraceFlags.TRACE_PROJECT_COMPONENT_RW) {
            System.err.printf("> ProjectComponent: Writing %s by key %s\n", this, this.key);
        }
        ProjectComponent.writeKey(this.key, dataOutput);
    }

    public static Key readKey(DataInput dataInput) throws IOException {
        return KeyFactory.getDefaultFactory().readKey(dataInput);
    }

    public static void writeKey(Key key, DataOutput dataOutput) throws IOException {
        KeyFactory.getDefaultFactory().writeKey(key, dataOutput);
    }

    public static void setStable(Key key) {
        Persistent persistent = RepositoryUtils.tryGet(key);
        if (persistent != null) {
            assert (persistent instanceof ProjectComponent);
            ProjectComponent projectComponent = (ProjectComponent)persistent;
        }
    }
}

