/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.parser.apt.APTParseFileWalker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilePreprocessorConditionState
implements APTParseFileWalker.EvalCallback {
    private int[] offsets;
    private int size;
    private transient CharSequence fileName;
    private static final int MIN_SIZE = 16;

    public FilePreprocessorConditionState(FileImpl fileImpl) {
        this.offsets = new int[16];
        this.fileName = fileImpl.getAbsolutePath();
    }

    public FilePreprocessorConditionState(FilePreprocessorConditionState filePreprocessorConditionState) {
        this.offsets = new int[filePreprocessorConditionState.size];
        System.arraycopy(filePreprocessorConditionState.offsets, 0, this.offsets, 0, this.offsets.length);
        this.fileName = filePreprocessorConditionState.fileName;
    }

    public FilePreprocessorConditionState(DataInput dataInput) throws IOException {
        this.size = dataInput.readInt();
        if (this.size > 0) {
            this.offsets = new int[Math.max(this.size, 16)];
            for (int i = 0; i < this.size; ++i) {
                this.offsets[i] = dataInput.readInt();
            }
        } else {
            this.offsets = new int[16];
        }
        this.fileName = null;
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.size);
        if (this.size > 0) {
            for (int i = 0; i < this.size; ++i) {
                dataOutput.writeInt(this.offsets[i]);
            }
        }
    }

    public void clear() {
        this.size = 0;
    }

    @Override
    public void onEval(APT aPT, boolean bl) {
        boolean bl2 = false;
        int n = -1;
        if (bl) {
            bl2 = true;
            n = aPT.getOffset();
        } else {
            APT aPT2 = aPT.getNextSibling();
            if (aPT2 != null && aPT2.getType() == 12) {
                bl2 = true;
                n = aPT2.getOffset();
            }
        }
        if (bl2) {
            assert (n >= 0);
            this.addOffset(n);
        }
    }

    private boolean addOffset(int n) {
        if (this.size == 0) {
            this.offsets[0] = n;
            this.size = 1;
        } else {
            int n2 = this.size - 1;
            if (this.offsets[n2] < n) {
                this.insert(n2 + 1, n);
            } else {
                for (int i = n2 - 1; i > 0; --i) {
                    if (n <= this.offsets[i]) continue;
                    this.insert(i + 1, n);
                    return true;
                }
                this.insert(0, n);
            }
        }
        return false;
    }

    private void insert(int n, int n2) {
        if (n > this.size) {
            throw new IllegalArgumentException("Index: " + n + " shouldn't be greater than " + this.size);
        }
        if (this.size >= this.offsets.length) {
            int n3 = this.size * 3 / 2 + 1;
            int[] nArray = new int[n3];
            System.arraycopy(this.offsets, 0, nArray, 0, this.offsets.length);
            this.offsets = nArray;
        }
        if (n < this.size) {
            System.arraycopy(this.offsets, n, this.offsets, n + 1, this.offsets.length - n + 1);
        }
        this.offsets[n] = n2;
        ++this.size;
    }

    public final boolean isBetter(FilePreprocessorConditionState filePreprocessorConditionState) {
        int n = this.compareToImpl(filePreprocessorConditionState);
        if (TraceFlags.TRACE_PC_STATE) {
            this.traceComparison(filePreprocessorConditionState, n);
        }
        return n > 0;
    }

    public final boolean isEqual(FilePreprocessorConditionState filePreprocessorConditionState) {
        if (this == filePreprocessorConditionState) {
            return true;
        }
        if (this.size == filePreprocessorConditionState.size) {
            for (int i = 0; i < this.size; ++i) {
                if (this.offsets[i] == filePreprocessorConditionState.offsets[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final boolean isSubset(Collection<FilePreprocessorConditionState> collection) {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (FilePreprocessorConditionState filePreprocessorConditionState : collection) {
            if (filePreprocessorConditionState == null) {
                return false;
            }
            for (int i = 0; i < filePreprocessorConditionState.size; ++i) {
                treeSet.add(filePreprocessorConditionState.offsets[i]);
            }
        }
        Object object = new int[treeSet.size()];
        int n = 0;
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            object[n++] = n2;
        }
        return this.isSubset((int[])object, ((Object)object).length);
    }

    public final boolean isSubset(FilePreprocessorConditionState filePreprocessorConditionState) {
        return filePreprocessorConditionState == null ? false : this.isSubset(filePreprocessorConditionState.offsets, filePreprocessorConditionState.size);
    }

    public final boolean isSubset(int[] nArray, int n) {
        if (this.size <= n) {
            int n2 = 0;
            int n3 = 0;
            block0: while (n2 < this.size && n3 < n) {
                if (this.offsets[n2] == nArray[n3]) {
                    ++n2;
                    ++n3;
                    continue;
                }
                if (this.offsets[n2] < nArray[n3]) {
                    return false;
                }
                while (++n3 < n) {
                    if (this.offsets[n2] != nArray[n3]) continue;
                    ++n2;
                    ++n3;
                    continue block0;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private void traceComparison(FilePreprocessorConditionState filePreprocessorConditionState, int n) {
        System.err.printf("compareTo (%s): %s %s %s \n", this.fileName, FilePreprocessorConditionState.toStringBrief(this), n < 0 ? "<" : (n > 0 ? ">" : "="), FilePreprocessorConditionState.toStringBrief(filePreprocessorConditionState));
    }

    private int compareToImpl(FilePreprocessorConditionState filePreprocessorConditionState) {
        if (filePreprocessorConditionState == this) {
            return 0;
        }
        if (filePreprocessorConditionState == null) {
            return this.size > 0 ? 1 : 0;
        }
        if (this.size != filePreprocessorConditionState.size) {
            return this.size - filePreprocessorConditionState.size;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.offsets[i] == filePreprocessorConditionState.offsets[i]) continue;
            return filePreprocessorConditionState.offsets[i] - this.offsets[i];
        }
        return 0;
    }

    public String toString() {
        return FilePreprocessorConditionState.toStringBrief(this);
    }

    private static String toStringBrief(FilePreprocessorConditionState filePreprocessorConditionState) {
        if (filePreprocessorConditionState == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i = 0; i < filePreprocessorConditionState.size; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(filePreprocessorConditionState.offsets[i]);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

