/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import antlr.collections.AST;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameter;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameterType;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.BuiltinTypes;
import org.netbeans.modules.cnd.modelimpl.csm.Instantiation;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstRenderer;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Resolver;
import org.netbeans.modules.cnd.modelimpl.csm.core.ResolverFactory;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.parser.CsmAST;
import org.netbeans.modules.cnd.modelimpl.parser.FakeAST;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.utils.cache.TextCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeImpl
extends OffsetableBase
implements CsmType,
Resolver.SafeClassifierProvider,
Resolver.SafeTemplateBasedProvider {
    private final byte pointerDepth;
    private final boolean reference;
    private final byte arrayDepth;
    private final boolean _const;
    CharSequence classifierText;
    private int parseCount;
    final List<CsmType> instantiationParams = new ArrayList<CsmType>();
    CharSequence[] qname = null;
    private CsmUID<CsmClassifier> classifierUID;

    TypeImpl(CsmClassifier csmClassifier, int n, boolean bl, int n2, AST aST, CsmFile csmFile, CsmOffsetable csmOffsetable) {
        super(csmFile, csmOffsetable == null ? TypeImpl.getStartOffset(aST) : csmOffsetable.getStartOffset(), csmOffsetable == null ? TypeImpl.getEndOffset(aST) : csmOffsetable.getEndOffset());
        this._setClassifier(csmClassifier);
        this.pointerDepth = (byte)n;
        this.reference = bl;
        this.arrayDepth = (byte)n2;
        this._const = TypeImpl.initIsConst(aST);
        if (csmClassifier == null) {
            this._setClassifier(this.initClassifier(aST));
            this.classifierText = this.initClassifierText(aST);
        } else {
            CharSequence charSequence = csmClassifier.getName();
            this.classifierText = charSequence == null || charSequence.length() == 0 ? this.initClassifierText(aST) : charSequence;
        }
    }

    TypeImpl(CsmFile csmFile, int n, boolean bl, int n2, boolean bl2, int n3, int n4) {
        super(csmFile, n3, n4);
        this.pointerDepth = (byte)n;
        this.reference = bl;
        this.arrayDepth = (byte)n2;
        this._const = bl2;
    }

    TypeImpl(CsmType csmType) {
        super(csmType.getContainingFile(), csmType.getStartOffset(), csmType.getEndOffset());
        this.pointerDepth = (byte)csmType.getPointerDepth();
        this.reference = csmType.isReference();
        this.arrayDepth = (byte)csmType.getArrayDepth();
        this._const = csmType.isConst();
        if (csmType instanceof TypeImpl) {
            TypeImpl typeImpl = (TypeImpl)csmType;
            this.classifierUID = typeImpl.classifierUID;
            this.qname = typeImpl.qname;
            this.classifierText = typeImpl.classifierText;
            if (!typeImpl.instantiationParams.isEmpty()) {
                this.instantiationParams.addAll(typeImpl.instantiationParams);
            }
        }
    }

    public static int getEndOffset(AST aST) {
        AST aST2 = aST;
        if (aST2 == null) {
            return 0;
        }
        if ((aST2 = TypeImpl.getLastNode(aST2)) instanceof CsmAST) {
            return ((CsmAST)aST2).getEndOffset();
        }
        return OffsetableBase.getEndOffset(aST);
    }

    private static AST getLastNode(AST aST) {
        AST aST2;
        for (AST aST3 = aST2 = aST; aST3 != null; aST3 = aST3.getNextSibling()) {
            switch (aST3.getType()) {
                case 282: 
                case 314: 
                case 315: {
                    return AstUtil.getLastChildRecursively(aST2);
                }
            }
            aST2 = aST3;
        }
        return null;
    }

    public boolean isReference() {
        return this.reference;
    }

    public boolean isPointer() {
        return this.pointerDepth > 0;
    }

    public List<CsmType> getInstantiationParams() {
        return this.instantiationParams;
    }

    public boolean isInstantiation() {
        return !this.instantiationParams.isEmpty();
    }

    protected boolean isInstantiationOrSpecialization() {
        return !this.instantiationParams.isEmpty();
    }

    public boolean isTemplateBased() {
        return this.isTemplateBased(new HashSet<CsmType>());
    }

    @Override
    public boolean isTemplateBased(Set<CsmType> set) {
        CsmClassifier csmClassifier = this.getClassifier();
        if (CsmKindUtilities.isTypedef((CsmObject)csmClassifier)) {
            if (set.contains(this)) {
                return false;
            }
            set.add(this);
            CsmType csmType = ((CsmTypedef)csmClassifier).getType();
            if (csmType instanceof Resolver.SafeTemplateBasedProvider) {
                return ((Resolver.SafeTemplateBasedProvider)csmType).isTemplateBased(set);
            }
            return csmType.isTemplateBased();
        }
        return false;
    }

    public static boolean initIsConst(AST aST) {
        if (aST != null) {
            for (AST aST2 = aST; aST2 != null; aST2 = aST2.getNextSibling()) {
                int n = aST2.getType();
                if (AstRenderer.isConstQualifier(n)) {
                    return true;
                }
                if (n != 315 && n != 282) continue;
                return false;
            }
        }
        return false;
    }

    public boolean isConst() {
        return this._const;
    }

    public CharSequence getCanonicalText() {
        CharSequence charSequence = this.getClassifierText();
        if (this.isInstantiationOrSpecialization()) {
            charSequence = ((Object)charSequence).toString() + this.getInstantiationCanonicalText();
        }
        return this.decorateText(charSequence, this, true, null);
    }

    private CharSequence getInstantiationCanonicalText() {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.instantiationParams.isEmpty()) {
            stringBuilder.append('<');
            boolean bl = true;
            for (CsmType csmType : this.instantiationParams) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(',');
                }
                stringBuilder.append(this.getCanonicalText(csmType));
            }
            stringBuilder.append('>');
        }
        return stringBuilder;
    }

    private CharSequence getCanonicalText(CsmType csmType) {
        CsmTemplateParameterType csmTemplateParameterType;
        CsmTemplateParameter csmTemplateParameter;
        CharSequence charSequence = null;
        if (csmType instanceof CsmTemplateParameterType && CsmKindUtilities.isClassifierBasedTemplateParameter((CsmObject)(csmTemplateParameter = (csmTemplateParameterType = (CsmTemplateParameterType)csmType).getParameter()))) {
            CsmType csmType2 = (CsmType)csmTemplateParameter.getDefaultValue();
            charSequence = csmType2 == null ? "class" : this.getCanonicalText(csmType2);
        }
        if (charSequence == null) {
            charSequence = ((Object)csmType.getCanonicalText()).toString();
        }
        return charSequence;
    }

    CharSequence getOwnText() {
        if (this.qname != null && this.qname.length > 0) {
            return this.qname[this.qname.length - 1];
        }
        return "";
    }

    @Override
    public CharSequence getText() {
        return this.decorateText(((Object)this.getClassifierText()).toString() + TypeImpl.getInstantiationText(this), this, false, null).toString();
    }

    protected StringBuilder getText(boolean bl, CharSequence charSequence) {
        return this.decorateText(((Object)this.getClassifierText()).toString() + TypeImpl.getInstantiationText(this), this, bl, charSequence);
    }

    public StringBuilder decorateText(CharSequence charSequence, CsmType csmType, boolean bl, CharSequence charSequence2) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        if (csmType.isConst()) {
            stringBuilder.append("const ");
        }
        stringBuilder.append(charSequence);
        for (n = 0; n < csmType.getPointerDepth(); ++n) {
            stringBuilder.append('*');
        }
        if (csmType.isReference()) {
            stringBuilder.append('&');
        }
        for (n = 0; n < csmType.getArrayDepth(); ++n) {
            stringBuilder.append(bl ? "*" : "[]");
        }
        if (charSequence2 != null) {
            stringBuilder.append(' ');
            stringBuilder.append(charSequence2);
        }
        return stringBuilder;
    }

    CharSequence initClassifierText(AST aST) {
        if (aST == null) {
            CsmClassifier csmClassifier = this._getClassifier();
            return csmClassifier == null ? "" : csmClassifier.getName();
        }
        StringBuilder stringBuilder = new StringBuilder();
        TypeImpl.addText(stringBuilder, AstRenderer.getFirstSiblingSkipQualifiers(aST));
        return TextCache.getString((CharSequence)stringBuilder.toString());
    }

    private static void addText(StringBuilder stringBuilder, AST aST) {
        if (!(aST instanceof FakeAST)) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(aST.getText());
        }
        int n = 0;
        for (AST aST2 = aST.getFirstChild(); aST2 != null; aST2 = aST2.getNextSibling()) {
            if (aST2.getType() == 146) {
                ++n;
                continue;
            }
            if (aST2.getType() == 148) {
                --n;
                continue;
            }
            if (n != 0) continue;
            TypeImpl.addText(stringBuilder, aST2);
        }
    }

    public CsmClassifier getClassifier() {
        return this.getClassifier(null);
    }

    public static CharSequence getInstantiationText(CsmType csmType) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!csmType.getInstantiationParams().isEmpty()) {
            stringBuilder.append('<');
            boolean bl = true;
            for (CsmType csmType2 : csmType.getInstantiationParams()) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(',');
                }
                stringBuilder.append(csmType2.getText());
            }
            stringBuilder.append('>');
        }
        return stringBuilder;
    }

    public CharSequence getClassifierText() {
        return this.classifierText;
    }

    @Override
    public CsmClassifier getClassifier(Resolver resolver) {
        CsmClassifier csmClassifier = this._getClassifier();
        if (!CsmBaseUtilities.isValid((CsmObject)csmClassifier)) {
            int n;
            if (csmClassifier != null && (n = FileImpl.getParseCount()) == this.parseCount) {
                return csmClassifier;
            }
            this._setClassifier(null);
            if (this.qname != null) {
                this._setClassifier(this.renderClassifier(this.qname, resolver));
            } else if (this.classifierText.length() > 0) {
                this._setClassifier(this.renderClassifier(new CharSequence[]{this.classifierText}, resolver));
            }
            csmClassifier = this._getClassifier();
        }
        if (this.isInstantiation() && CsmKindUtilities.isTemplate((CsmObject)csmClassifier) && !((CsmTemplate)csmClassifier).getTemplateParameters().isEmpty()) {
            csmClassifier = (CsmClassifier)Instantiation.create((CsmTemplate)csmClassifier, this);
        }
        this.parseCount = FileImpl.getParseCount();
        return csmClassifier;
    }

    protected CsmClassifier renderClassifier(CharSequence[] charSequenceArray, Resolver resolver) {
        CsmObject csmObject;
        CsmClassifier csmClassifier = null;
        Resolver resolver2 = ResolverFactory.createResolver(this.getContainingFile(), this.getStartOffset(), resolver);
        if (this.isInstantiationOrSpecialization()) {
            int n;
            csmObject = new CharSequence[charSequenceArray.length];
            int n2 = charSequenceArray.length - 1;
            StringBuilder stringBuilder = new StringBuilder(charSequenceArray[n2]);
            stringBuilder.append('<');
            for (n = 0; n < this.instantiationParams.size(); ++n) {
                CsmType csmType = this.instantiationParams.get(n);
                if (n > 0) {
                    stringBuilder.append(',');
                }
                CharSequence charSequence = this.getCanonicalText(csmType);
                stringBuilder.append(charSequence);
            }
            stringBuilder.append('>');
            csmObject[n2] = stringBuilder.toString();
            for (n = 0; n < n2; ++n) {
                csmObject[n] = charSequenceArray[n];
            }
            CsmObject csmObject2 = resolver2.resolve((CharSequence[])csmObject, 2);
            if (CsmKindUtilities.isClassifier((CsmObject)csmObject2)) {
                csmClassifier = (CsmClassifier)csmObject2;
            }
            if (csmClassifier == null) {
                csmObject[n2] = ((Object)charSequenceArray[n2]).toString() + "<>";
                csmObject2 = resolver2.resolve((CharSequence[])csmObject, 2);
                if (CsmKindUtilities.isClassifier((CsmObject)csmObject2)) {
                    csmClassifier = (CsmClassifier)csmObject2;
                }
            }
        }
        if (csmClassifier == null && CsmKindUtilities.isClassifier((CsmObject)(csmObject = resolver2.resolve(charSequenceArray, 2)))) {
            csmClassifier = (CsmClassifier)csmObject;
        }
        if (csmClassifier == null) {
            csmClassifier = ((ProjectBase)this.getContainingFile().getProject()).getDummyForUnresolved(charSequenceArray, this.getContainingFile(), this.getStartOffset());
        }
        return csmClassifier;
    }

    private CsmClassifier initClassifier(AST aST) {
        AST aST2 = AstRenderer.getFirstSiblingSkipQualifiers(aST);
        if (aST2 == null || aST2.getType() != 253 && aST2.getType() != 254 && aST2.getType() != 282) {
            return null;
        }
        if (aST2.getType() == 253) {
            return BuiltinTypes.getBuiltIn(aST2);
        }
        try {
            CsmAST csmAST = (CsmAST)aST2.getFirstChild();
            if (csmAST == null) {
                return null;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = 0;
            for (CsmAST csmAST2 = csmAST; csmAST2 != null; csmAST2 = csmAST2.getNextSibling()) {
                if (n == 0 && csmAST2.getType() == 204) {
                    arrayList.add(csmAST2.getText());
                    continue;
                }
                if (csmAST2.getType() == 146) {
                    ++n;
                    continue;
                }
                if (csmAST2.getType() == 148) {
                    --n;
                    continue;
                }
                if (n == 0) {
                    if (csmAST2.getType() == 177 || !TraceFlags.DEBUG) continue;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append('[').append(csmAST2.getText());
                    if (csmAST2.getNumberOfChildren() == 0) {
                        stringBuilder.append(", line=").append(csmAST2.getLine());
                        stringBuilder.append(", column=").append(csmAST2.getColumn());
                    }
                    stringBuilder.append(']');
                    System.err.println("Incorect token: expected '::', found " + stringBuilder.toString());
                    continue;
                }
                if (csmAST2.getType() != 253 && csmAST2.getType() != 254) continue;
                this.instantiationParams.add(AstRenderer.renderType((AST)csmAST2, this.getContainingFile()));
            }
            this.qname = arrayList.toArray(new String[arrayList.size()]);
        }
        catch (Exception exception) {
            DiagnosticExceptoins.register(exception);
        }
        return null;
    }

    public int getArrayDepth() {
        return this.arrayDepth;
    }

    public int getPointerDepth() {
        return this.pointerDepth;
    }

    protected CsmClassifier _getClassifier() {
        CsmClassifier csmClassifier = UIDCsmConverter.UIDtoDeclaration(this.classifierUID);
        return csmClassifier;
    }

    void _setClassifier(CsmClassifier csmClassifier) {
        this.classifierUID = UIDCsmConverter.declarationToUID(csmClassifier);
        assert (this.classifierUID != null || csmClassifier == null);
    }

    public boolean isBuiltInBased(boolean bl) {
        CsmClassifier csmClassifier;
        if (bl) {
            csmClassifier = this.getClassifier();
            if (CsmKindUtilities.isTypedef((CsmObject)csmClassifier)) {
                return ((CsmTypedef)csmClassifier).getType().isBuiltInBased(true);
            }
        } else {
            csmClassifier = this._getClassifier();
        }
        return CsmKindUtilities.isBuiltIn((CsmObject)csmClassifier);
    }

    @Override
    public String toString() {
        return "TYPE " + this.getText() + this.getOffsetString();
    }

    String getVariableDisplayName(String string) {
        return this.decorateText(this.getClassifierText(), this, false, string).toString();
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        dataOutput.writeInt(this.pointerDepth);
        dataOutput.writeBoolean(this.reference);
        dataOutput.writeInt(this.arrayDepth);
        dataOutput.writeBoolean(this._const);
        assert (this.classifierText != null);
        dataOutput.writeUTF(((Object)this.classifierText).toString());
        PersistentUtils.writeStrings(this.qname, dataOutput);
        PersistentUtils.writeTypes(this.instantiationParams, dataOutput);
        UIDObjectFactory.getDefaultFactory().writeUID(this.classifierUID, dataOutput);
    }

    public TypeImpl(DataInput dataInput) throws IOException {
        super(dataInput);
        this.pointerDepth = (byte)dataInput.readInt();
        this.reference = dataInput.readBoolean();
        this.arrayDepth = (byte)dataInput.readInt();
        this._const = dataInput.readBoolean();
        this.classifierText = NameCache.getManager().getString((CharSequence)dataInput.readUTF());
        assert (this.classifierText != null);
        this.qname = PersistentUtils.readStrings(dataInput, NameCache.getManager());
        PersistentUtils.readTypes(this.instantiationParams, dataInput);
        this.classifierUID = UIDObjectFactory.getDefaultFactory().readUID(dataInput);
    }
}

