/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import antlr.collections.AST;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameter;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateUtils;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TemplateDescriptor {
    private final List<CsmTemplateParameter> templateParams;
    private final CharSequence templateSuffix;
    private final int inheritedTemplateParametersNumber;

    public TemplateDescriptor(List<CsmTemplateParameter> list, CharSequence charSequence) {
        this.templateParams = list;
        this.templateSuffix = charSequence;
        this.inheritedTemplateParametersNumber = 0;
    }

    public TemplateDescriptor(List<CsmTemplateParameter> list, CharSequence charSequence, int n) {
        this.templateParams = list;
        this.templateSuffix = charSequence;
        this.inheritedTemplateParametersNumber = n;
    }

    public List<CsmTemplateParameter> getTemplateParameters() {
        return this.templateParams != null ? this.templateParams : Collections.emptyList();
    }

    public CharSequence getTemplateSuffix() {
        return this.templateSuffix;
    }

    public int getInheritedTemplateParametersNumber() {
        return this.inheritedTemplateParametersNumber;
    }

    public static TemplateDescriptor createIfNeeded(AST aST, CsmFile csmFile, CsmScope csmScope) {
        AST aST2;
        if (aST == null) {
            return null;
        }
        for (AST aST3 = aST2 = TemplateUtils.getTemplateStart(aST.getFirstChild()); aST3 != null; aST3 = aST3.getNextSibling()) {
            if (aST3.getType() != 31) continue;
            return new TemplateDescriptor(TemplateUtils.getTemplateParameters(aST3, csmFile, csmScope), '<' + TemplateUtils.getClassSpecializationSuffix(aST3, null) + '>');
        }
        return null;
    }

    public String toString() {
        return ((Object)this.getTemplateSuffix()).toString();
    }

    public void write(DataOutput dataOutput) throws IOException {
        PersistentUtils.writeTemplateParameters(this.templateParams, dataOutput);
        dataOutput.writeUTF(((Object)this.templateSuffix).toString());
    }
}

