/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.modelimpl.csm.core.Unresolved;
import org.netbeans.modules.cnd.modelimpl.textcache.QualifiedNameCache;
import org.netbeans.modules.cnd.utils.cache.CharSequenceKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemMacroImpl
implements CsmMacro {
    private final CharSequence macroName;
    private final CharSequence macroBody;
    private final boolean isUserDefined;
    private final List<? extends CharSequence> params;
    private CsmFile containingFile;
    private CsmUID<CsmMacro> uid;

    public SystemMacroImpl(String string, String string2, List<String> list, CsmFile csmFile, boolean bl) {
        this.macroName = QualifiedNameCache.getManager().getString((CharSequence)string);
        this.macroBody = QualifiedNameCache.getManager().getString((CharSequence)string2);
        this.isUserDefined = bl;
        this.params = list != null ? Collections.unmodifiableList(list) : null;
        assert (csmFile instanceof Unresolved.UnresolvedFile);
        this.containingFile = csmFile;
        this.uid = new SelfUID<SystemMacroImpl>(this);
    }

    public List<? extends CharSequence> getParameters() {
        return this.params;
    }

    public CharSequence getBody() {
        return this.macroBody;
    }

    public boolean isSystem() {
        return true;
    }

    public CharSequence getName() {
        return this.macroName;
    }

    public CsmFile getContainingFile() {
        return this.containingFile;
    }

    public int getStartOffset() {
        return 0;
    }

    public int getEndOffset() {
        return 0;
    }

    public CsmOffsetable.Position getStartPosition() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CsmOffsetable.Position getEndPosition() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CharSequence getText() {
        return "#define " + this.macroName + " " + this.macroBody;
    }

    public CsmUID<CsmMacro> getUID() {
        return this.uid;
    }

    public boolean equals(Object object) {
        boolean bl;
        if (object == null || !(object instanceof SystemMacroImpl)) {
            bl = false;
        } else {
            SystemMacroImpl systemMacroImpl = (SystemMacroImpl)object;
            bl = CharSequenceKey.Comparator.compare(this.getName(), systemMacroImpl.getName()) == 0;
        }
        return bl;
    }

    public int hashCode() {
        int n = 7;
        n = 79 * n + (this.macroName != null ? this.macroName.hashCode() : 0);
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("#define '");
        stringBuilder.append(this.getName());
        if (this.getParameters() != null) {
            stringBuilder.append("[");
            Iterator<? extends CharSequence> iterator = this.getParameters().iterator();
            while (iterator.hasNext()) {
                CharSequence charSequence = iterator.next();
                stringBuilder.append(charSequence);
                if (!iterator.hasNext()) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append("]");
        }
        if (this.getBody().length() > 0) {
            stringBuilder.append("'='");
            stringBuilder.append(this.getBody());
        }
        stringBuilder.append("' [" + (this.isUserDefined ? "user defined" : "system") + "]");
        return stringBuilder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SelfUID<T>
    implements CsmUID<T> {
        private final T element;

        SelfUID(T t) {
            this.element = t;
        }

        public T getObject() {
            return this.element;
        }
    }
}

