/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableIdentifiableBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectImpl;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.textcache.FileNameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;
import org.netbeans.modules.cnd.utils.cache.CharSequenceKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncludeImpl
extends OffsetableIdentifiableBase<CsmInclude>
implements CsmInclude {
    private final CharSequence name;
    private final boolean system;
    private CsmUID<CsmFile> includeFileUID;

    public IncludeImpl(String string, boolean bl, CsmFile csmFile, CsmFile csmFile2, CsmOffsetable csmOffsetable) {
        super(csmFile2, csmOffsetable);
        this.name = FileNameCache.getManager().getString((CharSequence)string);
        this.system = bl;
        this.includeFileUID = UIDCsmConverter.fileToUID(csmFile);
        assert (this.includeFileUID != null || csmFile == null);
    }

    public CsmFile getIncludeFile() {
        return this._getIncludeFile();
    }

    public CharSequence getIncludeName() {
        return this.name;
    }

    public boolean isSystem() {
        return this.system;
    }

    @Override
    public String toString() {
        char c = this.isSystem() ? (char)'<' : '\"';
        char c2 = this.isSystem() ? (char)'>' : '\"';
        String string = "";
        if (this.getContainingFile() == null) {
            string = "<NO CONTAINER INFO> ";
        }
        return string + c + this.getIncludeName() + c2 + (this.getIncludeFile() == null ? " <FAILED inclusion>" : "") + " [" + this.getStartPosition() + "-" + this.getEndPosition() + "]";
    }

    @Override
    public boolean equals(Object object) {
        boolean bl;
        if (object == null || !(object instanceof IncludeImpl)) {
            bl = false;
        } else {
            IncludeImpl includeImpl = (IncludeImpl)object;
            bl = IncludeImpl.equals(this, includeImpl);
        }
        return bl;
    }

    private static final boolean equals(IncludeImpl includeImpl, IncludeImpl includeImpl2) {
        return CharSequenceKey.Comparator.compare(includeImpl.getIncludeName(), includeImpl2.getIncludeName()) == 0 && includeImpl.system == includeImpl2.system && includeImpl.getStartOffset() == includeImpl2.getStartOffset();
    }

    @Override
    public int hashCode() {
        int n = 17 * (this.isSystem() ? 1 : -1);
        n = 31 * n + this.getStartOffset();
        n = 31 * n + this.getIncludeName().hashCode();
        return n;
    }

    private CsmFile _getIncludeFile() {
        CsmProject csmProject;
        CsmFile csmFile;
        CsmFile csmFile2 = UIDCsmConverter.UIDtoFile(this.includeFileUID);
        if (csmFile2 == null && this.includeFileUID != null) {
            this.includeFileUID = null;
        }
        if (TraceFlags.NEED_TO_TRACE_UNRESOLVED_INCLUDE && csmFile2 == null && "yes".equals(System.getProperty("cnd.modelimpl.trace.trace_now")) && (csmFile = this.getContainingFile()) != null && (csmProject = csmFile.getProject()) instanceof ProjectImpl) {
            System.out.println("File " + csmFile.getAbsolutePath());
            ProjectImpl projectImpl = (ProjectImpl)csmProject;
            boolean bl = false;
            for (CsmFile csmFile3 : projectImpl.getGraph().getTopParentFiles(csmFile)) {
                if (csmFile == csmFile3) continue;
                System.out.println("  icluded from " + csmFile3.getAbsolutePath());
                bl = true;
            }
            if (!bl) {
                System.out.println("  there are no files included the file");
            }
        }
        return csmFile2;
    }

    @Override
    protected CsmUID createUID() {
        return UIDUtilities.createIncludeUID(this);
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        assert (this.name != null);
        dataOutput.writeUTF(((Object)this.name).toString());
        dataOutput.writeBoolean(this.system);
        UIDObjectFactory.getDefaultFactory().writeUID(this.includeFileUID, dataOutput);
    }

    public IncludeImpl(DataInput dataInput) throws IOException {
        super(dataInput);
        this.name = FileNameCache.getManager().getString((CharSequence)dataInput.readUTF());
        assert (this.name != null);
        this.system = dataInput.readBoolean();
        this.includeFileUID = UIDObjectFactory.getDefaultFactory().readUID(dataInput);
    }
}

