/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.cache.impl;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.modelimpl.cache.impl.FileCacheSyncBridge;
import org.netbeans.modules.cnd.modelimpl.cache.impl.ProjectIndex;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;

final class ProjectCache {
    private ProjectIndex index;
    private Map cachedFiles;
    private boolean loaded = false;
    private final String loadLock = new String("ProjectCache load lock");

    public ProjectCache(String string) {
        new File(string).mkdirs();
        this.load(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileCacheSyncBridge getSyncCacheBridge(FileImpl fileImpl) {
        Map map = this.cachedFiles;
        synchronized (map) {
            String string = fileImpl.getAbsolutePath();
            FileCacheSyncBridge fileCacheSyncBridge = (FileCacheSyncBridge)this.cachedFiles.get(string);
            if (fileCacheSyncBridge == null) {
                if (TraceFlags.TRACE_CACHE) {
                    System.err.println("CACHE: creating FileCacheSyncBridge cache for " + string);
                }
                fileCacheSyncBridge = new FileCacheSyncBridge(fileImpl);
                this.cachedFiles.put(string, fileCacheSyncBridge);
            }
            return fileCacheSyncBridge;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateFile(String string) {
        Object object;
        Object object2 = this.cachedFiles;
        synchronized (object2) {
            if (TraceFlags.TRACE_CACHE) {
                System.err.println("CACHE: remove FileCacheSyncBridge cache for " + string);
            }
            if ((object = (FileCacheSyncBridge)this.cachedFiles.remove(string)) != null) {
                ((FileCacheSyncBridge)object).invalidate();
            } else if (TraceFlags.TRACE_CACHE) {
                System.err.println("CACHE: (invalidateFile) not exists FileCacheSyncBridge cache for " + string);
            }
        }
        object2 = this.getIndex();
        if (object2 != null) {
            object = object2;
            synchronized (object) {
                ((ProjectIndex)object2).invalidateFile(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProjectIndex getIndex() {
        ProjectIndex projectIndex = null;
        String string = this.loadLock;
        synchronized (string) {
            if (this.loaded) {
                projectIndex = this.index;
            }
        }
        return projectIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(String string) {
        if (TraceFlags.TRACE_CACHE) {
            System.err.println("CACHE: saving project cache data in " + string);
        }
        String string2 = this.loadLock;
        synchronized (string2) {
            this.storeIndex(string);
        }
    }

    void close(String string) {
        this.store(string);
        this.index = null;
        this.cachedFiles = null;
        this.loaded = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(String string) {
        if (!this.loaded) {
            String string2 = this.loadLock;
            synchronized (string2) {
                if (!this.loaded) {
                    this.index = new ProjectIndex();
                    this.loadIndex(string);
                    this.cachedFiles = new HashMap();
                    this.loaded = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadIndex(String string) {
        assert (this.index != null);
        File file = this.getProjectIndexFile(string);
        boolean bl = false;
        ProjectIndex projectIndex = this.index;
        synchronized (projectIndex) {
            bl = this.index.load(file);
        }
        if (TraceFlags.TRACE_CACHE) {
            if (bl) {
                System.err.println("CACHE: loaded project index:" + file.getAbsolutePath());
                projectIndex = this.index;
                synchronized (projectIndex) {
                    System.err.println("CACHE: " + this.index);
                }
            } else {
                System.err.println("CACHE: project index not found:" + file.getAbsolutePath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeIndex(String string) {
        if (this.index == null) {
            return;
        }
        File file = this.getProjectIndexFile(string);
        boolean bl = false;
        ProjectIndex projectIndex = this.index;
        synchronized (projectIndex) {
            bl = this.index.save(file);
        }
        if (TraceFlags.TRACE_CACHE) {
            if (bl) {
                System.err.println("CACHE: saved project index:" + file.getAbsolutePath());
                projectIndex = this.index;
                synchronized (projectIndex) {
                    System.err.println("project index:" + this.index.toString());
                }
            } else {
                System.err.println("CACHE: errors on saving project index:" + file.getAbsolutePath());
            }
        }
    }

    private File getProjectIndexFile(String string) {
        String string2 = string + File.separatorChar + "project.dat";
        File file = new File(string2);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CharSequence getValidCacheFileName(FileImpl fileImpl, boolean bl) {
        ProjectIndex projectIndex = this.getIndex();
        if (projectIndex == null) {
            return null;
        }
        CharSequence charSequence = null;
        if (fileImpl.getBuffer().isFileBased()) {
            long l = fileImpl.getBuffer().getFile().lastModified();
            ProjectIndex.Entry entry = null;
            ProjectIndex projectIndex2 = projectIndex;
            synchronized (projectIndex2) {
                entry = projectIndex.getFileEntry(fileImpl);
                if (entry == null) {
                    entry = projectIndex.putFile(fileImpl);
                }
                if (bl) {
                    entry.setLastModified(l);
                }
            }
            assert (entry != null);
            if (bl) {
                charSequence = entry.getCacheFileName();
            } else if (entry.getLastModified() == l) {
                charSequence = entry.getCacheFileName();
            } else if (TraceFlags.TRACE_CACHE) {
                System.err.println("CACHE: file " + fileImpl.getAbsolutePath() + " was modified " + l + " vs. entry=" + entry.getLastModified());
            }
        }
        return TraceFlags.CACHE_SKIP_SAVE ? null : charSequence;
    }
}

