/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.project.wizard.element;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.api.project.Project;
import org.netbeans.modules.xml.catalogsupport.util.ProjectUtilities;
import org.netbeans.modules.xml.catalogsupport.util.ProjectWSDL;
import org.netbeans.modules.xml.ui.UI;
import org.netbeans.modules.xslt.project.wizard.element.Panel;
import org.netbeans.modules.xslt.project.wizard.element.PanelUtil;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PanelWebService<T>
extends Panel<T> {
    private String myFileLabelString;
    private JButton myBrowse;
    private JComboBox myWSDL;
    private JLabel myFileLabel;
    private FileObject myFile;

    PanelWebService(Project project, Panel<T> panel) {
        this(project, panel, null);
    }

    PanelWebService(Project project, Panel<T> panel, String string) {
        super(project, panel);
        this.myFileLabelString = string;
    }

    @Override
    protected String getError() {
        this.myFile = this.getWSDL();
        if (this.myFile == null) {
            return this.i18n("ERR_Web_Service_Is_Required");
        }
        return null;
    }

    @Override
    protected Object getResult() {
        return PanelUtil.getWSDLModel(this.myFile);
    }

    @Override
    protected void createPanel(JPanel jPanel, GridBagConstraints gridBagConstraints) {
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 17;
        ++gridBagConstraints2.gridy;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.insets = new Insets(2, 0, 2, 0);
        if (this.myFileLabelString == null) {
            this.myFileLabelString = this.i18n("LBL_Web_Service_File");
        }
        this.myFileLabel = UI.createLabel((String)this.myFileLabelString);
        UI.a11y((Component)this.myFileLabel, (String)"ACSN_LBL_Web_Service_File", (String)"ACSD_LBL_Web_Service_File");
        jPanel2.add((Component)this.myFileLabel, gridBagConstraints2);
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(2, 8, 2, 0);
        this.myWSDL = new JComboBox();
        this.myWSDL.setRenderer(new Panel.Renderer());
        this.myFileLabel.setLabelFor(this.myWSDL);
        jPanel2.add((Component)this.myWSDL, gridBagConstraints2);
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.insets = new Insets(2, 8, 2, 0);
        this.myBrowse = UI.createButton((Action)new UI.ButtonAction(this.i18n("LBL_Browse_WSDL"), this.i18n("TLT_Browse_WSDL")){

            public void actionPerformed(ActionEvent actionEvent) {
                UI.printInformation((String)"Dialog will be implemented by xml team, see issue 93596.");
            }
        });
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.update();
    }

    private ItemListener createItemListener(final boolean bl) {
        return new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                PanelWebService.this.setEnabled(bl);
            }
        };
    }

    @Override
    protected void setEnabled(boolean bl) {
        this.myWSDL.setEnabled(bl);
        this.myBrowse.setEnabled(bl);
        this.myFileLabel.setEnabled(bl);
    }

    @Override
    protected void update() {
        this.myWSDL.removeAllItems();
        List list = ProjectUtilities.getProjectWSDLRecursively((Project)this.getProject());
        for (ProjectWSDL projectWSDL : list) {
            this.myWSDL.addItem(projectWSDL);
        }
    }

    private FileObject getWSDL() {
        if (this.myWSDL.getItemCount() == 0) {
            return null;
        }
        return ((ProjectWSDL)this.myWSDL.getSelectedItem()).getFile();
    }
}

