/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.project.wizard.element;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.api.project.Project;
import org.netbeans.modules.xml.ui.UI;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.OperationParameter;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.PartnerLinkType;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.Role;
import org.netbeans.modules.xml.wsdl.model.visitor.WSDLModelVisitor;
import org.netbeans.modules.xml.wsdl.model.visitor.WSDLUtilities;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.netbeans.modules.xslt.project.wizard.element.Panel;
import org.netbeans.modules.xslt.project.wizard.element.PanelUtil;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PanelOperation<T>
extends Panel<T> {
    private JTextField myFile;
    private JButton myBrowseButton;
    private JComboBox myPortType;
    private JComboBox myPartnerRolePort;
    private JComboBox myOperation;
    private JTextField myInput;
    private JTextField myOutput;
    private WSDLModel myModel;
    private String myFileName;
    private boolean myIsReadOnly;
    private boolean myIsInput;
    private boolean myIsInputRequired;
    private boolean myIsOutputRequired;
    private WizardDescriptor myWizardDescriptor;
    private static final String PART_IN_NAME = "PartIn";
    private static final String PART_OUT_NAME = "PartOut";
    private static final String MESSAGE_IN_NAME = "MessageIn";
    private static final String MESSAGE_OUT_NAME = "MessageOut";

    PanelOperation(Project project, Panel<T> panel, WSDLModel wSDLModel, String string, boolean bl, boolean bl2) {
        super(project, panel);
        this.myModel = wSDLModel;
        this.myFileName = string;
        this.myIsReadOnly = bl;
        this.myIsInput = bl2;
        this.myIsInputRequired = true;
        this.myIsOutputRequired = true;
    }

    @Override
    protected Object getResult() {
        return this.getOperation();
    }

    @Override
    protected String getError() {
        Object object;
        if (this.myFileName != null) {
            object = this.myFile.getText().trim();
            if (!PanelUtil.isValidFileName((String)object)) {
                return this.i18n("ERR_WrongFileName", (String)object);
            }
            String string = this.addExtension((String)object);
            FileObject fileObject = this.getFolder().getFileObject(string);
        }
        if ((object = this.getOperation()) == null) {
            return this.i18n("ERR_Operation_Is_Required");
        }
        if (this.myIsInputRequired && !this.check((OperationParameter)object.getInput())) {
            return this.i18n("ERR_Operation_With_Input_Is_Required");
        }
        if (this.myIsOutputRequired && !this.check((OperationParameter)object.getOutput())) {
            return this.i18n("ERR_Operation_With_Output_Is_Required");
        }
        return null;
    }

    private boolean check(OperationParameter operationParameter) {
        return operationParameter != null && operationParameter.getMessage() != null && operationParameter.getMessage().get() != null;
    }

    @Override
    public void readSettings(Object object) {
        this.myWizardDescriptor = (WizardDescriptor)object;
    }

    @Override
    public void storeSettings(Object object) {
        WizardDescriptor wizardDescriptor = (WizardDescriptor)object;
        if (this.myFileName != null) {
            String string = this.addExtension(this.myFile.getText().trim());
            if (this.myIsInput) {
                wizardDescriptor.putProperty("input.file", (Object)string);
            } else {
                wizardDescriptor.putProperty("output.file", (Object)string);
            }
        }
        if (this.myIsInput) {
            wizardDescriptor.putProperty("input.operation", (Object)this.getOperation());
            wizardDescriptor.putProperty("input.partner.role.port", (Object)this.getPartnerRolePort());
        } else {
            wizardDescriptor.putProperty("output.operation", (Object)this.getOperation());
            wizardDescriptor.putProperty("output.partner.role.port", (Object)this.getPartnerRolePort());
        }
    }

    void setRequirement(boolean bl, boolean bl2) {
        this.myIsInputRequired = bl;
        this.myIsOutputRequired = bl2;
    }

    @Override
    protected void createPanel(JPanel jPanel, GridBagConstraints gridBagConstraints) {
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 17;
        this.createFilePanel(jPanel2, gridBagConstraints2);
        ++gridBagConstraints2.gridy;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.insets = new Insets(2, 0, 2, 0);
        JLabel jLabel = UI.createLabel((String)this.i18n(this.myIsInput ? "LBL_Operation" : "LBL_Operation2"));
        UI.a11y((Component)jLabel, (String)"ACSN_LBL_Operation", (String)"ACSD_LBL_Operation");
        jPanel2.add((Component)jLabel, gridBagConstraints2);
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.insets = new Insets(2, 8, 2, 0);
        this.myOperation = new JComboBox();
        this.myOperation.setRenderer(new Panel.Renderer());
        this.myOperation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PanelOperation.this.updateTypes();
            }
        });
        jLabel.setLabelFor(this.myOperation);
        jPanel2.add((Component)this.myOperation, gridBagConstraints2);
        if (!this.myIsReadOnly) {
            gridBagConstraints2.weightx = 0.0;
            this.createTypePanel(jPanel2, gridBagConstraints2);
        }
        if (this.myFileName != null) {
            ++gridBagConstraints2.gridy;
            gridBagConstraints2.weightx = 0.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        }
        this.updatePartnerRolePorts(null);
        jPanel.add((Component)jPanel2, gridBagConstraints);
    }

    private void createFilePanel(JPanel jPanel, GridBagConstraints gridBagConstraints) {
        JLabel jLabel;
        if (this.myFileName != null) {
            ++gridBagConstraints.gridy;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridy = gridBagConstraints.gridy;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.insets = new Insets(2, 0, 2, 0);
            jLabel = UI.createLabel((String)this.i18n(this.myIsInput ? "LBL_XSL_File" : "LBL_XSL_File2"));
            UI.a11y((Component)jLabel, (String)"ACSN_LBL_XSL_File", (String)"ACSD_LBL_XSL_File");
            jPanel.add((Component)jLabel, gridBagConstraints2);
            gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridy = gridBagConstraints.gridy;
            gridBagConstraints2.insets = new Insets(2, 8, 2, 0);
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.weightx = 1.0;
            this.myFile = new JTextField(this.myFileName);
            jLabel.setLabelFor(this.myFile);
            jPanel.add((Component)this.myFile, gridBagConstraints2);
            this.myBrowseButton = this.createBrowseButton(this.myFile);
            gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridy = gridBagConstraints.gridy;
            gridBagConstraints2.insets = new Insets(2, 8, 2, 0);
            jPanel.add((Component)this.myBrowseButton, gridBagConstraints2);
        }
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        jLabel = UI.createLabel((String)this.i18n(this.myIsInput ? "LBL_Partner_Role_Port" : "LBL_Partner_Role_Port2"));
        UI.a11y((Component)jLabel, (String)"ACSN_LBL_Partner_Role_Port", (String)"ACSD_LBL_Partner_Role_Port");
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 8, 2, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        this.myPartnerRolePort = new JComboBox();
        this.myPartnerRolePort.setRenderer(new Panel.Renderer());
        this.myPartnerRolePort.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PanelOperation.this.update();
            }
        });
        jLabel.setLabelFor(this.myPartnerRolePort);
        jPanel.add((Component)this.myPartnerRolePort, gridBagConstraints);
    }

    private void createTypePanel(JPanel jPanel, GridBagConstraints gridBagConstraints) {
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        JLabel jLabel = UI.createLabel((String)this.i18n("LBL_Input_Type"));
        UI.a11y((Component)jLabel, (String)"ACSN_LBL_Input_Type", (String)"ACSD_LBL_Input_Type");
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 8, 2, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        this.myInput = new JTextField();
        this.myInput.setEditable(false);
        jLabel.setLabelFor(this.myInput);
        jPanel.add((Component)this.myInput, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        jLabel = UI.createLabel((String)this.i18n("LBL_Output_Type"));
        UI.a11y((Component)jLabel, (String)"ACSN_LBL_Output_Type", (String)"ACSD_LBL_Output_Type");
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 8, 2, 0);
        gridBagConstraints.fill = 2;
        this.myOutput = new JTextField();
        this.myOutput.setEditable(false);
        jLabel.setLabelFor(this.myOutput);
        jPanel.add((Component)this.myOutput, gridBagConstraints);
    }

    private void updatePortTypes(PortType portType) {
        PortType[] portTypeArray;
        this.myPortType.removeAllItems();
        for (PortType portType2 : portTypeArray = this.getPortTypes()) {
            this.myPortType.addItem(portType2);
        }
        if (portType != null) {
            this.myPortType.setSelectedItem(portType);
        }
        this.update();
    }

    private PortType[] getPortTypes() {
        final ArrayList arrayList = new ArrayList();
        WSDLUtilities.visitRecursively((WSDLModel)this.myModel, (WSDLModelVisitor)new WSDLModelVisitor(){

            public void visit(WSDLModel wSDLModel) {
                Definitions definitions = wSDLModel.getDefinitions();
                Collection collection = definitions.getPortTypes();
                if (collection != null) {
                    arrayList.addAll(collection);
                }
            }
        });
        return arrayList.toArray(new PortType[arrayList.size()]);
    }

    private void updatePartnerRolePorts(Panel.PartnerRolePort partnerRolePort) {
        Panel.PartnerRolePort[] partnerRolePortArray;
        this.myPartnerRolePort.removeAllItems();
        for (Panel.PartnerRolePort partnerRolePort2 : partnerRolePortArray = this.getPartnerRolePorts()) {
            this.myPartnerRolePort.addItem(partnerRolePort2);
        }
        if (partnerRolePort != null) {
            this.myPartnerRolePort.setSelectedItem(partnerRolePort);
        }
        this.update();
    }

    private Panel.PartnerRolePort[] getPartnerRolePorts() {
        final ArrayList arrayList = new ArrayList();
        WSDLUtilities.visitRecursively((WSDLModel)this.myModel, (WSDLModelVisitor)new WSDLModelVisitor(){

            public void visit(WSDLModel wSDLModel) {
                Definitions definitions = wSDLModel.getDefinitions();
                List list = definitions.getExtensibilityElements();
                for (ExtensibilityElement extensibilityElement : list) {
                    if (!(extensibilityElement instanceof PartnerLinkType)) continue;
                    PartnerLinkType partnerLinkType = (PartnerLinkType)extensibilityElement;
                    PanelOperation.this.processRole(partnerLinkType, partnerLinkType.getRole1(), arrayList);
                    PanelOperation.this.processRole(partnerLinkType, partnerLinkType.getRole2(), arrayList);
                }
            }
        });
        return arrayList.toArray(new Panel.PartnerRolePort[arrayList.size()]);
    }

    private void processRole(PartnerLinkType partnerLinkType, Role role, List<Panel.PartnerRolePort> list) {
        Panel.PartnerRolePort partnerRolePort;
        if (role == null) {
            return;
        }
        NamedComponentReference namedComponentReference = role.getPortType();
        if (namedComponentReference == null) {
            return;
        }
        PortType portType = (PortType)namedComponentReference.get();
        if (portType != null && !list.contains(partnerRolePort = new Panel.PartnerRolePort(partnerLinkType, role, portType))) {
            list.add(partnerRolePort);
        }
    }

    @Override
    protected void update() {
        Operation[] operationArray;
        this.myOperation.removeAllItems();
        for (Operation operation : operationArray = this.getOperations(this.getPartnerRolePort())) {
            this.myOperation.addItem(operation);
        }
        this.updateTypes();
    }

    private Operation[] getOperations(Panel.PartnerRolePort partnerRolePort) {
        ArrayList<Operation> arrayList = new ArrayList<Operation>();
        if (partnerRolePort != null) {
            Collection collection = partnerRolePort.getPortType().getOperations();
            for (Operation operation : collection) {
                arrayList.add(operation);
            }
        }
        return arrayList.toArray(new Operation[arrayList.size()]);
    }

    private Operation[] getOperations(PortType portType) {
        Collection collection;
        ArrayList<Operation> arrayList = new ArrayList<Operation>();
        if (portType != null && (collection = portType.getOperations()) != null) {
            for (Operation operation : collection) {
                arrayList.add(operation);
            }
        }
        return arrayList.toArray(new Operation[arrayList.size()]);
    }

    @Override
    protected void setEnabled(boolean bl) {
        if (this.myFileName != null) {
            this.myFile.setEnabled(bl);
        }
    }

    private void updateTypes() {
        this.getParent().update();
        if (this.myIsReadOnly) {
            return;
        }
        Operation operation = this.getOperation();
        if (operation == null) {
            this.myInput.setText("");
            this.myOutput.setText("");
            return;
        }
        this.myInput.setText(this.getType((OperationParameter)operation.getInput()));
        this.myOutput.setText(this.getType((OperationParameter)operation.getOutput()));
    }

    private Operation getOperation() {
        return (Operation)this.myOperation.getSelectedItem();
    }

    private PortType getPortType() {
        return (PortType)this.myPortType.getSelectedItem();
    }

    private Panel.PartnerRolePort getPartnerRolePort() {
        return (Panel.PartnerRolePort)this.myPartnerRolePort.getSelectedItem();
    }
}

