/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.php.findusages;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsf.api.Index;
import org.netbeans.modules.gsf.api.Modifier;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.php.editor.index.IndexedElement;
import org.netbeans.modules.php.editor.index.PHPIndex;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayAccess;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.StaticConstantAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticFieldAccess;
import org.netbeans.modules.refactoring.php.findusages.AttributedNodes;
import org.netbeans.modules.refactoring.php.findusages.RefactoringUtils;
import org.netbeans.napi.gsfret.source.CompilationController;
import org.netbeans.napi.gsfret.source.Phase;
import org.netbeans.napi.gsfret.source.Source;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Union2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WhereUsedSupport {
    private ASTNode node;
    private FileObject fo;
    private int offset;
    private Kind kind;
    private AttributedNodes.AttributedElement aElement;
    private AttributedNodes semiAttribs;
    private Results results;
    private Set<Modifier> modifier;
    private PHPIndex idx;

    private WhereUsedSupport(PHPIndex pHPIndex, AttributedNodes.AttributedElement attributedElement, ASTNode aSTNode, FileObject fileObject) {
        this(pHPIndex, attributedElement, aSTNode.getStartOffset(), fileObject, null);
        this.node = aSTNode;
    }

    private WhereUsedSupport(PHPIndex pHPIndex, AttributedNodes.AttributedElement attributedElement, int n, FileObject fileObject, AttributedNodes attributedNodes) {
        this.fo = fileObject;
        this.offset = n;
        this.semiAttribs = attributedNodes;
        this.aElement = attributedElement;
        this.idx = pHPIndex;
        this.kind = WhereUsedSupport.getWhereUsedKind(attributedElement);
        this.results = new Results();
    }

    public String getName() {
        return this.aElement.getName();
    }

    public ASTNode getASTNode() {
        return this.node;
    }

    public FileObject getFileObject() {
        return this.fo;
    }

    public int getOffset() {
        return this.offset;
    }

    public Kind getKind() {
        return this.kind;
    }

    public ElementKind getElementKind() {
        switch (this.getKind()) {
            case CLASS: {
                return ElementKind.CLASS;
            }
            case CONSTANT: {
                return ElementKind.CONSTANT;
            }
            case FUNCTION: {
                return ElementKind.METHOD;
            }
            case VARIABLE: {
                return ElementKind.VARIABLE;
            }
            case METHOD: {
                return ElementKind.METHOD;
            }
            case FIELD: {
                return ElementKind.FIELD;
            }
            case CLASS_CONSTANT: {
                return ElementKind.CONSTANT;
            }
        }
        throw new IllegalStateException();
    }

    public Set<Modifier> getModifiers() {
        AttributedNodes.AttributedElement attributedElement = this.getAttributeElement();
        return this.getModifiers(attributedElement);
    }

    public Results getResults() {
        return this.results;
    }

    private ResultElement createResult(AttributedNodes.AttributedElement attributedElement, ASTNode aSTNode, FileObject fileObject) {
        return new ResultElement(aSTNode, fileObject, attributedElement);
    }

    public static WhereUsedSupport getInstance(CompilationInfo compilationInfo, int n) {
        List<ASTNode> list = RefactoringUtils.underCaret(compilationInfo, n);
        AttributedNodes attributedNodes = AttributedNodes.getInstance(compilationInfo);
        AttributedNodes.AttributedElement attributedElement = null;
        Collections.reverse(list);
        boolean bl = false;
        for (ASTNode aSTNode : list) {
            Identifier identifier;
            Identifier identifier2;
            StaticConstantAccess staticConstantAccess;
            if (aSTNode instanceof StaticConstantAccess) {
                staticConstantAccess = (StaticConstantAccess)aSTNode;
                identifier2 = staticConstantAccess.getClassName();
                identifier = staticConstantAccess.getConstant();
                aSTNode = identifier.getStartOffset() < n ? aSTNode : identifier2;
            } else if (aSTNode instanceof StaticFieldAccess) {
                staticConstantAccess = (StaticFieldAccess)aSTNode;
                identifier2 = staticConstantAccess.getClassName();
                identifier = staticConstantAccess.getField();
                aSTNode = identifier.getStartOffset() < n ? aSTNode : identifier2;
            } else if (aSTNode instanceof ArrayAccess) {
                staticConstantAccess = (ArrayAccess)aSTNode;
                aSTNode = staticConstantAccess.getIndex();
            }
            if ((attributedElement = attributedNodes.getElement(aSTNode)) == null) continue;
            break;
        }
        return attributedElement != null ? new WhereUsedSupport(PHPIndex.get((Index)compilationInfo.getIndex("text/x-php5")), attributedElement, n, compilationInfo.getFileObject(), attributedNodes) : null;
    }

    public void collectUsages(FileObject fileObject) {
        this.collectUsages(fileObject, false);
    }

    public void collectDirectSubclasses(FileObject fileObject) {
        this.collectUsages(fileObject, true);
    }

    private void collectUsages(final FileObject fileObject, final boolean bl) {
        Source source = Source.forFileObject((FileObject)fileObject);
        try {
            source.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                public void run(CompilationController compilationController) throws Exception {
                    compilationController.toPhase(Phase.RESOLVED);
                    AttributedNodes attributedNodes = AttributedNodes.getInstance((CompilationInfo)compilationController);
                    Map<ASTNode, AttributedNodes.AttributedElement> map = null;
                    Map<ASTNode, AttributedNodes.AttributedElement> map2 = map = bl ? attributedNodes.findDirectSubclasses(WhereUsedSupport.this.aElement) : attributedNodes.findUsages(WhereUsedSupport.this.aElement);
                    if (map.size() > 0) {
                        WhereUsedSupport.this.results.addEntry(fileObject, map);
                    }
                }

                public void cancel() {
                }
            }, true);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private static IndexedElement getIndexElement(AttributedNodes.AttributedElement attributedElement) {
        IndexedElement indexedElement = null;
        if (attributedElement != null) {
            List<Union2<ASTNode, IndexedElement>> list = attributedElement.getWrites();
            for (Union2<ASTNode, IndexedElement> union2 : list) {
                if (!union2.hasSecond()) continue;
                indexedElement = (IndexedElement)union2.second();
                break;
            }
        }
        return indexedElement;
    }

    public Set<FileObject> getRelevantFiles() {
        boolean bl;
        LinkedHashSet<FileObject> linkedHashSet = new LinkedHashSet<FileObject>();
        SemiAttrsProviderTask semiAttrsProviderTask = new SemiAttrsProviderTask();
        IndexedElement indexedElement = WhereUsedSupport.getIndexElement(this.aElement);
        if (indexedElement != null) {
            boolean bl2 = bl = !this.fo.equals(indexedElement.getFileObject());
            if (bl) {
                linkedHashSet.add(indexedElement.getFileObject());
                Source source = Source.forFileObject((FileObject)indexedElement.getFileObject());
                try {
                    source.runUserActionTask((CancellableTask)semiAttrsProviderTask, true);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
                this.semiAttribs = semiAttrsProviderTask.get();
            }
        }
        if (bl = this.semiAttribs.hasGlobalVisibility(this.aElement)) {
            linkedHashSet.addAll(this.getAllFiles());
        } else if (indexedElement != null) {
            linkedHashSet.add(indexedElement.getFileObject());
        } else {
            linkedHashSet.add(this.fo);
        }
        return linkedHashSet;
    }

    private Set<? extends FileObject> getAllFiles() {
        LinkedHashSet<FileObject> linkedHashSet = new LinkedHashSet<FileObject>();
        linkedHashSet.add(this.fo);
        linkedHashSet.addAll(this.idx.filesWithIdentifiers(this.getName()));
        return linkedHashSet;
    }

    public AttributedNodes.AttributedElement getAttributeElement() {
        return this.aElement;
    }

    private Set<Modifier> getModifiers(AttributedNodes.AttributedElement attributedElement) {
        if (this.modifier == null) {
            AttributedNodes.ClassMemberElement classMemberElement;
            Set set = Collections.emptySet();
            if (attributedElement != null && attributedElement.isClassMember() && (classMemberElement = (AttributedNodes.ClassMemberElement)attributedElement).getModifier() >= 0) {
                set = new HashSet();
                if (classMemberElement.isPrivate()) {
                    set.add(Modifier.PRIVATE);
                } else if (classMemberElement.isProtected()) {
                    set.add(Modifier.PROTECTED);
                }
                if (classMemberElement.isPublic()) {
                    set.add(Modifier.PUBLIC);
                }
                if (classMemberElement.isStatic()) {
                    set.add(Modifier.STATIC);
                }
            }
            this.modifier = set;
        }
        return this.modifier;
    }

    public static boolean isAlreadyInResults(ASTNode aSTNode, Set<ASTNode> set) {
        OffsetRange offsetRange = new OffsetRange(aSTNode.getStartOffset(), aSTNode.getEndOffset());
        for (ASTNode aSTNode2 : set) {
            OffsetRange offsetRange2 = new OffsetRange(aSTNode2.getStartOffset(), aSTNode2.getEndOffset());
            if (!offsetRange.containsInclusive(offsetRange2.getStart()) && !offsetRange2.containsInclusive(offsetRange.getStart())) continue;
            return true;
        }
        return false;
    }

    public static boolean matchDirectSubclass(AttributedNodes.AttributedElement attributedElement, ASTNode aSTNode, AttributedNodes.AttributedElement attributedElement2) {
        AttributedNodes.ClassElement classElement;
        boolean bl = false;
        if (attributedElement2 != null && attributedElement2 instanceof AttributedNodes.ClassElement && aSTNode instanceof ClassDeclaration && (classElement = ((AttributedNodes.ClassElement)attributedElement2).getSuperClass()) != null && classElement.equals(attributedElement)) {
            bl = true;
        }
        return bl;
    }

    public static boolean match(AttributedNodes.AttributedElement attributedElement, AttributedNodes.AttributedElement attributedElement2) {
        boolean bl;
        boolean bl2 = bl = attributedElement != null && attributedElement2 != null && attributedElement.getName().equals(attributedElement2.getName());
        if (bl) {
            Kind kind;
            Kind kind2 = WhereUsedSupport.getWhereUsedKind(attributedElement2);
            bl = kind2 == (kind = WhereUsedSupport.getWhereUsedKind(attributedElement)) && attributedElement.getScopeName().equals(attributedElement2.getScopeName());
        }
        return bl;
    }

    public static Kind getWhereUsedKind(AttributedNodes.AttributedElement attributedElement) {
        Kind kind = null;
        switch (attributedElement.getKind()) {
            case IFACE: 
            case CLASS: {
                kind = Kind.CLASS;
                break;
            }
            case CONST: {
                kind = attributedElement.isClassMember() ? Kind.CLASS_CONSTANT : Kind.CONSTANT;
                break;
            }
            case FUNC: {
                kind = attributedElement.isClassMember() ? Kind.METHOD : Kind.FUNCTION;
                break;
            }
            case VARIABLE: {
                kind = attributedElement.isClassMember() ? Kind.FIELD : Kind.VARIABLE;
            }
        }
        return kind;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SemiAttrsProviderTask
    implements CancellableTask<CompilationController> {
        private final List<AttributedNodes> attResult = new ArrayList<AttributedNodes>();

        public void run(CompilationController compilationController) throws Exception {
            compilationController.toPhase(Phase.RESOLVED);
            WhereUsedSupport.this.semiAttribs;
            AttributedNodes attributedNodes = AttributedNodes.getInstance((CompilationInfo)compilationController);
            this.attResult.add(attributedNodes);
        }

        public void cancel() {
        }

        public AttributedNodes get() {
            return this.attResult.size() > 0 ? this.attResult.get(0) : null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ResultElement {
        private ASTNode node;
        private FileObject fo;
        private AttributedNodes.AttributedElement aElement;
        private BaseDocument doc;

        private ResultElement(ASTNode aSTNode, FileObject fileObject, AttributedNodes.AttributedElement attributedElement) {
            this.node = aSTNode;
            this.fo = fileObject;
            this.aElement = attributedElement;
        }

        public String getName() {
            return WhereUsedSupport.this.getName();
        }

        public ASTNode getASTNode() {
            return this.node;
        }

        public FileObject getFileObject() {
            return this.fo;
        }

        public int getOffset() {
            return WhereUsedSupport.this.offset;
        }

        public Kind getKind() {
            return WhereUsedSupport.this.kind;
        }

        public ElementKind getElementKind() {
            return WhereUsedSupport.this.getElementKind();
        }

        public Set<Modifier> getModifiers() {
            return WhereUsedSupport.this.getModifiers(this.aElement);
        }

        public BaseDocument getDocument() {
            if (this.doc == null) {
                FileObject fileObject = this.getFileObject();
                try {
                    DataObject dataObject = DataObject.find((FileObject)fileObject);
                    EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                    if (editorCookie != null) {
                        this.doc = (BaseDocument)editorCookie.openDocument();
                    }
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            return this.doc;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Results {
        private Map<FileObject, Map<ASTNode, AttributedNodes.AttributedElement>> data = new LinkedHashMap<FileObject, Map<ASTNode, AttributedNodes.AttributedElement>>();

        private Results() {
        }

        public Collection<FileObject> getFiles() {
            return this.data.keySet();
        }

        public Collection<ResultElement> getResultElements(FileObject fileObject) {
            ArrayList<ResultElement> arrayList = new ArrayList<ResultElement>();
            Map<ASTNode, AttributedNodes.AttributedElement> map = this.data.get(fileObject);
            for (Map.Entry<ASTNode, AttributedNodes.AttributedElement> entry : map.entrySet()) {
                arrayList.add(WhereUsedSupport.this.createResult(entry.getValue(), entry.getKey(), fileObject));
            }
            return arrayList;
        }

        private void addEntry(FileObject fileObject, Map<ASTNode, AttributedNodes.AttributedElement> map) {
            for (Map.Entry<ASTNode, AttributedNodes.AttributedElement> entry : map.entrySet()) {
                this.addEntry(fileObject, entry.getKey(), entry.getValue());
            }
        }

        private void addEntry(FileObject fileObject, ASTNode aSTNode, AttributedNodes.AttributedElement attributedElement) {
            Map<ASTNode, AttributedNodes.AttributedElement> map = this.data.get(fileObject);
            if (map == null) {
                map = new TreeMap<ASTNode, AttributedNodes.AttributedElement>(new Comparator<ASTNode>(){

                    @Override
                    public int compare(ASTNode aSTNode, ASTNode aSTNode2) {
                        return Integer.valueOf(aSTNode.getStartOffset()).compareTo(aSTNode2.getStartOffset());
                    }
                });
                this.data.put(fileObject, map);
            }
            map.put(aSTNode, attributedElement);
            WhereUsedSupport.this.modifier = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Kind {
        CLASS,
        METHOD,
        FIELD,
        VARIABLE,
        CONSTANT,
        FUNCTION,
        CLASS_CONSTANT;

    }
}

