/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.support;

import antlr.Token;
import antlr.TokenStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.apt.support.APTMacro;
import org.netbeans.modules.cnd.apt.utils.APTSerializeUtils;
import org.netbeans.modules.cnd.apt.utils.APTUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class APTMacroMapSnapshot {
    protected final Map<String, APTMacro> macros = new HashMap<String, APTMacro>();
    protected final APTMacroMapSnapshot parent;
    public static final UndefinedMacro UNDEFINED_MACRO = new UndefinedMacro();

    public APTMacroMapSnapshot(APTMacroMapSnapshot aPTMacroMapSnapshot) {
        this.parent = aPTMacroMapSnapshot;
    }

    public final APTMacro getMacro(Token token) {
        return this.getMacro(token.getText());
    }

    public final APTMacro getMacro(String string) {
        APTMacroMapSnapshot aPTMacroMapSnapshot = this;
        while (aPTMacroMapSnapshot != null) {
            APTMacro aPTMacro = aPTMacroMapSnapshot.macros.get(string);
            if (aPTMacro != null) {
                return aPTMacro;
            }
            aPTMacroMapSnapshot = aPTMacroMapSnapshot.parent;
        }
        return null;
    }

    public String toString() {
        HashMap<String, APTMacro> hashMap = new HashMap<String, APTMacro>();
        APTMacroMapSnapshot.addAllMacros(this, hashMap);
        return APTUtils.macros2String(hashMap);
    }

    public static void addAllMacros(APTMacroMapSnapshot aPTMacroMapSnapshot, Map<String, APTMacro> map) {
        if (aPTMacroMapSnapshot.parent != null) {
            APTMacroMapSnapshot.addAllMacros(aPTMacroMapSnapshot.parent, map);
        }
        for (Map.Entry<String, APTMacro> entry : aPTMacroMapSnapshot.macros.entrySet()) {
            if (entry.getValue() != UNDEFINED_MACRO) {
                map.put(entry.getKey(), entry.getValue());
                continue;
            }
            map.remove(entry.getKey());
        }
    }

    public boolean isEmtpy() {
        return this.macros.isEmpty();
    }

    public void write(DataOutput dataOutput) throws IOException {
        APTSerializeUtils.writeSnapshot(this.parent, dataOutput);
        APTSerializeUtils.writeStringToMacroMap(this.macros, dataOutput);
    }

    public APTMacroMapSnapshot(DataInput dataInput) throws IOException {
        this.parent = APTSerializeUtils.readSnapshot(dataInput);
        APTSerializeUtils.readStringToMacroMap(this.macros, dataInput);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UndefinedMacro
    implements APTMacro {
        private UndefinedMacro() {
        }

        public String toString() {
            return "Macro undefined";
        }

        @Override
        public boolean isSystem() {
            throw new UnsupportedOperationException("Not supported in fake impl");
        }

        @Override
        public boolean isFunctionLike() {
            throw new UnsupportedOperationException("Not supported in fake impl");
        }

        @Override
        public Token getName() {
            throw new UnsupportedOperationException("Not supported in fake impl");
        }

        @Override
        public Collection<Token> getParams() {
            throw new UnsupportedOperationException("Not supported in fake impl");
        }

        @Override
        public TokenStream getBody() {
            throw new UnsupportedOperationException("Not supported in fake impl");
        }
    }
}

